# Based on rgQC.py by ross lazarus (Version from 20100914)

########################################################################
# HumMeth27QCReport.py a parser of the HumMeth27QCReport R package
# Copyright (C) 2011  Andreu Alibes (aalibes@gmail.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
########################################################################
from optparse import OptionParser
import os, sys

if __name__ == "__main__":
    u = """ called in xml as
   <command interpreter="python">
        HumMeth27QCReport.py -a '$inputAVE' -c '$inputCTRL' -s '$inputSAMPLE' -d '$inputDISC' -l '$platform' -v '$pval' -m '$ClustMethod' -x '$ChrX' 
-1 '$oQualityCheck' -2 '$oSample' -3 '$oInternalControl' -4 '$oExplorativeAnalysis' -5 '$oNormalizedMvalues' -6 '$oQC_Analysis' -p '$oQualityCheck.files_path'
  </command>

    """
    progname = os.path.basename(sys.argv[0])
    if len(sys.argv) < 14:
        print '%s requires at least 14 parameters - got %d = %s' % (progname,len(sys.argv),sys.argv)
        sys.exit(1)
    parser = OptionParser(usage=u, version="%prog 0.01")
    a = parser.add_option
    a("-a","--avefile",dest="avefile")
    a("-c","--ctrfile",dest="ctrfile")
    a("-s","--smplfile",dest="smplfile")
    a("-d","--discfile",dest="discfile")
    a("-l","--platf",dest="platf")
    a("-v","--pval",dest="pval")
    a("-m","--clustmethd",dest="clustmethd")
    a("-x","--chrx",dest="chrx")
    a("-1","--oQualityCheck",dest="oQualityCheck")
    a("-2","--oSample",dest="oSample")
    a("-3","--oInternalControl",dest="oInternalControl")
    a("-4","--oExplorativeAnalysis",dest="oExplorativeAnalysis")
    a("-5","--oNormalizedMvalues",dest="oNormalizedMvalues")
    a("-6","--oQC_Analysis",dest="oQC_Analysis")
    a("-p","--patho",dest="newfpath")        

    (options,args) = parser.parse_args()
    avefile = options.avefile
    ctrfile = options.ctrfile
    smplfile = options.smplfile
    discfile = options.discfile
    platf = options.platf
    pval = options.pval
    clustmethd = options.clustmethd
    chrx = options.chrx
    oQualityCheck = options.oQualityCheck
    oSample = options.oSample
    oInternalControl = options.oInternalControl
    oExplorativeAnalysis = options.oExplorativeAnalysis
    oNormalizedMvalues = options.oNormalizedMvalues
    oQC_Analysis = options.oQC_Analysis

    newfpath = options.newfpath
    newfpath = os.path.realpath(newfpath)
    try:
       os.makedirs(newfpath)
    except:
       pass
    try:
       os.system("cp " + avefile + " " + newfpath+"/AvgBeta.txt")
       os.system("cp " + ctrfile + " " + newfpath+"/Control.txt")
       os.system("cp " + smplfile + " " + newfpath+"/Sample.txt")
       if(discfile != 'None'):
          os.system("cp " + discfile + " " + newfpath+"/Discard.txt")

       execstring = "/data/apache/galaxy.test.crg/htdocs/galaxy-dist/tools/CRG-Tools/HumMeth27QCReport.R \"Directory=\'"+newfpath+"\'\" \"Plat=\'"+platf+"\'\" \"pvalue=\'"+pval+"\'\" \"chrom=\'"+chrx+"\'\" \"method=\'"+clustmethd+"\'\"" 
       os.system(execstring + " 2> /dev/null")
       os.system("cd " + newfpath + "; mv Sample.pdf " + oSample + "; mv InternalControl.pdf " + oInternalControl + ";mv QualityCheck.pdf " + oQualityCheck + ";mv ExplorativeAnalysis.pdf " + oExplorativeAnalysis + ";mv NormalizedMvalues.txt " + oNormalizedMvalues + ";mv  QC_Analysis.xls " + oQC_Analysis )
    except:
       pass 
