/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.hpsf.TypedPropertyValue;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
class Vector {
    private final short _type;
    private TypedPropertyValue[] _values;

    Vector(byte[] data, int startOffset, short type) {
        this._type = type;
        this.read(data, startOffset);
    }

    Vector(short type) {
        this._type = type;
    }

    int read(byte[] data, int startOffset) {
        int offset = startOffset;
        long longLength = LittleEndian.getUInt(data, offset);
        offset += 4;
        if (longLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Vector is too long -- " + longLength);
        }
        int length = (int)longLength;
        this._values = new TypedPropertyValue[length];
        if (this._type == 12) {
            for (int i = 0; i < length; ++i) {
                TypedPropertyValue value = new TypedPropertyValue();
                offset += value.read(data, offset);
                this._values[i] = value;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                TypedPropertyValue value = new TypedPropertyValue(this._type, null);
                offset += value.readValue(data, offset);
                this._values[i] = value;
            }
        }
        return offset - startOffset;
    }
}

