/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.poibrowser;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.poibrowser.DocumentDescriptor;
import org.apache.poi.poifs.poibrowser.PropertySetDescriptor;

public class TreeReaderListener
implements POIFSReaderListener {
    protected MutableTreeNode rootNode;
    protected Map pathToNode;
    protected String filename;
    private int nrOfBytes = 50;

    public TreeReaderListener(String filename, MutableTreeNode rootNode) {
        this.filename = filename;
        this.rootNode = rootNode;
        this.pathToNode = new HashMap(15);
    }

    public void setNrOfBytes(int nrOfBytes) {
        this.nrOfBytes = nrOfBytes;
    }

    public int getNrOfBytes() {
        return this.nrOfBytes;
    }

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        DocumentDescriptor d;
        DocumentInputStream is = event.getStream();
        if (!is.markSupported()) {
            throw new UnsupportedOperationException(is.getClass().getName() + " does not support mark().");
        }
        try {
            d = new PropertySetDescriptor(event.getName(), event.getPath(), is, this.nrOfBytes);
        }
        catch (HPSFException ex) {
            d = new DocumentDescriptor(event.getName(), event.getPath(), is, this.nrOfBytes);
        }
        catch (Throwable t) {
            System.err.println("Unexpected exception while processing " + event.getName() + " in " + event.getPath().toString());
            t.printStackTrace(System.err);
            throw new RuntimeException(t.getMessage());
        }
        is.close();
        MutableTreeNode parentNode = this.getNode(d.path, this.filename, this.rootNode);
        DefaultMutableTreeNode nameNode = new DefaultMutableTreeNode(d.name);
        parentNode.insert(nameNode, 0);
        DefaultMutableTreeNode dNode = new DefaultMutableTreeNode(d);
        nameNode.insert(dNode, 0);
    }

    private MutableTreeNode getNode(POIFSDocumentPath path, String fsName, MutableTreeNode root) {
        MutableTreeNode n = (MutableTreeNode)this.pathToNode.get(path);
        if (n != null) {
            return n;
        }
        if (path.length() == 0) {
            n = (MutableTreeNode)this.pathToNode.get(fsName);
            if (n == null) {
                n = new DefaultMutableTreeNode(fsName);
                this.pathToNode.put(fsName, n);
                root.insert(n, 0);
            }
            return n;
        }
        String name = path.getComponent(path.length() - 1);
        POIFSDocumentPath parentPath = path.getParent();
        MutableTreeNode parentNode = this.getNode(parentPath, fsName, root);
        n = new DefaultMutableTreeNode(name);
        this.pathToNode.put(path, n);
        parentNode.insert(n, 0);
        return n;
    }
}

