/*
 * Decompiled with CFR 0.152.
 */
package be.cropdesign.iprscan;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RawToExcel {
    private int colnr;
    private int maxNr;
    private int rownr;
    private int maxNrOfGOTerms;
    private XSSFWorkbook wb;
    private XSSFSheet sheet;
    private XSSFRow myRow;
    private XSSFCell myCell;
    private String rawFile;
    private boolean interproInfo;
    private boolean GOInfo;
    private ArrayList<String> titles;

    public RawToExcel(XSSFWorkbook wb, XSSFSheet sheet3, XSSFRow myRow, XSSFCell myCell, String rawFile) {
        this.wb = wb;
        this.sheet = sheet3;
        this.myRow = myRow;
        this.myCell = myCell;
        this.rawFile = rawFile;
        this.maxNr = 0;
        this.maxNrOfGOTerms = 0;
        this.interproInfo = false;
        this.GOInfo = false;
        this.titles = new ArrayList();
        this.parseRaw();
        this.addHeaderTitles();
        this.formatStyle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseRaw() {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(this.rawFile));
                String line = reader.readLine();
                this.rownr = 1;
                while (line != null) {
                    String[] splits = line.split("\t");
                    this.myRow = this.sheet.createRow(this.rownr);
                    this.colnr = 0;
                    String[] stringArray = splits;
                    int n = splits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        this.myCell = this.myRow.createCell(this.colnr);
                        this.myCell.setCellValue(string);
                        if (string.contains("IPR")) {
                            this.interproInfo = true;
                        }
                        if (this.checkRegex("^([0-9]+\\s*)*$", string)) {
                            this.myCell.setCellValue((double)Integer.parseInt(string));
                        }
                        if (this.checkRegex("^[-+]?([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+))*$", string)) {
                            this.formatExponential(string);
                        }
                        if (string.contains("GO:")) {
                            this.GOInfo = true;
                            this.splitGOTerms(string);
                        }
                        this.getMax(this.colnr);
                        ++this.colnr;
                        ++n2;
                    }
                    line = reader.readLine();
                    ++this.rownr;
                    this.myRow = this.sheet.createRow(this.rownr);
                }
                return;
            }
            catch (FileNotFoundException e) {
                System.err.println("The .raw file cannot be found.");
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                System.err.println("An input/output exception occurred while reading the .raw file.");
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void splitGOTerms(String string) {
        if (string != null && !string.isEmpty() && !string.trim().isEmpty()) {
            String modifiedString = string.replace("),", ");");
            String[] splitsClassification = modifiedString.split("; ");
            int numberOfGoTerms = splitsClassification.length;
            this.getMaxNrOfGOTerms(numberOfGoTerms);
            int i = 0;
            while (i < splitsClassification.length) {
                this.myCell = this.myRow.createCell(this.colnr);
                this.myCell.setCellValue(splitsClassification[i].substring(0, splitsClassification[i].indexOf(58)));
                ++this.colnr;
                this.myCell = this.myRow.createCell(this.colnr);
                this.myCell.setCellValue(splitsClassification[i].substring(splitsClassification[i].indexOf(40) + 1, splitsClassification[i].indexOf(41)));
                ++this.colnr;
                this.myCell = this.myRow.createCell(this.colnr);
                this.myCell.setCellValue(splitsClassification[i].substring(splitsClassification[i].indexOf(58) + 2, splitsClassification[i].indexOf(40)));
                ++this.colnr;
                ++i;
            }
        }
    }

    public boolean checkRegex(String regex, String stringToMatch) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(stringToMatch);
        return m.matches() && stringToMatch != null && !stringToMatch.isEmpty() && !stringToMatch.trim().isEmpty();
    }

    public void addHeaderTitles() {
        int i;
        this.titles.add("protein ID");
        this.titles.add("protein crc64");
        this.titles.add("protein length");
        this.titles.add("match dbname");
        this.titles.add("classification id");
        this.titles.add("classification description");
        this.titles.add("start");
        this.titles.add("end");
        this.titles.add("score");
        this.titles.add("status");
        this.titles.add("date");
        if (this.interproInfo) {
            this.titles.add("interpro ID");
            this.titles.add("interpro name");
        }
        if (this.GOInfo) {
            i = 0;
            while (i < this.maxNrOfGOTerms) {
                this.titles.add("title");
                this.titles.add("GO number");
                this.titles.add("description");
                ++i;
            }
        }
        this.myRow = this.sheet.createRow(0);
        i = 0;
        while (i < this.titles.size()) {
            this.myCell = this.myRow.createCell(i);
            this.myCell.setCellValue(this.titles.get(i));
            this.formatHeader();
            ++i;
        }
    }

    public void getMaxNrOfGOTerms(int nr) {
        if (nr > this.maxNrOfGOTerms) {
            this.maxNrOfGOTerms = nr;
        }
    }

    public void formatStyle() {
        this.setAutoFilters();
        this.autoSizeColumns();
        this.freezeRow();
    }

    public void setAutoFilters() {
        if (this.GOInfo) {
            this.sheet.setAutoFilter(CellRangeAddress.valueOf((String)("A1:" + Character.toString((char)(65 + this.maxNr - 1)) + "1")));
        } else {
            this.sheet.setAutoFilter(CellRangeAddress.valueOf((String)("A1:" + Character.toString((char)(65 + this.maxNr)) + "1")));
        }
    }

    public void autoSizeColumns() {
        int column = 0;
        while (column < this.maxNr) {
            this.sheet.autoSizeColumn(column);
            ++column;
        }
    }

    public void getMax(int nr) {
        if (nr > this.maxNr) {
            this.maxNr = nr;
        }
    }

    public void formatHeader() {
        XSSFCellStyle style = this.wb.createCellStyle();
        XSSFFont font = this.wb.createFont();
        font.setColor(new XSSFColor(Color.BLUE));
        font.setBold(true);
        style.setFont((Font)font);
        this.myCell.setCellStyle((CellStyle)style);
    }

    public void freezeRow() {
        this.sheet.createFreezePane(0, 1, 0, 1);
    }

    public void formatExponential(String s) {
        if (s.equals("NA")) {
            this.myCell.setCellValue("NA");
        } else {
            XSSFCellStyle cs = this.wb.createCellStyle();
            XSSFDataFormat df = this.wb.createDataFormat();
            cs.setDataFormat(df.getFormat("0.0E+0"));
            this.myCell.setCellValue(Double.parseDouble(s));
            this.myCell.setCellStyle((CellStyle)cs);
        }
    }

    public void setColnr(int colnr) {
        this.colnr = colnr;
    }

    public int getColnr() {
        return this.colnr;
    }

    public void setNrOfGOTerms(int nrOfGOTerms) {
        this.maxNrOfGOTerms = nrOfGOTerms;
    }

    public int getNrOfGOTerms() {
        return this.maxNrOfGOTerms;
    }
}

