import sys, os, os.path, tempfile, shutil, re, shlex, subprocess

def stop_err( msg ):
    sys.stderr.write( "%s\n" % msg )
    sys.exit()

# tranform fastx_barcode_splitter result to html
def results_to_html(results_path,html_path,basepath,print_stdout ):
    pat = '%s[/]?([^\t]*)' % basepath
    rep = '<a href=\"\\1\">\\1</a>'
    txt = open(results_path,'r')
    html = open(html_path,'w')
    html.write('<html><body><table border=1>\n')
    try:
        for line in txt:
            html.write('<tr><td>%s</td></tr>' % re.sub('\t','</td><td>',re.sub(pat,rep,line)))
            if print_stdout:
                print >> sys.stdout, '\t'.join(line.split('\t')[:2])
    except Exception, e:
        print(str(e))
        pass
    html.write('</table></body></html>\n')
    html.close()
    txt.close()

def __main__():
    """
           ##params for galaxy wrapper
           $output
           "$output.id"
           "$input.ext"
           "$__new_file_path__"
           --barcodes='$barcodes'
           $BARCODE $input "$input.name" "$output.extra_files_path"
           ## params for fastx_barcode_splitter
            --mismatches $mismatches --partial $partial $EOL
    """
    output = sys.argv[1]
    output_id = sys.argv[2]
    file_ext = sys.argv[3]
    new_file_path = sys.argv[4]
    select_barcodes = sys.argv[5].replace('--barcodes=','')
    barcodes = sys.argv[6]
    fastx = sys.argv[7]
    fastx_name = sys.argv[8]
    extra_files_path = sys.argv[9]
    script_args = ' '.join(sys.argv[10:])
    #Sanitize library name, make sure we can create a file with this name
    lib_name = re.sub('\W','_',re.sub('\.\W*$','',fastx_name))+'_'
    prefix = os.path.join(extra_files_path,lib_name)
    # Check that input datasets exist
    if not os.path.isfile(fastx):
        stop_err('Error: Input file (%s) not found!' % fastx)
    if not os.path.isfile(barcodes):
        stop_err('Error: barcode file (%s) not found!' % barcodes)
    try:
        # Check that extra_files_path exists
        if not os.path.isdir(extra_files_path):
            os.makedirs(extra_files_path)
        cmd_line = 'zcat -f %s | fastx_barcode_splitter.pl --bcfile %s --prefix %s --suffix %s %s' %(fastx,barcodes,prefix,'.'+file_ext,script_args)
        # print >> sys.stderr, cmd_line 
        # Create file to collect results written to stdout
        tmp_dir = tempfile.mkdtemp()
        result_path = tempfile.NamedTemporaryFile(dir=tmp_dir, prefix='results_', suffix='.out' ).name
        result_file = open( result_path, 'wb' )
        proc = subprocess.Popen( args=cmd_line, shell=True, cwd=tmp_dir, stderr=subprocess.PIPE,stdout=result_file.fileno() )
        returncode = proc.wait()
        result_file.close()
        stderr = proc.stderr.read()
        if returncode != 0:
            raise Exception, stderr
        # copy results to ouptut
        results_to_html(result_path,output,extra_files_path,True)
        # make new datasets for selected barcodes
        if select_barcodes != None and len(select_barcodes) > 0:
            flist = os.listdir(extra_files_path)
            for barcode in select_barcodes.split(','):
                for fname in flist:
                    if fname.find('_'+barcode+'.'+file_ext) >= 0:
                        fpath = os.path.join(extra_files_path,fname)
                        # filename pattern required by galaxy 
                        fn = "%s_%s_%s_%s_%s" % ( 'primary', output_id, barcode, 'visible', file_ext )
                        npath = os.path.join(new_file_path,fn)
                        try:
                            os.link(fpath, npath)
                        except:
                            shutil.copy2(fpath, npath)
    except Exception, e:
        raise Exception, 'Exception caught attempting conversion: ' + str( e )

if __name__ == "__main__": __main__()
