# Tutorials

Learn COBRAxy through hands-on tutorials for web-based analysis.

## Available Tutorials

| Tutorial | Duration | Description |
|----------|----------|-------------|
| [Galaxy Setup](tutorials/galaxy-setup) | 30 min | Set up Galaxy for web-based analysis |

## Web Interface Tutorial

### [Galaxy Setup Tutorial](tutorials/galaxy-setup)

Set up a local Galaxy instance with COBRAxy tools for point-and-click analysis. Perfect for users who prefer graphical interfaces and reproducible workflows.

## Prerequisites

Before starting the tutorials, make sure you have:

- ✅ [COBRAxy installed](installation)
- ✅ Basic understanding of metabolic modeling (helpful but not required)
- ✅ Familiarity with command line basics

## Tutorial Data

Download example datasets used in tutorials:

```bash
# Download tutorial data
wget https://github.com/CompBtBs/COBRAxy/releases/download/v1.0/tutorial_data.zip
unzip tutorial_data.zip
```

The tutorial data includes:
- Sample gene expression datasets
- Metabolite abundance data  
- Pre-configured Galaxy workflows
- Expected output files for verification

## Getting Help

If you encounter issues during tutorials:

1. Check the specific tutorial's troubleshooting section
2. Refer to the main [Troubleshooting Guide](/troubleshooting.md)

## Contributing

Found an error or want to improve a tutorial? 

- [Edit on GitHub](https://github.com/CompBtBs/COBRAxy/tree/main/docs/tutorials)
- [Report issues](https://github.com/CompBtBs/COBRAxy/issues)
- Suggest new tutorial topics

Ready to start? Pick your first tutorial above! 🚀