# Tutorials

Learn COBRAxy through hands-on tutorials for web-based analysis.

To set up Galaxy and start using it for web-based analyses, see the [Galaxy Setup](tutorials/galaxy-setup)

## Available Workflows

This is a collection of GALAXY workflows illustrating different applications of the tool.
The general repository is at the following link: [Galaxy workflows](http://marea4galaxy.cloud.ba.infn.it/galaxy/workflows/list_published). 

To use a workflow, click the "Import" button, and it will be added to your personal workflow page.

| Tutorial | Description |
|----------|-------------|
|[Flux Enrichment Analysis - separated datasets](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=a64417ff266b740e) | Creation of maps of the fluxes differently expressed between two conditions. One gene expression dataset different for each condition. |
| [Flux Enrichment Analysis (sampling mean) - separated datasets](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=16e792953f5b45db) |  Creation of maps of the fluxes differently expressed between two conditions. One gene expression dataset different for each condition. |
| [Flux clustering (sampling mean) + Flux Enrichment Analys](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=c851ab275e52f8af) | Creation of maps of the fluxes, using one dataset differently expressed for each condition and its sample group specification|
| [Flux Enrichment Analysis (pFBA) - separated datasets](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=bf0806da5b28c6d9) | Creation of maps of the fluxes differently expressed between two conditions. One gene expression dataset different for each condition. |
| [Flux clustering (pFBA) + Flux Enrichment Analysis](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=be0a27b9edd0db03) | Creation of maps of the fluxes, using one dataset differently expressed for each condition and its sample group specification |
| [RAS clustering + Reaction Enrichment Analysis](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=81991b32733a4fc4) | Creation of RAS maps, one single expression gene dataset and its sample group specification |
| [Reaction Enrichment Analysis - unified datasets](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=0d16186aaff7cbfd) |Creation of RAS maps starting from an expression dataset and its corresponding classes. One gene expression dataset as input and its classes to compare. |
| [Reaction Enrichment Analysis - separated datasets](http://marea4galaxy.cloud.ba.infn.it/galaxy/published/workflow?id=290670ee50ab85f0) | Creation of RAS maps using the tool MaREA. Confrontation of two datasets that must be different from one another. |

A more detailed description of the tools is available on the corresponding GALAXY page.

## Tutorial Data

Download example datasets used in tutorials:

```bash
# Download tutorial data
wget https://github.com/CompBtBs/COBRAxy/blob/main/data_tutorial/data_tutorial.zip
unzip tutorial_data.zip
```

The tutorial data includes Sample gene expression datasets (Cancer.txt and Normal.txt)

## Getting Help

If you encounter issues during tutorials:

1. Check the specific tutorial's troubleshooting section
2. Refer to the main [Troubleshooting Guide](troubleshooting)

## Contributing

Found an error or want to improve a tutorial? 

- [Edit on GitHub](https://github.com/CompBtBs/COBRAxy/tree/main/docs/tutorials)
- [Report issues](https://github.com/CompBtBs/COBRAxy/issues)
- Suggest new tutorial topics

Ready to start? Pick your first tutorial above! 🚀
