use Getopt::Long;
use strict;

use Cwd;
my $PROG = $0;
my $CUR_DIR = Cwd::abs_path(Cwd::cwd());
my $PROG_ABS_PATH = Cwd::abs_path($PROG);
my $SrcFolder=`dirname $PROG_ABS_PATH`;
chomp($SrcFolder);

#my $SrcFolder="/data/zhang/wuj/scripts/SpliceTrap.0.8/";
my $InputFileName=$ARGV[0];
my $OutputFileName = $ARGV[0].".hist";
#$OutputFileName=$ARGV[1] if $ARGV[1] ne "";
my $width=0.001;
my $verbose=1;
my $col=2;

GetOptions (
        'w:f'=>\$width,
        'c:i'=>\$col,
        'v'=>\$verbose
);

$width=$width*1;
my $binnum=1/$width;
$col=$col-1;

my @CAratios;
my @CSratios;
my @ADratios;
my @AAratios;
my @AIratios;
my @IRratios;

open(Input, $InputFileName);
while(my $line=<Input>)
{
        next if($line=~/^#/);
        chomp($line);
        my @array=split(/\s/,$line);
	next if($array[$col]<=0.001 or $array[$col]>=0.999);
#        push( @CAratios,$array[$col]) if($array[0]=~/^C[AS]/ or $array[0]=~/^ME/);
	push( @CAratios,$array[$col]) if($array[0]=~/^CA/ or $array[0]=~/^ME/);
	push( @CSratios,$array[$col]) if($array[0]=~/^CS/);
	push( @ADratios,$array[$col]) if($array[0]=~/^AD/);
	push( @AAratios,$array[$col]) if($array[0]=~/^AA/);
	push( @AIratios,$array[$col]) if($array[0]=~/^AI/);
	push( @IRratios,$array[$col]) if($array[0]=~/^IR/);

}

close(Input);

open(tmpFile, ">$InputFileName.tmpca");
for(my $i=0;$i<@CAratios;$i++)
{
	print tmpFile $CAratios[$i],"\n";
}
close(tmpFile);
open(tmpFile, ">$InputFileName.tmpcs");
for(my $i=0;$i<@CSratios;$i++)
{
        print tmpFile $CSratios[$i],"\n";
}
close(tmpFile);


open(tmpFile, ">$InputFileName.tmpad");
for(my $i=0;$i<@ADratios;$i++)
{
        print tmpFile $ADratios[$i],"\n";
}
close(tmpFile);

open(tmpFile, ">$InputFileName.tmpaa");
for(my $i=0;$i<@AAratios;$i++)
{
        print tmpFile $AAratios[$i],"\n";
}
close(tmpFile);

open(tmpFile, ">$InputFileName.tmpai");
for(my $i=0;$i<@AIratios;$i++)
{
        print tmpFile $AIratios[$i],"\n";
}
close(tmpFile);

open(tmpFile, ">$InputFileName.tmpir");
for(my $i=0;$i<@IRratios;$i++)
{
        print tmpFile $IRratios[$i],"\n";
}
close(tmpFile);

system("R --slave --args $InputFileName.tmpca <$SrcFolder/beta_fit.R");
system("R --slave --args $InputFileName.tmpad <$SrcFolder/beta_fit.R");
system("R --slave --args $InputFileName.tmpaa <$SrcFolder/beta_fit.R");
#system("R --slave --args $InputFileName.tmpai <$SrcFolder/R/beta_fit.R");
system("R --slave --args $InputFileName.tmpir <$SrcFolder/beta_fit.R");
system("R --slave --args $InputFileName.tmpcs <$SrcFolder/beta_fit.R");

system("echo '#Width:$width' >$InputFileName.fit.hist");
#system("paste $InputFileName.tmpca.fit $InputFileName.tmpad.fit $InputFileName.tmpaa.fit $InputFileName.tmpai.fit $InputFileName.tmpir.fit $InputFileName.tmpcs.fit >>$InputFileName.fit.hist");

system("paste $InputFileName.tmpca.fit $InputFileName.tmpad.fit $InputFileName.tmpaa.fit $InputFileName.tmpir.fit $InputFileName.tmpcs.fit >>$InputFileName.fit.hist");
#system("rm $InputFileName.tmpca* $InputFileName.tmpad* $InputFileName.tmpaa* $InputFileName.tmpai* $InputFileName.tmpir* ");
