# Author: wuj@cshl.edu
use strict;
use Getopt::Long;
####################
my %config=do "$ENV{HOME}/.SpliceTrap.pl.ini";
my $SrcFolder=$config{SrcFolder};
#my $SrcFolder="/data/zhang/wuj/tools/SpliceTrap.0.8";
####################
my $MapSoftware="eland";
my $ReadFileFormat="";
my $ReadFile1Name="";
my $ReadFile2Name="";
my $CutoffLevel="H";
my $OutputPrefix="Result";
my $CutoffOnly=0;
my $ReadSize=36;

GetOptions (
	"m:s"=>\$MapSoftware,
	"f:s"=>\$ReadFileFormat,
	"1:s"=>\$ReadFile1Name,
	"2:s"=>\$ReadFile2Name,
	"c:s"=>\$CutoffLevel,
	"o:s"=>\$OutputPrefix,
	"s:i"=>\$ReadSize,
#	"local:s"=>\$local,
	"rerun"=>\$CutoffOnly
);


my $InputParaDes="	Usage of the script (v0.82):
	-m	Mapping software: eland/bowtie/rmap
	-f	Read File Format: fasta/fastq
	-1	Read File 1
	-2	Read File 2
	-c	Cutoff Level:H/M/L
		Means High, Middle or Low
	-o	Output prefix
	-s	Read Size 36
	--rerun	Only run the last step, which is filtering
";

if($ReadFile1Name eq "" or $ReadFile2Name eq "" or $ReadFileFormat eq "")
{
	print $InputParaDes;
	exit;
}

if($ReadFileFormat ne "fastq" and $ReadFileFormat ne "fasta")
{
        print $InputParaDes;
        exit;

}

if($CutoffLevel ne "H" and  $CutoffLevel ne "M" and  $CutoffLevel ne "L")
{
	print $InputParaDes;
        exit;
}

my $dirname1=`dirname $ReadFile1Name`;
my $dirname2=`dirname $ReadFile2Name`;
if($dirname1 ne ".")
{
	        system("ln -s $ReadFile1Name ./");
}
if($dirname2 ne ".")
{
	        system("ln -s $ReadFile2Name ./");
}

$ReadFile1Name = `basename $ReadFile1Name`;
chomp($ReadFile1Name);
$ReadFile2Name = `basename $ReadFile2Name`;
chomp($ReadFile2Name);
my $start = time;
if($MapSoftware eq "bowtie")
{
	print "=================STAGE 1 MAPPING===================\n";
	system("bash $SrcFolder/mapping_bowtie.sh $ReadFile1Name $ReadFileFormat") if not $CutoffOnly;
        system("bash $SrcFolder/mapping_bowtie.sh $ReadFile2Name $ReadFileFormat") if not $CutoffOnly;
	print "STAGE 1 FINISHED IN ",time-$start," seconds\n";
	print "=================STAGE 2 ESTIMATION================\n";

	system("bash $SrcFolder/batch_para_cov10p_fit.sh $ReadFile1Name $ReadFile2Name $OutputPrefix $ReadSize") if not $CutoffOnly;
	print "STAGE 2 FINISHED IN ",time-$start," seconds\n";
	print "=================STAGE 3 CUTOFF====================\n";
        system("bash $SrcFolder/apply_cutoff.sh $OutputPrefix $CutoffLevel");
	print "STAGE 3 FINISHED IN ",time-$start," seconds\n";
	


}

if($MapSoftware eq "rmap")
{
	print "=================STAGE 1 MAPPING===================\n";
	
        system("bash $SrcFolder/mapping_rmap.sh $ReadFile1Name $ReadFileFormat") if not $CutoffOnly;
        system("bash $SrcFolder/mapping_rmap.sh $ReadFile2Name $ReadFileFormat") if not $CutoffOnly;
	print "=================STAGE 2 ESTIMATION================\n";
	
        system("bash $SrcFolder/batch_para_cov10p_fit.sh $ReadFile1Name $ReadFile2Name $OutputPrefix $ReadSize") if not $CutoffOnly;
	print "=================STAGE 3 CUTOFF====================\n";
        system("bash $SrcFolder/apply_cutoff.sh $OutputPrefix $CutoffLevel");


}

print "============ALL DONE, OUTPUTFILE:$OutputPrefix.txt\n";
