use strict;
exit;

my %config=do "$ENV{HOME}/.SpliceTrap.pl.ini";
my $SrcFolder=$config{SrcFolder};

my $BedFileName=$SrcFolder."/db/TXdb.1101.bed";
my $RatioFileName=$ARGV[0];
my $BedFileOutName=$ARGV[1];
my %Ratios;

open(RatioFile, $RatioFileName);

while(my $RatioLine=<RatioFile>)
{
	chomp($RatioLine);
	my @array=split("\t",$RatioLine);
	$Ratios{$array[0]}=$array[2] if $array[14] eq "passed";
}

close(RatioFile);

open(BedFile, $BedFileName);
open(BedFileOut,">".$BedFileOutName.".bed");
print BedFileOut "track name=$BedFileOutName discription=$BedFileOutName useScore=1\n";
while(my $BedLine=<BedFile>)
{
	my @array=split("\t",$BedLine);
	$array[3]=~/^(\S*)\[([LS])\]/;
	my $id=$1;
	my $LS=$2;
	#print $LS,"\n";
	next if not exists $Ratios{$id};
	$array[4]=$Ratios{$id};
	$array[4]=1-$Ratios{$id} if( $LS eq 'S');

	$array[4]=sprintf("%.0f",$array[4]*1000);
	for (my $i=0;$i<@array; $i++)
	{
		print BedFileOut $array[$i];
		print BedFileOut "\t" if $i<scalar(@array)-1;
	}
	#print BedFileOut "\n";
}
close(BedFileOut);
close(BedFile);
