library(riboSeqR)
fastaCDS_REF <- findCDS(fastaFile='rsem_chlamy236_deNovo.transcripts.fa', startCodon=c("ATG"), stopCodon=c("TAG", "TAA", "TGA"))
ribofiles <- paste("chlamy236_plus_deNovo_plusOnly_Index", c(17,3,5,7), sep = "")
rnafiles <- paste("chlamy236_plus_deNovo_plusOnly_Index", c(10,12,14,16), sep = "")
riboDat_REF <- readRibodata(ribofiles, rnafiles, replicates=c("WT", "WT", "M", "M"))
fCs_REF <- frameCounting(riboDat_REF, fastaCDS_REF)
fS_REF <- readingFrame(rC = fCs_REF)

pdf(file="/tmp/Periodicity-plot.pdf")
plotFS(fS_REF, legend.text = c('Frame 0', 'Frame 1', 'Frame 2'))
dev.off()

ffCs_REF <- filterHits(fCs_REF, lengths=c(27,28), frames=list(1,0), hitMean = 50, unqhitMean = 10, fS=fS_REF)
pdf(file='/tmp/Metagene-analysis-plot.pdf')
plotCDS(coordinates=ffCs_REF@CDS, riboDat=riboDat_REF, lengths=27)
plotCDS(coordinates=ffCs_REF@CDS, riboDat=riboDat_REF, lengths=28)
dev.off()

pdf(file='/tmp/Ribosome-profile-plot.pdf')
plotTranscript("CUFF.37930.1", coordinates=ffCs_REF@CDS, riboData=riboDat_REF, length=27, cap=200)
dev.off()

riboCounts_REF <- sliceCounts(ffCs_REF, lengths = c(27,28), frames = list(0,2))
rnaCounts_REF <- rnaCounts(riboDat_REF, ffCs_REF@CDS)

save('fastaCDS_REF', 'riboDat_REF', 'fCs_REF', 'fS_REF', 'ffCs_REF', 'riboCounts_REF', 'rnaCounts_REF', file='Robjects.rda')








