#!/usr/bin/env ruby
##
## Wrapper Arpa 
##
## By: Isis Soledad, 2015
##
## Updates: 
##      - Rodrigo Jardim, 206
##

# ARGV[0] - Output File
# ARGV[1] - Input File in Fasta Format
# ARGV[2] - ARPA Complement Parameters 
output = ARGV[0]
dirOut = "/tmp/arpa_#{Time.now.strftime("%Y%m%d%H%M%S")}"
file = ARGV[1]
params = ARGV[2]

# Create Output temporary dir
unless File.directory?(dirOut)
    Kernel.system("mkdir #{dirOut}")
end

# Copy Input file to temporary dir
unless File.exist?("#{dirOut}/#{File.basename(file)}")
    Kernel.system("cp #{file} #{dirOut}/#{File.basename(file)}.fasta")
end

#puts "python /usr/local/arpa/arpa.py #{params} -o #{dirOut} #{dirOut}/#{File.basename(file)}.fasta 1>/dev/null"

# Call OS process
Kernel.system("python /usr/local/arpa/arpa.py #{params} -o #{dirOut} #{dirOut}/#{File.basename(file)}.fasta 1>/dev/null")

# Copact temporary dir
Kernel.system("cd #{dirOut} && zip output.zip *"

# Copy compact file to output galaxy
Kernel.system("cp #{dirOut}/output.zip #{output}")

# Remove temporary dir
Kernel.system("rm -rf #{dirout}")
