#!/usr/bin/ruby
##########################################################
##     Wrapper to convert SFF to Fasta
##
##     Author: Biowebdb, 2014
##
##     This tool needs sff_extraxt version 0.28 or higher
##     in path directory or $SFF_EXTRACT
##
##     This tool need Biowebdb Ruby Lib 
##     (http://biowebdb.org)
##     
##########################################################
require "logger"
require "#{ENV['biowebdb']}/bioinformatics/Bioinformatics"

c = Bioinformatics.program "Sff"
c.logger(Logger.new(STDOUT))
c.workPath="/tmp/"
c.input = ARGV[0]
if ARGV.size == 2
	c.format = 'FASTQ'
else
	c.format = 'FASTA'
end
c.outputDir = "/tmp/#{Time.new.strftime("%Y%m%d%H%M%S")}"
c.execute(c.lineCommand)

basename = File.basename(c.input, '.*')

if c.format == 'FASTQ'
	Kernel.system("mv #{c.outputDir}/*.fastq #{ARGV[1]}")
else
	Kernel.system("mv #{c.output} #{ARGV[1]}")
	Kernel.system("mv #{c.outputQual} #{ARGV[2]}")
end