#gpffilemaker makes the GPF file

#!/usr/bin/env Rscript      
args = commandArgs(trailingOnly=TRUE) 

if(length(args) < 1){
  stop("USE: Rscript gpffilemaker.R <receptor_name> <session_dir>")
}

#Read file containing PDB geometric center and number of points x, y ,z  
#archivo_center_npts <- scan("/home/galaxy/galaxy/tools/proteindocking/scripts/pdbcenter_npts.txt", what = character(), quiet = TRUE)
archivo_center_npts <- scan("pdbcenter_npts.txt", what = character(), quiet = TRUE)

#Read file containing receptor atom types
ver <- scan("receptor_atm_types.txt", what = character(), quiet = TRUE, na.strings = "NULLAJSKAJSFL")


#Arguments definition 
receptor_name <- args[1]
session_dir <- args[2]
aux_receptor_name <- basename(args[1])
#aux_receptor_name <- paste("/home/galaxy/galaxy/tools/proteindocking/scripts/", basename(args[1]), sep="")
npts_x <- archivo_center_npts[4]
npts_y <- archivo_center_npts[5]
npts_z <- archivo_center_npts[6] 
gridcenter_x <- archivo_center_npts[1]
gridcenter_y <- archivo_center_npts[2]
gridcenter_z <- archivo_center_npts[3]

#Creation of the GPF file
#Row 1 
fila_1_e1 <- paste("npts", npts_x, sep = " ")
fila_1_e2 <- paste(fila_1_e1, npts_y, sep = " ")
fila_1_e3 <- paste(fila_1_e2, npts_z, sep = " ")
fila_1 <- paste(fila_1_e3, "# num.grid points in xyz", sep = " ")

#Row 2 
fila_2_e2 <- paste(aux_receptor_name, ".maps.fld", sep = "")
fila_2_e1 <- paste("gridfld", fila_2_e2, sep = " " )
fila_2 <- paste(fila_2_e1, "# grid_data_file", sep = " ")

#Row 3 
fila_3 <- paste("spacing 1.0", "# spacing(A)", sep = " ")

#Row 4 
#fila_4 <- paste("receptor_types A C HD N NA OA S SA", "# receptor atom types", sep = " ")
cabecera_f4 <-  ver[1]
vector_f4 <- c()
for(f4 in 2:length(ver)){
  cabecera_f4 <- paste(cabecera_f4, ver[f4], sep = " ")
}

fila_4 <- paste("receptor_types", cabecera_f4, "# receptor atom types", sep = " ")
#print(fila_4)

#Row 5  
fila_5 <- paste("ligand_types C HD OA", "# ligand atom types", sep = " ")

#Row 6 
fila_6_e2 <- paste(aux_receptor_name, ".pdbqt", sep = "")
fila_6_e1 <- paste("receptor", fila_6_e2, sep = " ")
fila_6 <- paste(fila_6_e1, "# macromolecule", sep = " ")

#Row 7 
fila_7_e1 <- paste("gridcenter",gridcenter_x, sep = " ")
fila_7_e2 <- paste(fila_7_e1, gridcenter_y, sep = " ")
fila_7_e3 <- paste(fila_7_e2, gridcenter_z, sep = " ")
fila_7 <- paste(fila_7_e3, "# xyz-coordinates or auto", sep = " ")

#Row 8  
fila_8 <- paste("smooth 0.5", "# store minimum energy w/in rad(A)", sep = " ")

#Row 9 
fila_9_e2 <- paste(aux_receptor_name, ".C.map", sep = "")
fila_9_e1 <- paste("map", fila_9_e2, sep = " ")
fila_9 <- paste(fila_9_e1, "# atom-specific affinity map", sep = " ")

#Row 10 
fila_10_e2 <- paste(aux_receptor_name, ".HD.map", sep = "")
fila_10_e1 <- paste("map",fila_10_e2, sep = " ")
fila_10 <- paste(fila_10_e1, "# atom-specific affinity map", sep = " ")

#Row 11 
fila_11_e2 <- paste(aux_receptor_name, ".OA.map", sep = "")
fila_11_e1 <- paste("map", fila_11_e2, sep = " ")
fila_11 <- paste(fila_11_e1, "# atom-specific affinity map", sep = " ")

#Row 12 
fila_12_e2 <- paste(aux_receptor_name, ".e.map", sep = "")
fila_12_e1 <- paste("elecmap", fila_12_e2, sep = " ")
fila_12 <- paste(fila_12_e1, "# electrostatic potential map", sep = " ")

#Row 13
fila_13_e2 <- paste(aux_receptor_name, ".d.map", sep = "")
fila_13_e1 <- paste("dsolvmap", fila_13_e2, sep = " ")
fila_13 <- paste(fila_13_e1, "# desolvation potential map", sep = " ")

#Row 14
fila_14 <- paste("dielectric -0.1465", "# <0, AD4 distance-dep.diel;>0, constant", sep = " ")

#Paste all rows with a line jump for separation 
filas <- c(fila_1, fila_2, fila_3, fila_4, fila_5, fila_6, fila_7, fila_8, fila_9, fila_10, fila_11, fila_12, fila_13, fila_14)

datos<- c()
for(i in 1:14){
datos <- paste(c(datos, filas[i]))
}

#nombre_final <- paste("/home/galaxy/galaxy/tools/proteindocking/scripts/", basename(args[1]), ".gpf", sep="")
nombre_final <- paste(basename(args[1]), ".gpf", sep="")

write(datos, file=nombre_final, append = FALSE)

#write(basename(args[1]), file= paste("/home/galaxy/galaxy/tools/proteindocking/scripts/", basename(args[1]), ".txt", sep="")) #parte añadida 18jun2018 
write(basename(args[1]), file= paste(basename(args[1]), ".txt", sep="")) #parte añadida 18jun2018 

