#!/usr/bin/env Rscript      # siempre va comentado, la consola lo interpreta asi. 
args = commandArgs(trailingOnly=TRUE) # siempre es asi, no cambia.

if(length(args) < 10){
  # stop("USE: Rscript.exe vinafilemarkerclusters.R <receptor_PDBQT> <ligand_PDBQT> <out_PDBQT> <log_file> <coo_x > <coo_y> <coo_z> <eboxsizedata> <galaxy_output> <v>")
   stop("USE: Rscript vinafilemarkerclusters.R <receptor_PDBQT> <ligand_PDBQT> <out_PDBQT> <log_file> <coo_x > <coo_y> <coo_z> <eboxsizedata> <v> <session_dir>")
 }


receptor_PDBQT <- args[1]
ligand_PDBQT <- args[2]
out_PDBQT <- args[3]
log_file <- args[4]
eboxsizedata <- args[8]
v <- args[9]
session_dir <- args[10]

setwd(session_dir)

receptor_data <- paste("receptor =", args[1], sep = " ")
ligando_data <- paste("ligand =" , args[2], sep = " ")
out_data <- paste("out =" , args[3], sep = " ")
log_file <- paste("log =", args[4], sep = " ")
center_x_data <- paste("center_x =", args[5], sep =" ")
center_y_data <- paste("center_y =", args[6], sep =" ")
center_z_data <- paste("center_z =", args[7], sep =" ")
aux <- as.numeric(scan(args[8], what="character", quiet=TRUE), quiet=TRUE)
size_x_data <- paste("size_x =", aux, sep = " ")
size_y_data <- paste("size_y =", aux, sep = " ")
size_z_data <- paste("size_z =", aux, sep = " ")

campos <- c(receptor_data,ligando_data, out_data, log_file, center_x_data, center_y_data, center_z_data, size_x_data, size_y_data, size_z_data)

datos <- c()
for(i in 1:length(campos)){
  datos <-paste(c(datos, campos[i], sep="\n"))
}

write(datos, file=paste(v, "_vinaconfig", sep = ""), append=FALSE)

