#pdbqtcorrector.R corrests the out PDBQT file from AutoDockTools prepare receptor 

#!/usr/bin/env Rscript      
args = commandArgs(trailingOnly=TRUE) 

if(length(args) < 1){
  stop("USE: Rscript pdbqtcorrector.R <receptor_name> <receptor_pdbqt_modified>")
}

#Argument definition
receptor_name <- args[1]

#Scan file
original_file <- scan(args[1], what = character(), quiet = TRUE, na.strings = "NULLAJSKAJSFL")

#Calculate first root word and "TER"
for(e in 1:length(original_file)){
  if(original_file[e] == "ATOM" || original_file[e] == "HETATM" || original_file[e] == "TER"){
    k <- e
    break
  }
}

#Calculate the row number for table which conteins aligned x,y,z coordenates 
counter <- 0
for(c in e:length(original_file)){
  if(original_file[c] == "ATOM" || original_file[c] == "HETATM" || original_file[c] == "TER"){
    counter <- counter + 1
  }
}

#Table to be fills in named tabla_ordenados
tabla_ordenados <- matrix(1, nrow = (counter), ncol = 13)

#Calculate TER times and make a vector
ele_ter_vector <- 1
ter_vector <- c()
k_position <- c()
for(o in 1:(length(original_file))){
  if(original_file[o] =="TER"){
    k_position <- c(k_position, o)
    for(g in o:(o+4)){
      ter_vector <- c(ter_vector,original_file[g] )
    }
    
  }
}

#Fill in the tabla_ordenados with values scaned until counter-1 since last row (ter) has diferent length and this could give you back an error
for(i in 1:(counter-1)){
  for(j in 1:13){
    tabla_ordenados[i,j] <- original_file[k]
    if(tabla_ordenados[i,13]=="ATOM" || tabla_ordenados[i,13]== "HETATM"|| tabla_ordenados[i,13]=="TER"){
      corte <- c()
      for(v in 4:12){
        corte <- c(corte,tabla_ordenados[i,v])
      }
      coo_corte <- 1
      tabla_ordenados[i,4] <- ""
      for(m in 5:13){
        tabla_ordenados[i,m] <- corte[coo_corte]
        coo_corte <- coo_corte + 1
      }
      k <- k-1
    }
    k <- k + 1 
  }
  if(tabla_ordenados[i,1]=="TER"){
    k <- k - 8
  } 
}


#Fill in TER row until last one 
star_ter <- 2
mmm <- 1
for(ii in 1:counter){
  if(tabla_ordenados[ii,1]=="TER"){
    k <- k_position[mmm] + 4
    mmm <- mmm + 1
    y <- 2
    for(l in star_ter:(star_ter+3)){
      if(y%%3==0 && y!=6){
        tabla_ordenados[ii,y] <- ""
        y <- y + 1
        tabla_ordenados[ii,y] <- ter_vector[l]
      }
      tabla_ordenados[ii,y] <- ter_vector[l]
      y <- y +1
    }
    star_ter <- star_ter + 5
    for(b in 7:13){
      tabla_ordenados[ii,b] <- ""
    }
  }
}

#Fill in last row with TER row values 
last_ter <- length(ter_vector)-4
for(jj in 1:6){
  tabla_ordenados[counter,jj] <- ter_vector[last_ter]
  if(jj%%3==0 && jj !=6){
    tabla_ordenados[counter, jj] <- ""
    last_ter <- last_ter - 1
  }
  last_ter <- last_ter + 1
}
for(jj in 7:13){
  tabla_ordenados[counter, jj] <- ""
}

#View(tabla_ordenados)

#Write oredered table in a PDBQT file
for(xi in 1:nrow(tabla_ordenados)){
  cabecera <- tabla_ordenados[xi,1]
  for(xj in 2:13){
    cabecera <- paste(cabecera, tabla_ordenados[xi,xj], sep = " ")
  }
  write(cabecera, file = args[2], append = TRUE)
}







