#!/usr/bin/env Rscript

args <- commandArgs(trailingOnly = TRUE)

d = read.delim(args[1], header=T, sep="\t", as.is=T)

### Select Prey interactions were at least one Bait > Probability Threshold

preylist=unique(c(d$PreyGene[d$BFDR <= as.numeric(args[2])]))
pid = d$PreyGene %in% preylist
d = d[pid,]

bb = unique(d$Bait)
pp = unique(d$PreyGene)

nbait = length(bb)
nprey = length(pp)

### Reformat the SAINToutput data into a spreadsheet
mat = matrix(0, nprey, nbait)

n = nrow(d)
mb = match(d$Bait, bb)
mp = match(d$PreyGene, pp)

### Using the AvgSpec for the spectral counts
for(i in 1:n) {
	mat[mp[i],mb[i]] = d$AvgSpec[i]	
}

rownames(mat) = pp
colnames(mat) = bb

outfile <- paste(c(args[3]), "matrix.txt", sep="_")
### The following file is the outcome of running this step.
write.table(mat, outfile, sep="\t", quote=F)





