#!/usr/bin/perl

# 17/12/2013

if($#ARGV==0){
	print "This program takes non-SaintExpress formatted data and converts it to look like it.\n";
	print "\nusage:\n $0\n-i [csv saint output file]\n\n";
	die;
}
else{
	$i=0;
	while($i<=$#ARGV){
		if($ARGV[$i] eq '-i'){
			$i++;
			$ifile=$ARGV[$i];
		}
		else{
			die "\Incorrect program usage\n\n";
		}
		$i++;
	}
}

$i=0;
$file='';
open(IFILE,"<$ifile") || die "$ifile can't be opened: $!";
{ local $/=undef;  $file=<IFILE>; }
@lines=split /[\r\n]+/, $file;
foreach $line (@lines) {
   	if($line =~ /^Bait/){
	}
	elsif($line =~ /^([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)/){
		$bait[$i]=$1;
		$prey[$i]=$2;
		$spec[$i]=$3;
		$fdr[$i]=$4;
		$i++;
	}
	else{
	}
}	
close(IFILE);
$line_count=$i;

open(OFILE, ">mockSaintExpress.txt");
print OFILE "Bait\tPrey\tPreyGene\tSpec\tSpecSum\tAvgSpec\tNumReplicates\tctrlCounts\tAvgP\tMaxP\tTopoAvgP\tTopoMaxP\tSaintScore\tFoldChange\tBFDR\tboosted_by\n";

for($i=0; $i<$line_count; $i++){
	print OFILE "$bait[$i]\t111\t$prey[$i]\t111\t111\t$spec[$i]\t111\t111\t111\t111\t111\t111\t111\t111\t$fdr[$i]\t111\n";
}
close(OFILE);

