#include "Alignments.h"
#include "int_util.h"

#include <boost/algorithm/string.hpp>

#include <iostream>
#include <sstream>

Alignments::Alignments(std::string alignment) : _alignment(alignment) {
	fill_alignment_fields(alignment);
}

void Alignments::fill_alignment_fields(const std::string &alignment) {
	std::istringstream ss(alignment);
	ss >> field.QNAME >> field.FLAG >> field.RNAME >> field.POS >>
	      field.MAPQ >> field.CIGAR >> field.RNEXT >> field.PNEXT >>
	      field.TLEN >> field.SEQ >> field.QUAL;
}

std::vector<std::pair<int,char>> Alignments::cigar() {
	return get_cigar_operations(field.CIGAR);
}

std::vector<std::pair<int,char>> Alignments::get_cigar_operations(const std::string &cigar) {
	std::vector<std::pair<int,char>> p;
    	int count;
    	char operation;

    	std::istringstream ss(cigar);
    	while(ss >> count >> operation) {
        	p.push_back(std::make_pair(count, operation));
    	}

    	return p;
}
