#ifndef ARGS_H
#define ARGS_H

#include "int_util.h"

#include <string>
#include <vector>
#include <list>

static void usage() {
        fprintf(stderr, "\n");
        fprintf(stderr, "Program: Coverage Sampler \n");
        fprintf(stderr, "Contact: Chris Dean <cdean11@rams.colostate.edu\n\n");
        fprintf(stderr, "Usage: csa [options]\n\n");
        fprintf(stderr, "Options:\n\n");
        fprintf(stderr, "    -amr_fp    amr database path\n");
        fprintf(stderr, "    -sam_fp    sam file path\n");
        fprintf(stderr, "    -min       starting level\n");
        fprintf(stderr, "    -max       ending level\n");
        fprintf(stderr, "    -skip      amount of levels to skip\n");
        fprintf(stderr, "    -t         gene fraction threshold\n");
        fprintf(stderr, "    -samples   amount of samples per level\n");
        fprintf(stderr, "    -d         directory parsing\n");
        fprintf(stderr, "    -bam       bam file parsing\n");
        fprintf(stderr, "    -out_fp    output file path\n\n");
}

/**
 * Encapsulates information input
 * from the command line.
 */
struct cmd_args {
	std::string amr_fp;
	std::string sam_fp;
	std::list<std::string> sam_dir_fp;
	std::string out_fp;
	
	int threshold;
	int min;
	int max;
	int skip;
	int s_per_lev;

	bool sam_dir = false;		/* This will be set to true when parsing a
                                           directory of sam files. */
	bool bam_stream = false;	/* This will be set to true when executing
                                           samtools view -h example.bam | csa > output
                                           from the command line. */
};

/**
 * Returns a struct of command line arguments.
 */
static inline cmd_args
parse_command_line(int argc, char *argv[]) {
	std::vector<std::string> args(argv, argv + argc);

	cmd_args arg;

	for(int i = 1; i < argc; i++) {
		if(args[i].compare("-amr_fp") == 0)
			arg.amr_fp = args[++i];
		else if(args[i].compare("-sam_fp") == 0) 
			arg.sam_fp = args[++i];
		else if(args[i].compare("-out_fp") == 0)
			arg.out_fp = args[++i];
		else if(args[i].compare("-t") == 0)
			arg.threshold = s_to_i(args[++i]);
		else if(args[i].compare("-min") == 0)
			arg.min = s_to_i(args[++i]);
		else if(args[i].compare("-max") == 0)
			arg.max = s_to_i(args[++i]);
		else if(args[i].compare("-skip") == 0)
			arg.skip = s_to_i(args[++i]);
		else if(args[i].compare("-samples") == 0)
			arg.s_per_lev = s_to_i(args[++i]);
		else if(args[i].compare("-d") == 0)
			arg.sam_dir = true;
		else if(args[i].compare("-bam") == 0)
			arg.bam_stream = true;
		else {
			usage();
			exit(EXIT_FAILURE);
		}
	}

	return arg;
}

#endif /* ARGS_H */
