#include "FastaRecord.h"

#include <algorithm>

FastaRecord::FastaRecord(std::string gene_id, std::string gene) :
	_gene_id(gene_id), _gene(gene), _base_hits(_gene.length(), 0),
	_gene_hits(0) {}

std::string FastaRecord::gene_id() const { return _gene_id; }

std::string FastaRecord::gene() const { return _gene; }

void FastaRecord::update_gene_hits() {
	_gene_hits++;
}

int FastaRecord::gene_hits() const {
	return _gene_hits;
}

int FastaRecord::get_base_hits() const {
	return static_cast<int>(count(_base_hits.begin(), _base_hits.end(), 1));
}

int FastaRecord::find_gene(const std::vector<FastaRecord> &records,
			   const std::string &gene_id, std::string seq) {
	int gene_index;

	std::vector<FastaRecord>::const_iterator low;
	// binary search for fasta record index
	low = std::lower_bound(records.begin(), records.end(), FastaRecord(gene_id, seq),
                                   [](const FastaRecord &a, const FastaRecord &b)
                                   { return a.gene_id() < b.gene_id(); });
	gene_index = (low - records.begin());

	return gene_index;
}

void FastaRecord::sort_by_gene_id(std::vector<FastaRecord> &records) {
	// sort records by gene id
	sort(records.begin(), records.end(), [](const FastaRecord &a, const FastaRecord &b) { return a.gene_id() < b.gene_id(); });
}

void FastaRecord::reset_base_hits(std::vector<FastaRecord> &records) {
	for_each(records.begin(), records.end(), [](FastaRecord &a) { std::fill(a.base_hits().begin(), a.base_hits().end(), 0); });
}

void FastaRecord::reset_gene_hits(std::vector<FastaRecord> &records) {
	for_each(records.begin(), records.end(), [](FastaRecord &a) { a._gene_hits = 0; });
}

std::vector<int> &FastaRecord::base_hits() {
        return _base_hits;
}






	

