/*
 * Decompiled with CFR 0.152.
 */
package org.krumsiek.gepard.client.cmdline;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.krumsiek.gepard.client.DrawTarget;
import org.krumsiek.gepard.client.Plotter;
import org.krumsiek.gepard.common.DotMatrix;
import org.krumsiek.gepard.common.DotMatrixCallback;
import org.krumsiek.gepard.common.FASTAReader;
import org.krumsiek.gepard.common.InvalidFASTAFileException;
import org.krumsiek.gepard.common.InvalidSubMatFileException;
import org.krumsiek.gepard.common.ParameterSet;
import org.krumsiek.gepard.common.Sequence;
import org.krumsiek.gepard.common.SubstitutionMatrix;
import org.krumsiek.gepard.common.SuffixArray;

public class CommandLineHandler {
    private static final int DEF_WIDTH = 750;
    private static final int DEF_HEIGHT = 750;
    private static final int DEF_WORD = 10;
    private static final int DEF_WINDOW = 0;
    private static int zoom;
    private static int width;
    private static int height;

    private Options setupOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt("seq1");
        OptionBuilder.withDescription("first sequence file");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(true);
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("seq2");
        OptionBuilder.withDescription("second sequence file");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("matrix");
        OptionBuilder.withDescription("substitution matrix file");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("outfile");
        OptionBuilder.withDescription("output file name");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        OptionBuilder.isRequired(true);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("silent");
        OptionBuilder.withDescription("silence output (except error messages)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("print this message and exit");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("reference");
        OptionBuilder.withDescription("print full reference and exit");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("maxwidth");
        OptionBuilder.withDescription("maximum width of the generated image");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        Option maxwidth = OptionBuilder.create();
        OptionBuilder.withLongOpt("maxheight");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("maximum height of the generated image");
        Option maxheight = OptionBuilder.create();
        OptionBuilder.withLongOpt("zoom");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("specify a zoom factor for the dotplot (note: you can only use maxwidth/maxheight OR zoom)");
        Option zoom = OptionBuilder.create();
        options.addOption(maxwidth);
        options.addOption(maxheight);
        options.addOption(zoom);
        OptionBuilder.withLongOpt("secondcomp");
        OptionBuilder.withType(Boolean.class);
        OptionBuilder.withDescription("use complementary of second sequence");
        Option secondcomp = OptionBuilder.create();
        OptionBuilder.withLongOpt("word");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("maximum height of the generated image");
        Option word = OptionBuilder.create();
        OptionBuilder.withLongOpt("window");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("word length for suffix array mode");
        Option window = OptionBuilder.create();
        options.addOption(secondcomp);
        options.addOption(word);
        options.addOption(window);
        OptionBuilder.withLongOpt("from1");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("start of first sequence");
        Option from1 = OptionBuilder.create();
        OptionBuilder.withLongOpt("to1");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("end of first sequence");
        Option to1 = OptionBuilder.create();
        options.addOption(from1);
        options.addOption(to1);
        OptionBuilder.withLongOpt("from2");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("start of first sequence");
        Option from2 = OptionBuilder.create();
        OptionBuilder.withLongOpt("to2");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("end of first sequence");
        Option to2 = OptionBuilder.create();
        options.addOption(from2);
        options.addOption(to2);
        OptionBuilder.withLongOpt("lower");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("lower limit for dot intensity (in %)");
        Option lower = OptionBuilder.create();
        OptionBuilder.withLongOpt("upper");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("upper limit for dot intensity (in %)");
        Option upper = OptionBuilder.create();
        OptionBuilder.withLongOpt("greyscale");
        OptionBuilder.hasArgs();
        OptionBuilder.withType(Integer.class);
        OptionBuilder.withDescription("greyscale start value (in %)");
        Option greyscale = OptionBuilder.create();
        options.addOption(lower);
        options.addOption(upper);
        options.addOption(greyscale);
        return options;
    }

    public void main(String[] args) {
        Options opts = this.setupOptions();
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(opts, args);
            boolean silent = cmd.hasOption("silent");
            if (cmd.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("Gepard_Stripped.jar", opts);
                CommandLineHandler.printUsage();
                System.exit(1);
            }
            if (cmd.hasOption("reference")) {
                this.printReference();
                System.exit(1);
            }
            String format = "PNG";
            if (cmd.hasOption("zoom")) {
                zoom = Integer.parseInt(cmd.getOptionValue("zoom"));
            }
            if (!silent) {
                System.out.println("Loading substitution matrix...");
            }
            SubstitutionMatrix submat = null;
            try {
                submat = SubstitutionMatrix.loadFromFile(cmd.getOptionValue("matrix"));
                submat.guessIfSubstitutionMatrix();
            }
            catch (IOException e) {
                try {
                    submat = SubstitutionMatrix.loadFromResource("/matrices/" + cmd.getOptionValue("matrix"));
                    submat.guessIfSubstitutionMatrix();
                }
                catch (IOException | InvalidSubMatFileException ex) {
                    System.err.println("Error: Could not load substitution matrix file:");
                    System.err.println(e.getMessage());
                    System.exit(1);
                    Logger.getLogger(CommandLineHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (InvalidSubMatFileException e) {
                System.err.println("Error: Invalid substitution matrix file:");
                System.err.println(cmd.getOptionValue("matrix"));
                System.exit(1);
            }
            if (!silent) {
                System.out.println("Loading sequence from " + cmd.getOptionValue("seq1"));
            }
            Sequence seq1 = null;
            try {
                seq1 = FASTAReader.readFile(cmd.getOptionValue("seq1"), submat);
            }
            catch (IOException e) {
                System.err.println("Error: Could not load first sequence file:");
                System.err.println(e.getMessage());
                System.exit(1);
            }
            catch (InvalidFASTAFileException e) {
                System.err.println("Error: File could not be recognized as FASTA format file:");
                System.err.println(cmd.getOptionValue("seq1"));
                System.err.println("Problem: " + e.getMessage());
                System.exit(1);
            }
            if (!silent) {
                System.out.println("Loading sequence from " + cmd.getOptionValue("seq2"));
            }
            Sequence seq2 = null;
            try {
                seq2 = FASTAReader.readFile(cmd.getOptionValue("seq2"), submat);
            }
            catch (IOException e) {
                System.err.println("Error: Could not load second sequence file:");
                System.err.println(e.getMessage());
                System.exit(1);
            }
            catch (InvalidFASTAFileException e) {
                System.err.println("Error: File could not be recognized as FASTA format file:");
                System.err.println(cmd.getOptionValue("seq2"));
                System.err.println("Problem: " + e.getMessage());
                System.exit(1);
            }
            if (cmd.hasOption("secondcomp")) {
                Sequence.complementarizeSequence(seq2);
            }
            int word = -1;
            int window = -1;
            try {
                word = cmd.hasOption("word") ? Integer.parseInt(cmd.getOptionValue("word")) : (cmd.hasOption("window") ? 0 : 10);
                window = cmd.hasOption("window") ? Integer.parseInt(cmd.getOptionValue("window")) : 0;
            }
            catch (NumberFormatException e) {
                System.err.println("Error: Invalid integer number:");
                System.err.println(e.getMessage());
                System.exit(1);
            }
            float lower = -1.0f;
            lower = cmd.hasOption("lower") ? Float.parseFloat(cmd.getOptionValue("lower")) / 100.0f : (word > 0 ? 0.0f : Float.NaN);
            float upper = -1.0f;
            upper = cmd.hasOption("upper") ? Float.parseFloat(cmd.getOptionValue("upper")) / 100.0f : (word > 0 ? 0.2f : 1.0f);
            float greyscale = -1.0f;
            greyscale = cmd.hasOption("greyscale") ? Float.parseFloat(cmd.getOptionValue("greyscale")) / 100.0f : (word > 0 ? 0.0f : 0.5f);
            ParameterSet params = new ParameterSet(-1, word, window, -1, -1, -1, -1);
            try {
                CommandLineHandler.setCoordinates(params, seq1, seq2, cmd);
                width = cmd.hasOption("maxwidth") ? Integer.parseInt(cmd.getOptionValue("maxwidth")) : 750;
                height = cmd.hasOption("maxheight") ? Integer.parseInt(cmd.getOptionValue("maxheight")) : 750;
                params.zoom = CommandLineHandler.calcZoom(width, height, params.seq1Start, params.seq1Stop, params.seq2Start, params.seq2Stop);
                if (params.seq1Start >= params.seq1Stop || params.seq2Start >= params.seq2Stop) {
                    System.err.println("Error: To coordinates may not be greater than from coordinates!");
                    System.exit(1);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Error: Invalid integer number:");
                System.err.println(e.getMessage());
                System.exit(1);
            }
            boolean saSecondSeq = false;
            SuffixArray sa = null;
            if (!silent) {
                System.out.println("Calculating suffix array... ");
            }
            if (seq1.getLength() >= seq2.getLength()) {
                sa = new SuffixArray(seq1, submat.getAlphabetSize());
            } else {
                sa = new SuffixArray(seq2, submat.getAlphabetSize());
                saSecondSeq = true;
            }
            if (!silent) {
                System.out.println("Calculating dotplot... ");
            }
            Callback catcher = new Callback();
            DotMatrix dm = new DotMatrix(seq1.getSequenceData(), seq2.getSequenceData(), seq1.getName(), seq2.getName(), sa, params, submat, catcher, saSecondSeq);
            if (!silent) {
                System.out.println("Creating image and writing to file... ");
            }
            Plotter plotter = new Plotter(dm, catcher);
            float minScore = dm.getMinDotScore();
            float maxScore = dm.getMaxDotScore();
            if (Float.isNaN(lower)) {
                float gooddisp = (dm.getAvgDotScore() + maxScore) * 0.4f;
                lower = (gooddisp - minScore) / (maxScore - minScore);
            }
            plotter.reCalc((maxScore - minScore) * lower + minScore, (maxScore - minScore) * upper + minScore, greyscale, 0);
            try {
                File outfile = new File(cmd.getOptionValue("outfile"));
                ImageIO.write((RenderedImage)plotter.getFullImage(), format, outfile);
            }
            catch (IOException e) {
                System.err.println("Error: Could not write image file:");
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getLocalizedMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Gepard_Stripped.jar", opts);
        }
    }

    private static void setCoordinates(ParameterSet params, Sequence seq1, Sequence seq2, CommandLine arguments) {
        params.seq1Start = arguments.hasOption("from1") ? CommandLineHandler.getCoordinate(arguments.getOptionValue("from1"), seq1) : 0;
        params.seq1Stop = arguments.hasOption("to1") ? CommandLineHandler.getCoordinate(arguments.getOptionValue("to1"), seq1) : seq1.getLength() - 1;
        params.seq2Start = arguments.hasOption("from2") ? CommandLineHandler.getCoordinate(arguments.getOptionValue("from2"), seq2) : 0;
        params.seq2Stop = arguments.hasOption("to2") ? CommandLineHandler.getCoordinate(arguments.getOptionValue("to2"), seq2) : seq2.getLength() - 1;
        if (params.seq1Start < 0) {
            params.seq1Start = 0;
        }
        if (params.seq1Stop >= seq1.getLength()) {
            params.seq1Stop = seq1.getLength() - 1;
        }
        if (params.seq2Start < 0) {
            params.seq2Start = 0;
        }
        if (params.seq2Stop >= seq2.getLength()) {
            params.seq2Stop = seq2.getLength() - 1;
        }
    }

    private static final int getCoordinate(String argument, Sequence seq) {
        if (!argument.contains("%")) {
            return Integer.parseInt(argument);
        }
        float fraction = Float.parseFloat(argument.substring(0, argument.indexOf("%"))) / 100.0f;
        return (int)((float)seq.getLength() * fraction);
    }

    private static int calcZoom(int imgwidth, int imgheight, int x1, int x2, int y1, int y2) {
        int drawWidth = imgwidth;
        int drawHeight = imgheight;
        int xzoom = (int)Math.ceil((float)(x2 - x1) / (float)drawWidth);
        int yzoom = (int)Math.ceil((float)(y2 - y1) / (float)drawHeight);
        if (xzoom == 0 && yzoom == 0) {
            xzoom = 1;
        }
        return zoom;
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("Gepard 1.21a - command line mode");
        System.err.println();
        System.err.println("Reference:");
        System.err.println("Krumsiek J, Arnold R, Rattei T");
        System.err.println("Gepard: A rapid and sensitive tool for creating dotplots on genome scale.");
        System.err.println("Bioinformatics 2007; 23(8): 1026-8. PMID: 17309896");
        System.err.println();
    }

    public void printReference() {
        System.err.println("Reference\n\nKrumsiek J, Arnold R, Rattei T\nGepard: A rapid and sensitive tool for creating dotplots on genome scale.\nBioinformatics 2007; 23(8): 1026-8. PMID: 17309896\n\nBibtex-entry:\n\n@ARTICLE{Krumsiek2007,\n  author = {Jan Krumsiek and Roland Arnold and Thomas Rattei},\n  title = {Gepard: a rapid and sensitive tool for creating dotplots on genome\n\tscale.},\n  journal = {Bioinformatics},\n  year = {2007},\n  volume = {23},\n  pages = {1026--1028},\n  number = {8},\n  month = {Apr},\n  abstract = {Gepard provides a user-friendly, interactive application for the quick\n\tcreation of dotplots. It utilizes suffix arrays to reduce the time\n\tcomplexity of dotplot calculation to Theta(m*log n). A client-server\n\tmode, which is a novel feature for dotplot creation software, allows\n\tthe user to calculate dotplots and color them by functional annotation\n\twithout any prior downloading of sequence or annotation data. AVAILABILITY:\n\tBoth source codes and executable binaries are available at http://mips.gsf.de/services/analysis/gepard},\n  doi = {10.1093/bioinformatics/btm039},\n  pii = {btm039},\n  pmid = {17309896},\n  url = {http://dx.doi.org/10.1093/bioinformatics/btm039}\n}\n");
    }

    private static class Callback
    implements DotMatrixCallback,
    DrawTarget {
        private Callback() {
        }

        @Override
        public void dotmatrixCalcStatus(float percent) {
        }

        @Override
        public void tellAborted() {
        }

        @Override
        public int tellCallbackStep(int wordlen, int windowsize) {
            return 1000;
        }

        public boolean dotplotAborted() {
            return false;
        }

        @Override
        public int getHeight() {
            return height;
        }

        @Override
        public int getWidth() {
            return width;
        }

        @Override
        public void setPreferredSize(Dimension dimension) {
        }
    }
}

