/*
 * Decompiled with CFR 0.152.
 */
package org.krumsiek.gepard.common;

import java.io.File;
import org.krumsiek.gepard.common.Sequence;

public class SuffixArray {
    private int[] suftab;
    private byte[] orgdata;
    private short[] lcp;
    boolean isgepardsa = true;

    public SuffixArray(Sequence seq, int K) {
        byte[] s = seq.getSequenceData();
        int[] si = new int[s.length + 3];
        for (int i = 0; i < s.length; ++i) {
            si[i] = s[i];
        }
        si[s.length + 2] = 0;
        si[s.length + 1] = 0;
        si[s.length] = 0;
        this.suftab = new int[s.length];
        this.genArray(si, this.suftab, s.length, K + 1);
        this.lcp = this.genLCP(this.suftab, s);
        this.orgdata = s;
    }

    private SuffixArray(int[] st, short[] l, byte[] od, boolean isgepardsa) {
        this.suftab = st;
        this.orgdata = od;
        this.lcp = l;
        this.isgepardsa = isgepardsa;
    }

    public int[] search(byte[] query, int qstart, int qlen, boolean backwards, byte[] map) {
        int[] ret = new int[]{};
        int l = 0;
        int r = this.orgdata.length - 1;
        int m = (l + r) / 2;
        while (l <= r) {
            m = (l + r) / 2;
            int comp = this.compare(this.orgdata, this.suftab[m], query, qstart, qlen, backwards, map);
            if (comp == 1) {
                r = m - 1;
                continue;
            }
            if (comp == -1) {
                l = m + 1;
                continue;
            }
            for (l = m; l > 0 && this.lcp[l - 1] >= qlen; --l) {
            }
            for (r = m; r < this.orgdata.length - 1 && this.lcp[r] >= qlen; ++r) {
            }
            ret = new int[r - l + 1];
            for (int i = 0; i < r - l + 1; ++i) {
                ret[i] = this.suftab[l + i];
            }
            r = 0;
            l = 1;
        }
        return ret;
    }

    private int compare(byte[] s1, int off1, byte[] s2, int off2, int p, boolean backwards, byte[] map) {
        int i;
        if (!backwards) {
            int i2;
            for (i2 = 0; i2 < p && i2 + off1 < s1.length && i2 + off2 < s2.length; ++i2) {
                if (s1[i2 + off1] < map[s2[i2 + off2]]) {
                    return -1;
                }
                if (s1[i2 + off1] <= map[s2[i2 + off2]]) continue;
                return 1;
            }
            if (i2 < p) {
                if (this.isgepardsa) {
                    if (i2 + off1 == s1.length) {
                        return -1;
                    }
                    return 1;
                }
                if (i2 + off1 == s1.length) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        for (i = 0; i < p && i + off1 < s1.length && i + off2 < s2.length; ++i) {
            if (s1[i + off1] < map[s2[-i + off2]]) {
                return -1;
            }
            if (s1[i + off1] <= map[s2[-i + off2]]) continue;
            return 1;
        }
        if (i < p) {
            if (this.isgepardsa) {
                if (i + off1 == s1.length) {
                    return -1;
                }
                return 1;
            }
            if (i + off1 == s1.length) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private void radixPass(int[] a, int[] b, int[] s, int offset, int n, int K) {
        int i;
        int[] c = new int[K + 1];
        for (i = 0; i < n; ++i) {
            int n2 = s[a[i] + offset];
            c[n2] = c[n2] + 1;
        }
        int sum = 0;
        for (i = 0; i <= K; ++i) {
            int t = c[i];
            c[i] = sum;
            sum += t;
        }
        for (i = 0; i < n; ++i) {
            int n3 = s[a[i] + offset];
            int n4 = c[n3];
            c[n3] = n4 + 1;
            b[n4] = a[i];
        }
    }

    public int[] getRawArray() {
        return this.suftab;
    }

    private void genArray(int[] s, int[] SA, int n, int K) {
        int i;
        int n0 = (n + 2) / 3;
        int n1 = (n + 1) / 3;
        int n2 = n / 3;
        int n02 = n0 + n2;
        int[] s12a = new int[n02 + 3];
        int[] s12b = new int[n02 + 3];
        int j = 0;
        for (int i2 = 0; i2 < n + (n0 - n1); ++i2) {
            if (i2 % 3 == 0) continue;
            s12a[j++] = i2;
        }
        this.radixPass(s12a, s12b, s, 2, n02, K);
        this.radixPass(s12b, s12a, s, 1, n02, K);
        this.radixPass(s12a, s12b, s, 0, n02, K);
        int name = 0;
        int c0 = -1;
        int c1 = -1;
        int c2 = -1;
        for (i = 0; i < n02; ++i) {
            if (s[s12b[i]] != c0 || s[s12b[i] + 1] != c1 || s[s12b[i] + 2] != c2) {
                ++name;
                c0 = s[s12b[i]];
                c1 = s[s12b[i] + 1];
                c2 = s[s12b[i] + 2];
            }
            if (s12b[i] % 3 == 1) {
                s12a[s12b[i] / 3] = name;
                continue;
            }
            s12a[s12b[i] / 3 + n0] = name;
        }
        if (name < n02) {
            this.genArray(s12a, s12b, n02, name);
            for (i = 0; i < n02; ++i) {
                s12a[s12b[i]] = i + 1;
            }
        } else {
            for (i = 0; i < n02; ++i) {
                s12b[s12a[i] - 1] = i;
            }
        }
        int[] s0a = new int[n0];
        int[] s0b = new int[n0];
        int j2 = 0;
        for (int i3 = 0; i3 < n02; ++i3) {
            if (s12b[i3] >= n0) continue;
            s0a[j2++] = 3 * s12b[i3];
        }
        this.radixPass(s0a, s0b, s, 0, n0, K);
        s0a = null;
        int p = 0;
        int t = n0 - n1;
        for (int k = 0; k < n; ++k) {
            int a2;
            int a1;
            int i4 = s12b[t] < n0 ? s12b[t] * 3 + 1 : (s12b[t] - n0) * 3 + 2;
            int j3 = s0b[p];
            boolean q = false;
            if (s12b[t] < n0) {
                a1 = s[i4];
                a2 = s12a[s12b[t] + n0];
                int b1 = s[j3];
                int b2 = s12a[j3 / 3];
                q = a1 < b1 || a1 == b1 && a2 <= b2;
            } else {
                a1 = s[i4];
                a2 = s[i4 + 1];
                int a3 = s12a[s12b[t] - n0 + 1];
                int b1 = s[j3];
                int b2 = s[j3 + 1];
                int b3 = s12a[j3 / 3 + n0];
                boolean bl = q = a1 < b1 || a1 == b1 && (a2 < b2 || a2 == b2 && a3 <= b3);
            }
            if (q) {
                SA[k] = i4;
                if (++t != n02) continue;
                ++k;
                while (p < n0) {
                    SA[k] = s0b[p];
                    ++p;
                    ++k;
                }
                continue;
            }
            SA[k] = j3;
            if (++p != n0) continue;
            ++k;
            while (t < n02) {
                SA[k] = s12b[t] < n0 ? s12b[t] * 3 + 1 : (s12b[t] - n0) * 3 + 2;
                ++t;
                ++k;
            }
        }
    }

    private static short byte2unsignedshort(byte i) {
        if (i < 0) {
            return (short)(256 + i);
        }
        return i;
    }

    private short[] genLCP(int[] suftab, byte[] orgdata) {
        int len = suftab.length;
        short[] ret = new short[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            int j;
            for (j = 0; j < 32768 && suftab[i] + j < len && suftab[i + 1] + j < len && orgdata[suftab[i] + j] == orgdata[suftab[i + 1] + j]; ++j) {
            }
            ret[i] = (short)j;
        }
        return ret;
    }

    public static String getSAFilename(String sequenceFile) {
        String filename = SuffixArray.extractFilename(sequenceFile);
        return filename + "_" + new File(sequenceFile).length() + ".sa";
    }

    private static String extractFilename(String source) {
        int sep = source.lastIndexOf(System.getProperty("file.separator"));
        if (sep > -1) {
            return source.substring(sep + 1);
        }
        return source;
    }

    public void compareSAs(SuffixArray sa) {
        int j = 0;
        for (int i = 0; i < sa.suftab.length; ++i) {
            if (this.suftab[i] != sa.suftab[i]) {
                System.out.println("differing at suffix " + i + ", this: " + this.suftab[i] + ", other: " + sa.suftab[i]);
                ++j;
                System.out.println();
                SuffixArray.dump("vmatch  ", this.orgdata, this.suftab[i]);
                SuffixArray.dump("gepard  ", this.orgdata, sa.suftab[i]);
            }
            if (j >= 10) break;
        }
    }

    private static void dump(String name, byte[] orgdata, int pos) {
        char[] mapit = new char[]{' ', 'A', 'T', 'G', 'C', 'N'};
        System.out.print(name);
        for (int k = 0; k < 50 && pos + k < orgdata.length; ++k) {
            System.out.print(mapit[orgdata[pos + k]]);
        }
        System.out.println();
    }

    public void printYourself() {
        char[] mapit = new char[]{' ', 'A', 'T', 'G', 'C'};
        for (int m = 0; m < this.suftab.length; ++m) {
            System.out.print(m + ": ");
            for (int i = 0; i <= 8 && this.suftab[m] + i < this.suftab.length; ++i) {
                System.out.print(mapit[this.orgdata[this.suftab[m] + i]]);
            }
            System.out.println();
        }
    }

    public void verifyArray() {
        int i;
        byte[] idmap = new byte[128];
        for (i = 0; i < 128 && i >= 0; i = (int)((byte)(i + 1))) {
            idmap[i] = i;
        }
        for (i = 0; i < this.suftab.length - 1; ++i) {
            if (this.compare(this.orgdata, this.suftab[i], this.orgdata, this.suftab[i + 1], 1000, false, idmap) <= 0) continue;
            System.out.println("WAAAAA, bad one: " + this.suftab[i + 1]);
            SuffixArray.dump(i + "\t", this.orgdata, this.suftab[i]);
            SuffixArray.dump(i + 1 + "\t", this.orgdata, this.suftab[i + 1]);
        }
    }

    public void showFirst(int n) {
        for (int i = 0; i < n; ++i) {
            SuffixArray.dump("", this.orgdata, this.suftab[i]);
        }
    }

    public int getLength() {
        return this.suftab.length;
    }

    public void doubles() {
        byte[] check = new byte[this.suftab.length];
        System.out.println("seq: " + this.suftab.length);
        for (int i = 0; i < check.length; ++i) {
            if (this.suftab[i] >= check.length) {
                System.out.println("Was: " + i);
            }
            if (check[this.suftab[i]] == 1) {
                System.err.println("NOOOOOOOOOOOOOO");
                continue;
            }
            check[this.suftab[i]] = 1;
        }
    }
}

