/*
 * Decompiled with CFR 0.152.
 */
package org.krumsiek.gepard.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.krumsiek.gepard.client.DrawTarget;
import org.krumsiek.gepard.common.DotMatrix;

public class Plotter {
    DotMatrix dm;
    int selX1 = -1;
    int selY1 = -1;
    int selX2 = -1;
    int selY2 = -1;
    private BufferedImage offscreen;
    private int imgWidth;
    private int imgHeight;
    private DrawTarget dp;

    public Plotter(DotMatrix dm, DrawTarget dp) {
        this.dm = dm;
        this.dp = dp;
        this.offscreen = new BufferedImage(dm.getWidth(), dm.getHeight(), 1);
        this.imgWidth = dm.getWidth();
        this.imgHeight = dm.getHeight();
        dp.setPreferredSize(new Dimension(this.imgWidth, this.imgHeight));
    }

    public void reCalc(float colorlower, float colorupper, float greyscalestart, int funcatsWeight) {
        float[][] matrix = this.dm.getDotMatrix();
        int colorDot = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < this.dm.getWidth(); ++i) {
            for (int j = 0; j < this.dm.getHeight(); ++j) {
                if (matrix[i][j] >= colorlower) {
                    float dotscore = matrix[i][j];
                    if (dotscore > colorupper) {
                        dotscore = colorupper;
                    }
                    float ratio = greyscalestart + (dotscore - colorlower) / (colorupper - colorlower) * (1.0f - greyscalestart);
                    colorDot = (int)((1.0f - ratio) * 255.0f);
                } else {
                    colorDot = 255;
                }
                r = colorDot;
                g = colorDot;
                b = colorDot;
                this.offscreen.setRGB(i, j, r * 65536 + g * 256 + b);
            }
        }
    }

    public void redrawSimple(Graphics2D g) {
        int whitenWidth = Math.max(this.imgWidth, this.dp.getWidth());
        int whitenHeight = Math.max(this.imgHeight, this.dp.getHeight());
        g.fillRect(0, 0, whitenWidth, whitenHeight);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.dm.getWidth() + 1, this.dm.getHeight() + 1);
        g.drawImage((Image)this.offscreen, 0, 0, null);
    }

    public BufferedImage getFullImage() {
        BufferedImage fullImage = new BufferedImage(this.imgWidth, this.imgHeight, 1);
        Graphics2D g = (Graphics2D)fullImage.getGraphics();
        this.redrawSimple(g);
        return fullImage;
    }
}

