/*
 * Decompiled with CFR 0.152.
 */
package org.krumsiek.gepard.common;

import java.io.Serializable;
import org.krumsiek.gepard.common.CompressedDotMatrix;
import org.krumsiek.gepard.common.DotMatrixCallback;
import org.krumsiek.gepard.common.ParameterSet;
import org.krumsiek.gepard.common.Sequence;
import org.krumsiek.gepard.common.SubstitutionMatrix;
import org.krumsiek.gepard.common.SuffixArray;

public class DotMatrix
implements Serializable {
    private static final long serialVersionUID = 5086505082934770263L;
    private float[][] dotmatrix = null;
    private int width = 0;
    private int height = 0;
    private float maxdotscore;
    private float mindotscore;
    private float avgdotscore;
    private float GCratio1 = 0.0f;
    private float GCratio2;
    private int seq1Length;
    private int seq2Length;
    private ParameterSet params;
    private String seq1Name;
    private String seq2Name;
    private SuffixArray sa;
    private SubstitutionMatrix submat;
    private boolean bFuncats = false;
    private boolean nuclmatrix;

    public float[][] getDotMatrix() {
        return this.dotmatrix;
    }

    public boolean isNucleotideMatrix() {
        return this.nuclmatrix;
    }

    public boolean usingFuncats() {
        return this.bFuncats;
    }

    public float getGCratio1() {
        return this.GCratio1;
    }

    public float getGCratio2() {
        return this.GCratio2;
    }

    public SuffixArray getSuffixArray() {
        return this.sa;
    }

    public String getSeq1Name() {
        return this.seq1Name;
    }

    public String getSeq2Name() {
        return this.seq2Name;
    }

    public ParameterSet getParameterSet() {
        return this.params;
    }

    public int getSeq1Length() {
        return this.seq1Length;
    }

    public int getSeq2Length() {
        return this.seq2Length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getMaxDotScore() {
        return this.maxdotscore;
    }

    public float getMinDotScore() {
        return this.mindotscore;
    }

    public float getAvgDotScore() {
        return this.avgdotscore;
    }

    public DotMatrix(byte[] s1, byte[] s2, String seq1n, String seq2n, SuffixArray sa, ParameterSet params, SubstitutionMatrix submat, DotMatrixCallback callback, boolean SAforSecondSeq) {
        this.seq1Length = s1.length;
        this.seq2Length = s2.length;
        this.seq1Name = seq1n;
        this.seq2Name = seq2n;
        this.sa = sa;
        this.submat = submat;
        this.params = params;
        if (params.seq1Start == 0 && params.seq1Stop == 0) {
            params.seq1Stop = s1.length - 1;
        }
        if (params.seq2Start == 0 && params.seq2Stop == 0) {
            params.seq2Stop = s2.length - 1;
        }
        this.width = (params.seq1Stop - params.seq1Start + 1) / params.zoom;
        this.height = (params.seq2Stop - params.seq2Start + 1) / params.zoom;
        this.nuclmatrix = submat.isNucleotideMatrix();
        if (this.nuclmatrix) {
            this.calcGCRatios(s1, s2, params);
        }
        if (params.wordLength != 0) {
            this.calcDotMatrix(sa, s1, s2, callback, SAforSecondSeq);
        } else {
            this.calcDotMatrixWindowMode(sa, s1, s2, callback);
        }
    }

    private void calcDotMatrix(SuffixArray sa, byte[] seq1, byte[] seq2, DotMatrixCallback callback, boolean SAforSecondSeq) {
        int nonSAseqStop;
        int nonSAseqStart;
        int SAseqStop;
        int SAseqStart;
        int to;
        int from;
        byte[] nonSAsequence;
        int callbackStep = callback != null ? callback.tellCallbackStep(this.params.wordLength, this.params.windowSize) : Integer.MAX_VALUE;
        this.dotmatrix = new float[this.width][this.height];
        if (!SAforSecondSeq) {
            nonSAsequence = seq2;
            from = this.params.seq2Start;
            to = this.params.seq2Stop - this.params.wordLength + 1;
            SAseqStart = this.params.seq1Start;
            SAseqStop = this.params.seq1Stop;
            nonSAseqStart = this.params.seq2Start;
            nonSAseqStop = this.params.seq2Stop;
        } else {
            nonSAsequence = seq1;
            from = this.params.seq1Start;
            to = this.params.seq1Stop - this.params.wordLength + 1;
            SAseqStart = this.params.seq2Start;
            SAseqStop = this.params.seq2Stop;
            nonSAseqStart = this.params.seq1Start;
            nonSAseqStop = this.params.seq1Stop;
        }
        int[] hits = null;
        boolean nuclmatrix = this.submat.isNucleotideMatrix();
        byte pseudodelimiter = nuclmatrix ? (byte)this.submat.map((byte)90) : (byte)-99;
        byte[] idmap = new byte[128];
        for (int i = 0; i < 128 && i >= 0; i = (int)((byte)(i + 1))) {
            idmap[i] = i;
        }
        byte[] complmap = this.submat.isNucleotideMatrix() ? Sequence.getComplementaryMap() : idmap;
        for (int i = from; i < to; ++i) {
            if (nonSAsequence[i] == pseudodelimiter || nuclmatrix && nonSAsequence[i] == 5) continue;
            int[] forwardhits = sa.search(nonSAsequence, i, this.params.wordLength, false, idmap);
            int[] reversehits = i >= this.params.wordLength - 1 ? sa.search(nonSAsequence, i, this.params.wordLength, true, complmap) : new int[]{};
            hits = forwardhits;
            boolean firsthits = true;
            int j = 0;
            while (true) {
                if (j == hits.length) {
                    if (!firsthits || reversehits.length <= 0) break;
                    firsthits = false;
                    hits = reversehits;
                    j = 0;
                }
                if (hits[j] >= SAseqStart && hits[j] <= SAseqStop) {
                    float tx = (float)(hits[j] - SAseqStart) / (float)this.params.zoom;
                    float ty = (float)(i - nonSAseqStart) / (float)this.params.zoom;
                    float value = 0.0f;
                    value = 1.0f;
                    int x1 = 0;
                    int x2 = 0;
                    int y1 = 0;
                    int y2 = 0;
                    if (!SAforSecondSeq) {
                        x1 = (int)tx;
                        x2 = (int)tx + 1;
                        y1 = (int)ty;
                        y2 = (int)ty + 1;
                    } else {
                        x1 = (int)ty;
                        x2 = (int)ty + 1;
                        y1 = (int)tx;
                        y2 = (int)tx + 1;
                    }
                    float fracx2 = tx - (float)((int)tx);
                    float fracx1 = 1.0f - fracx2;
                    float fracy2 = ty - (float)((int)ty);
                    float fracy1 = 1.0f - fracy2;
                    if (x1 < this.width && y1 < this.height) {
                        float[] fArray = this.dotmatrix[x1];
                        int n = y1;
                        fArray[n] = fArray[n] + fracx1 * fracy1 * value;
                    }
                    if (x2 < this.width && y1 < this.height) {
                        float[] fArray = this.dotmatrix[x2];
                        int n = y1;
                        fArray[n] = fArray[n] + fracx2 * fracy1 * value;
                    }
                    if (x1 < this.width && y2 < this.height) {
                        float[] fArray = this.dotmatrix[x1];
                        int n = y2;
                        fArray[n] = fArray[n] + fracx1 * fracy2 * value;
                    }
                    if (x2 < this.width && y2 < this.height) {
                        float[] fArray = this.dotmatrix[x2];
                        int n = y2;
                        fArray[n] = fArray[n] + fracx2 * fracy2 * value;
                    }
                }
                ++j;
            }
            if (i % callbackStep != 0) continue;
            callback.dotmatrixCalcStatus((float)(i - nonSAseqStart) / (float)(nonSAseqStop - this.params.wordLength + 1 - nonSAseqStart) * 100.0f);
        }
        this.calcMaxMinAvg(false);
    }

    private void calcMaxMinAvg(boolean windowmode) {
        float cap = windowmode ? Float.POSITIVE_INFINITY : (float)this.params.zoom / 4.0f;
        this.maxdotscore = Float.NEGATIVE_INFINITY;
        this.mindotscore = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (this.dotmatrix[i][j] > cap) {
                    this.dotmatrix[i][j] = cap;
                }
                if (this.dotmatrix[i][j] > this.maxdotscore) {
                    this.maxdotscore = this.dotmatrix[i][j];
                }
                if (this.dotmatrix[i][j] < this.mindotscore) {
                    this.mindotscore = this.dotmatrix[i][j];
                }
                this.avgdotscore += this.dotmatrix[i][j];
            }
        }
        this.avgdotscore /= (float)(this.width * this.height);
    }

    private void calcGCRatios(byte[] s1, byte[] s2, ParameterSet params) {
        int i;
        int GCcount = 0;
        for (i = params.seq1Start; i <= params.seq1Stop; ++i) {
            if (s1[i] != 3 && s1[i] != 4) continue;
            ++GCcount;
        }
        this.GCratio1 = (float)GCcount / (float)(params.seq1Stop - params.seq1Start + 1);
        GCcount = 0;
        for (i = params.seq2Start; i <= params.seq2Stop; ++i) {
            if (s2[i] != 3 && s2[i] != 4) continue;
            ++GCcount;
        }
        this.GCratio2 = (float)GCcount / (float)(params.seq2Stop - params.seq2Start + 1);
    }

    public DotMatrix(float[][] matrix, float maxDotScore, float minDotScore, String seq1Name, int seq1Length, float seq1GCRatio, String seq2Name, int seq2Length, float seq2GCRatio, ParameterSet params) {
        this.dotmatrix = matrix;
        this.maxdotscore = maxDotScore;
        this.mindotscore = minDotScore;
        this.seq1Name = seq1Name;
        this.seq1Length = seq1Length;
        this.GCratio1 = seq1GCRatio;
        this.seq2Name = seq2Name;
        this.seq2Length = seq2Length;
        this.GCratio2 = seq2GCRatio;
        this.params = params;
        this.nuclmatrix = true;
        this.width = matrix.length;
        this.height = matrix[0].length;
    }

    public CompressedDotMatrix getCompressedMatrix() {
        byte[] intmatrix = new byte[this.width * this.height];
        float range = this.maxdotscore - this.mindotscore;
        int newmaxscore = Integer.MIN_VALUE;
        int newminscore = Integer.MAX_VALUE;
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                int newval = Math.round((this.dotmatrix[i][j] - this.mindotscore) / range * 255.0f);
                if (newval < newminscore) {
                    newminscore = newval;
                }
                if (newval > newmaxscore) {
                    newmaxscore = newval;
                }
                intmatrix[j * this.width + i] = (byte)newval;
            }
        }
        return new CompressedDotMatrix(intmatrix, newmaxscore, newminscore);
    }

    private void calcDotMatrixWindowMode(SuffixArray sa, byte[] seq1, byte[] seq2, DotMatrixCallback callback) {
        int callbackStep = callback != null ? callback.tellCallbackStep(this.params.wordLength, this.params.windowSize) : Integer.MAX_VALUE;
        this.dotmatrix = new float[this.width][this.height];
        byte[] idmap = new byte[128];
        for (int i = 0; i < 128 && i >= 0; i = (int)((byte)(i + 1))) {
            idmap[i] = i;
        }
        byte[] complmap = this.submat.isNucleotideMatrix() ? Sequence.getComplementaryMap() : idmap;
        for (int i = this.params.seq2Start; i <= this.params.seq2Stop; ++i) {
            for (int j = this.params.seq1Start; j <= this.params.seq1Stop; ++j) {
                float tx = (float)(j - this.params.seq1Start) / (float)this.params.zoom;
                float ty = (float)(i - this.params.seq2Start) / (float)this.params.zoom;
                float value = 0.0f;
                value = this.getWindowScore(seq1, seq2, j, i, this.params.windowSize) + this.getWindowScoreBackward(seq1, seq2, j, i, this.params.windowSize, complmap);
                int x1 = (int)tx;
                int x2 = (int)tx + 1;
                int y1 = (int)ty;
                int y2 = (int)ty + 1;
                float fracx2 = tx - (float)((int)tx);
                float fracx1 = 1.0f - fracx2;
                float fracy2 = ty - (float)((int)ty);
                float fracy1 = 1.0f - fracy2;
                if (x1 < this.width && y1 < this.height) {
                    float[] fArray = this.dotmatrix[x1];
                    int n = y1;
                    fArray[n] = fArray[n] + fracx1 * fracy1 * value;
                }
                if (x2 < this.width && y1 < this.height) {
                    float[] fArray = this.dotmatrix[x2];
                    int n = y1;
                    fArray[n] = fArray[n] + fracx2 * fracy1 * value;
                }
                if (x1 < this.width && y2 < this.height) {
                    float[] fArray = this.dotmatrix[x1];
                    int n = y2;
                    fArray[n] = fArray[n] + fracx1 * fracy2 * value;
                }
                if (x2 >= this.width || y2 >= this.height) continue;
                float[] fArray = this.dotmatrix[x2];
                int n = y2;
                fArray[n] = fArray[n] + fracx2 * fracy2 * value;
            }
            if (i % callbackStep != 0) continue;
            callback.dotmatrixCalcStatus((float)(i - this.params.seq2Start) / (float)(this.params.seq2Stop - this.params.wordLength + 1 - this.params.seq2Start) * 100.0f);
        }
        this.calcMaxMinAvg(true);
    }

    private float getWindowScore(byte[] seq1, byte[] seq2, int x, int y, int windowsize) {
        float score = 0.0f;
        int consecutives = 0;
        int backforward = windowsize / 2;
        if (this.nuclmatrix) {
            for (int i = -backforward; i <= backforward; ++i) {
                if (x + i <= 0 || y + i <= 0 || x + i >= seq1.length || y + i >= seq2.length) continue;
                if (seq1[x + i] == seq2[y + i]) {
                    score += 1.0f;
                    score += (float)consecutives;
                    if (consecutives >= 7) continue;
                    ++consecutives;
                    continue;
                }
                consecutives = 0;
            }
        } else {
            for (int i = -backforward; i <= backforward; ++i) {
                if (x + i <= 0 || y + i <= 0 || x + i >= seq1.length || y + i >= seq2.length) continue;
                score += (float)this.submat.getScore(seq1[x + i], seq2[y + i]);
            }
        }
        return score;
    }

    private float getWindowScoreBackward(byte[] seq1, byte[] seq2, int x, int y, int windowsize, byte[] map) {
        float score = 0.0f;
        int consecutives = 0;
        int backforward = windowsize / 2;
        if (this.nuclmatrix) {
            for (int i = -backforward; i <= backforward; ++i) {
                if (x - i <= 0 || y + i <= 0 || x - i >= seq1.length || y + i >= seq2.length) continue;
                if (seq1[x - i] == map[seq2[y + i]]) {
                    score += 1.0f;
                    score += (float)consecutives;
                    if (consecutives >= 7) continue;
                    ++consecutives;
                    continue;
                }
                consecutives = 0;
            }
        }
        return score;
    }
}

