/*
 * Decompiled with CFR 0.152.
 */
package org.krumsiek.gepard.common;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.krumsiek.gepard.common.InvalidSubMatFileException;

public class SubstitutionMatrix {
    private static final int PROTEIN_THRESHOLD = 20;
    private int[][] scoreMatrix;
    private byte[] charMapping;
    private char[] revMapping;
    private boolean bNucleotideMatrix = true;

    private SubstitutionMatrix(int[][] scorematrix, byte[] charMapping, char[] revMapping) {
        this.scoreMatrix = scorematrix;
        this.charMapping = charMapping;
        this.revMapping = revMapping;
    }

    public int getScore(byte a, byte b) {
        return this.scoreMatrix[a][b];
    }

    public int[][] getMatrix() {
        return this.scoreMatrix;
    }

    public byte map(byte input) {
        return this.charMapping[input];
    }

    public char reverseMap(byte input) {
        return this.revMapping[input];
    }

    public int getAlphabetSize() {
        return this.scoreMatrix[0].length - 1;
    }

    public boolean isNucleotideMatrix() {
        return this.bNucleotideMatrix;
    }

    public void setNucleotideMatrix(boolean b) {
        this.bNucleotideMatrix = b;
    }

    public static SubstitutionMatrix loadFromResource(String file) throws IOException, InvalidSubMatFileException {
        InputStreamReader isr = new InputStreamReader(SubstitutionMatrix.class.getResourceAsStream(file));
        BufferedReader br = new BufferedReader(isr);
        return SubstitutionMatrix.doLoad(br, file);
    }

    public static SubstitutionMatrix loadFromFile(String file) throws IOException, InvalidSubMatFileException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        return SubstitutionMatrix.doLoad(br, file);
    }

    private static SubstitutionMatrix doLoad(BufferedReader br, String file) throws IOException, InvalidSubMatFileException {
        String curLine;
        boolean firstLine = true;
        byte[] revMapping = new byte[256];
        revMapping[13] = -1;
        revMapping[10] = -1;
        char[] backMapping = new char[256];
        int[][] matrix = null;
        int mapPos = 1;
        int linenum = 0;
        int reallinenum = 0;
        while ((curLine = br.readLine()) != null) {
            ++reallinenum;
            if (curLine.length() <= 0 || curLine.charAt(0) == '#') continue;
            if (firstLine) {
                int i;
                for (i = 0; i < curLine.length(); ++i) {
                    if (curLine.charAt(i) == ' ') continue;
                    if (revMapping[curLine.charAt(i)] != 0) {
                        throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - character defined twice: " + curLine.charAt(i));
                    }
                    revMapping[curLine.charAt((int)i)] = (byte)mapPos++;
                    if (i >= curLine.length() - 1 || curLine.charAt(i + 1) == ' ') continue;
                    throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - invalid expression: " + curLine.substring(i, i + 2));
                }
                for (i = 0; i < 256; ++i) {
                    if (revMapping[i] < 0) continue;
                    backMapping[revMapping[i]] = (char)i;
                }
                matrix = new int[mapPos][mapPos];
                firstLine = false;
                continue;
            }
            if (linenum == mapPos - 1) {
                throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - too many lines");
            }
            int toknum = 0;
            int poslast = 0;
            boolean lastchar = false;
            boolean foundnonspace = false;
            for (int i = 0; i < curLine.length(); ++i) {
                if (i == curLine.length() - 1 && curLine.charAt(i) != ' ') {
                    lastchar = true;
                    ++i;
                }
                if (lastchar || curLine.charAt(i) == ' ' && foundnonspace) {
                    if (toknum > 0) {
                        if (toknum >= mapPos) {
                            throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - too many tokens");
                        }
                        try {
                            matrix[toknum][linenum + 1] = Integer.parseInt(curLine.substring(poslast, i).trim());
                        }
                        catch (NumberFormatException nfe) {
                            throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - invalid integer value: " + curLine.substring(poslast, i).trim());
                        }
                    } else {
                        if (revMapping[curLine.trim().charAt(0)] != linenum + 1) {
                            throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - invalid character: " + curLine.trim().charAt(0) + ", exptected: " + backMapping[linenum + 1]);
                        }
                        if (curLine.trim().charAt(1) != ' ') {
                            throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - invalid expression: " + curLine.substring(0, 2));
                        }
                    }
                    ++toknum;
                    poslast = i;
                    foundnonspace = false;
                    continue;
                }
                if (curLine.charAt(i) == ' ') continue;
                foundnonspace = true;
            }
            if (!foundnonspace) {
                --toknum;
            }
            if (toknum <= 0) continue;
            if (toknum < mapPos - 1) {
                throw new InvalidSubMatFileException("Error in " + file + ":" + reallinenum + " - incomplete line");
            }
            ++linenum;
        }
        if (linenum < mapPos - 1) {
            throw new InvalidSubMatFileException("Error in " + file + " - there are lines missing");
        }
        return new SubstitutionMatrix(matrix, revMapping, backMapping);
    }

    public void guessIfSubstitutionMatrix() {
        this.bNucleotideMatrix = this.getAlphabetSize() < 20;
    }
}

