import argparse
import os
import json
import re
import pprint
import subprocess
import sys

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Use VEP INSTALL.pl to download/process the cache for an assembly")
    parser.add_argument("--output-file")
    parser.add_argument("--output-dir")
    parser.add_argument("--assembly")
    args = parser.parse_args()

    output_file = args.output_file
    output_dir = args.output_dir
    assembly = args.assembly
    extra = args.assembly

    with open(output_file) as output_file_handle:
        params = json.loads(output_file_handle.read())

    print(output_file)
    print(output_dir)
    print(assembly)
    pprint.pprint(params)

    if not os.path.exists(output_dir):
        os.makedirs(output_dir)
    
    vep_install_cmd = ["vep_install", "--NO_HTSLIB", "-a alcf", "--CACHEDIR", output_dir, "--SPECIES", assembly]
    vep_install_cmd = "vep_install --NO_HTSLIB -a alcf --CACHEDIR {0} --SPECIES {1}".format(output_dir, assembly)
    print("Running INSTALL.pl")
    #print(" ".join(vep_install_cmd))
    print(vep_install_cmd)
    exit_code = subprocess.call(vep_install_cmd, cwd=output_dir, shell=True)
    #process = subprocess.Popen(vep_install_cmd, shell=True, cwd=output_dir)

    print(exit_code)

    output_dict = dict(
        data_tables=dict(
            vep_cache_data=[{
                "path": output_dir,
                "dbkey": assembly,
                "name": assembly,
                "value": assembly
            }]
        )
    )
    with open(output_file, 'w') as output_file_handle:
        output_file_handle.write(json.dumps(output_dict))
    sys.exit(0)