#!/bin/bash

tool_path=$(dirname $0)

filein=$1
fileout_label=$2
fileout=$3
filelog=$4
export=$5
frequency=$6
max_freq=$7
allow_missing=$8
nb_alleles_min=$9
nb_alleles_max=${10}
type=${11}
bound_start=${12}
bound_end=${13}


if [ "${14}" != "None" ]
then samples="--samples ${14}"
fi

if [ "${15}" != "None" ]
then chromosomes="--chromosomes ${15}"
fi

if [ "$bound_start" -gt "$bound_end" ]
then tmp=$bound_start ; bound_start=$bound_end ; bound_end=$tmp ; echo "Warning : Lower bound must be lower than greater bound!" >&2
fi

if [ "$nb_alleles_min" -gt "$nb_alleles_max" ]
then tmp=$nb_alleles_min ; nb_alleles_min=$nb_alleles_max ; nb_alleles_max=$tmp ; echo "Warning : Minimum number of alleles must be lower than maximum number of allele!" >&2
fi

perl $tool_path/VCFToolsFilter.pl --input $filein --out $fileout_label --export $export --frequency $frequency --max_freq $max_freq --allow_missing $allow_missing --nb_alleles $nb_alleles_min','$nb_alleles_max --type $type --bounds $bound_start','$bound_end $samples $chromosomes

if [ "$export" = "VCF" ]
then cp  $fileout_label.recode.vcf $fileout ; rm $fileout_label.recode.vcf
elif [ "$export" = "freq" ]
then cp  $fileout_label.frq $fileout ; rm $fileout_label.frq
else cp  $fileout_label.ped $fileout; cp $fileout_label.map ${16} ; rm $fileout_label.ped $fileout_label.map
fi

cp vcftools.log $filelog
rm vcftools.log
