#!/bin/sh

DIR="$( cd "$( dirname "$0" )" && pwd )"
source $DIR/rtg-galaxy.cfg

# Temporary storage for STDERR
TMP_STDERR=$(mktemp) || exit 1

#echo "$(date) START $@" >>~/galaxy-rtg-wrapper.log
# Run the program, send STDERR to temporary file
$rtg snpintersect "$@" 2> $TMP_STDERR

#check program's exit code
if (( $? ));  then
    #echo "$(date) FAIL $@" >>~/galaxy-rtg-wrapper.log
    #cat $TMP_STDERR >>~/galaxy-rtg-wrapper.log
    #Program failed, send STDERR to real STDERR
    cat $TMP_STDERR >&2
    rm $TMP_STDERR
    exit 1
fi
#echo "$(date) DONE $@" >>~/galaxy-rtg-wrapper.log

#Program succeeded, delete STDERR file
rm $TMP_STDERR
exit 0
