#!/bin/sh

DIR="$( cd "$( dirname "$0" )" && pwd )"
source $DIR/rtg-galaxy.cfg

# Temporary storage for STDERR
# Temporary storage for mapping output
TMP_STDERR=$(mktemp) || exit 1

#echo "$(date) START $@" >>~/galaxy-rtg-wrapper.log

snpfile=$1
shift
snpoutputdir=$1
shift

# Run the program, send STDERR to temporary file
mkdir $snpoutputdir
tmpout=$snpoutputdir/snps.vcf
$rtg "$@" -s $tmpout -Z 2> $TMP_STDERR

#check program's exit code
if (( $? ));  then
    #echo "$(date) FAIL $@" >>~/galaxy-rtg-wrapper.log
    #cat $TMP_STDERR >>~/galaxy-rtg-wrapper.log
    #Program failed, send STDERR to real STDERR
    cat $TMP_STDERR >&2
    rm $TMP_STDERR
    rm -rf $tmpout
    exit 1
fi

mv $tmpout $snpfile

#echo "$(date) DONE $@" >>~/galaxy-rtg-wrapper.log

#Program succeeded, delete STDERR file
rm $TMP_STDERR
rm -rf $snpoutputdir
exit 0
