CDF      
   
   	DATE_TIME         	STRING256         STRING64   @   STRING32       STRING16      STRING8       STRING4       STRING2       N_PROF        N_PARAM       N_LEVELS      	N_HISTORY          N_CALIB          	   title         Argo float vertical profile    institution       CORIOLIS   source        
Argo float     history       X2018-02-06T11:51:10Z creation; 2018-02-06T11:51:37Z last update (coriolis COQC software)   
references        (http://www.argodatamgt.org/Documentation   user_manual_version       3.1    Conventions       Argo-3.1 CF-1.6    featureType       trajectoryProfile      comment_dmqc_operator         JPRIMARY | https://orcid.org/0000-0003-3873-5259 | C. Cabanes, LOPS/Ifremer        @   	DATA_TYPE                  	long_name         	Data type      conventions       Argo reference table 1     
_FillValue                    7   FORMAT_VERSION                 	long_name         File format version    
_FillValue                    7   HANDBOOK_VERSION               	long_name         Data handbook version      
_FillValue                    7   REFERENCE_DATE_TIME                 	long_name         !Date of reference for Julian days      conventions       YYYYMMDDHHMISS     
_FillValue                    7   
DATE_CREATION                   	long_name         Date of file creation      conventions       YYYYMMDDHHMISS     
_FillValue                    8   DATE_UPDATE                 	long_name         Date of update of this file    conventions       YYYYMMDDHHMISS     
_FillValue                    8   PLATFORM_NUMBER                   	long_name         Float unique identifier    conventions       WMO float identifier : A9IIIII     
_FillValue                    8,   PROJECT_NAME                  	long_name         Name of the project    
_FillValue                    8<   PI_NAME                   	long_name         "Name of the principal investigator     
_FillValue                    8   STATION_PARAMETERS           	            	long_name         ,List of available parameters for the station   conventions       Argo reference table 3     
_FillValue                  `  9<   CYCLE_NUMBER               	long_name         Float cycle number     conventions       =0...N, 0 : launch cycle (if exists), 1 : first complete cycle      
_FillValue                 9   	DIRECTION                  	long_name         !Direction of the station profiles      conventions       -A: ascending profiles, D: descending profiles      
_FillValue                    9   DATA_CENTRE                   	long_name         .Data centre in charge of float data processing     conventions       Argo reference table 4     
_FillValue                    9   DC_REFERENCE                  	long_name         (Station unique identifier in data centre   conventions       Data centre convention     
_FillValue                  @  9   DATA_STATE_INDICATOR                  	long_name         1Degree of processing the data have passed through      conventions       Argo reference table 6     
_FillValue                    9   	DATA_MODE                  	long_name         Delayed mode or real time data     conventions       >R : real time; D : delayed mode; A : real time with adjustment     
_FillValue                    9   
PLATFORM_TYPE                     	long_name         
Type of float      conventions       Argo reference table 23    
_FillValue                  @  9   FLOAT_SERIAL_NO                   	long_name         Serial number of the float     
_FillValue                  @  :8   FIRMWARE_VERSION                  	long_name         Instrument firmware version    
_FillValue                  @  :x   
WMO_INST_TYPE                     	long_name         Coded instrument type      conventions       Argo reference table 8     
_FillValue                    :   JULD               	long_name         ?Julian day (UTC) of the station relative to REFERENCE_DATE_TIME    
standard_name         time   units         "days since 1950-01-01 00:00:00 UTC     conventions       8Relative julian days with decimal part (as parts of day)   
resolution        ?Fll   
_FillValue        A.~       axis      T      comment_on_resolution         JULD resolution is 1 minute, except when JULD = JULD_LOCATION or when JULD = JULD_FIRST_MESSAGE (TRAJ file variable); in that case, JULD resolution is 1 second         :   JULD_QC                	long_name         Quality on date and time   conventions       Argo reference table 2     
_FillValue                    :   
JULD_LOCATION                  	long_name         @Julian day (UTC) of the location relative to REFERENCE_DATE_TIME   units         "days since 1950-01-01 00:00:00 UTC     conventions       8Relative julian days with decimal part (as parts of day)   
resolution        >	4E   
_FillValue        A.~            :   LATITUDE               	long_name         &Latitude of the station, best estimate     
standard_name         latitude   units         degree_north   
_FillValue        @i       	valid_min         V        	valid_max         @V        axis      Y           :   	LONGITUDE                  	long_name         'Longitude of the station, best estimate    
standard_name         	longitude      units         degree_east    
_FillValue        @i       	valid_min         f        	valid_max         @f        axis      X           :   POSITION_QC                	long_name         ,Quality on position (latitude and longitude)   conventions       Argo reference table 2     
_FillValue                    ;   POSITIONING_SYSTEM                    	long_name         Positioning system     
_FillValue                    ;   PROFILE_PRES_QC                	long_name         #Global quality flag of PRES profile    conventions       Argo reference table 2a    
_FillValue                    ;   PROFILE_TEMP_QC                	long_name         #Global quality flag of TEMP profile    conventions       Argo reference table 2a    
_FillValue                    ;   PROFILE_PSAL_QC                	long_name         #Global quality flag of PSAL profile    conventions       Argo reference table 2a    
_FillValue                    ;    VERTICAL_SAMPLING_SCHEME                  	long_name         Vertical sampling scheme   conventions       Argo reference table 16    
_FillValue                    ;$   CONFIG_MISSION_NUMBER                  	long_name         :Unique number denoting the missions performed by the float     conventions       !1...N, 1 : first complete mission      
_FillValue                 =$   PRES         
      
   	long_name         )Sea water pressure, equals 0 at sea-level      
standard_name         sea_water_pressure     
_FillValue        GO   units         decibar    	valid_min                	valid_max         F;    C_format      %7.1f      FORTRAN_format        F7.1   
resolution        =   axis      Z          =,   PRES_QC          
         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 d  B   
PRES_ADJUSTED            
      
   	long_name         )Sea water pressure, equals 0 at sea-level      
standard_name         sea_water_pressure     
_FillValue        GO   units         decibar    	valid_min                	valid_max         F;    C_format      %7.1f      FORTRAN_format        F7.1   
resolution        =   axis      Z          D   PRES_ADJUSTED_QC         
         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 d  I   PRES_ADJUSTED_ERROR          
         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         decibar    C_format      %7.1f      FORTRAN_format        F7.1   
resolution        =       K   TEMP         
      	   	long_name         $Sea temperature in-situ ITS-90 scale   
standard_name         sea_water_temperature      
_FillValue        GO   units         degree_Celsius     	valid_min               	valid_max         B      C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       P   TEMP_QC          
         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 d  V   
TEMP_ADJUSTED            
      	   	long_name         $Sea temperature in-situ ITS-90 scale   
standard_name         sea_water_temperature      
_FillValue        GO   units         degree_Celsius     	valid_min               	valid_max         B      C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       Wx   TEMP_ADJUSTED_QC         
         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 d  ]    TEMP_ADJUSTED_ERROR          
         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         degree_Celsius     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       ^d   PSAL         
      	   	long_name         Practical salinity     
standard_name         sea_water_salinity     
_FillValue        GO   units         psu    	valid_min         @      	valid_max         B$     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       c   PSAL_QC          
         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 d  it   
PSAL_ADJUSTED            
      	   	long_name         Practical salinity     
standard_name         sea_water_salinity     
_FillValue        GO   units         psu    	valid_min         @      	valid_max         B$     C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       j   PSAL_ADJUSTED_QC         
         	long_name         quality flag   conventions       Argo reference table 2     
_FillValue                 d  p`   PSAL_ADJUSTED_ERROR          
         	long_name         VContains the error on the adjusted values as determined by the delayed mode QC process     
_FillValue        GO   units         psu    C_format      %9.3f      FORTRAN_format        F9.3   
resolution        :o       q   HISTORY_INSTITUTION                      	long_name         "Institution which performed action     conventions       Argo reference table 4     
_FillValue                       HISTORY_STEP                     	long_name         Step in data processing    conventions       Argo reference table 12    
_FillValue                       HISTORY_SOFTWARE                     	long_name         'Name of software which performed action    conventions       Institution dependent      
_FillValue                       HISTORY_SOFTWARE_RELEASE                     	long_name         2Version/release of software which performed action     conventions       Institution dependent      
_FillValue                       HISTORY_REFERENCE                        	long_name         Reference of database      conventions       Institution dependent      
_FillValue                       HISTORY_DATE                      	long_name         #Date the history record was created    conventions       YYYYMMDDHHMISS     
_FillValue                    T   HISTORY_ACTION                       	long_name         Action performed on data   conventions       Argo reference table 7     
_FillValue                    p   HISTORY_PARAMETER                        	long_name         (Station parameter action is performed on   conventions       Argo reference table 3     
_FillValue                     x   HISTORY_START_PRES                    	long_name          Start pressure action applied on   
_FillValue        GO   units         decibar            HISTORY_STOP_PRES                     	long_name         Stop pressure action applied on    
_FillValue        GO   units         decibar            HISTORY_PREVIOUS_VALUE                    	long_name         +Parameter/Flag previous value before action    
_FillValue        GO           HISTORY_QCTEST                       	long_name         <Documentation of tests performed, tests failed (in hex form)   conventions       EWrite tests performed when ACTION=QCP$; tests failed when ACTION=QCF$      
_FillValue                        	PARAMETER               	            	long_name         /List of parameters with calibration information    conventions       Argo reference table 3     
_FillValue                    wL   SCIENTIFIC_CALIB_EQUATION               	            	long_name         'Calibration equation for this parameter    
_FillValue                    x   SCIENTIFIC_CALIB_COEFFICIENT            	            	long_name         *Calibration coefficients for this equation     
_FillValue                       SCIENTIFIC_CALIB_COMMENT            	            	long_name         .Comment applying to this parameter calibration     
_FillValue                       SCIENTIFIC_CALIB_DATE               	             	long_name         Date of calibration    conventions       YYYYMMDDHHMISS     
_FillValue                    Argo profile    3.1 1.2 19500101000000  20180206115110  20210604095858  6901758 6901758 NAOS                                                            NAOS                                                            Virginie THIERRY                                                Virginie THIERRY                                                PRES            TEMP            PSAL            PRES            TEMP            PSAL                  AA  IFIF                                                                2C  2B  DA  ARVOR_D                         ARVOR_D                         OIN-15-ARDP-03                  OIN-15-ARDP-03                  5608A10                         5608A10                         838 838 @_u@_u11  @_|F@_|F@Ja]!I@Ja]!IAcw+Acw+11  GPS     GPS     AA  AC  AF  Primary sampling: averaged [10 sec sampling, 20 dbar average from 3800 dbar to 500 dbar; 10 sec sampling, 10 dbar average from 500 dbar to 10 dbar; 10 sec sampling, 1 dbar average from 10 dbar to 5.3 dbar]                                                   Near-surface sampling: averaged, unpumped [10 sec sampling, 1 dbar average from 5.3 dbar to surface]                                                                                                                                                                  @33@A   AA!AyAffBB3B\BB  B  B  BBffBCffC CC&C/LC9CC CM3CWCa CkCuffCLC CٚC C3C CٚCfCfC3C3C3C3CٚCų3CʌC CfCfCC㙚CfC CCCDD	 DfDfDDfD" D'D,D1D6 D; D@ DEDJ DODTٚDY D^ DcfDh3DmfDr3DwD|fDDc3DɚDIDɚDP DfDFfDfDFfDDLDDlDɚDFfD DFfDDFfD D@ DɚDS3DDID3DFfD DP DfDLDfDP D DYD3DVfD3DP DɚDYD3DIDfDFfD DlDDC3DfE $E^fEE3E6fEffEEfE
)EtEE
E$Eh EEfE)EaE3EE( Ec3E3EE( EiE E!E#!E$aE%3E&E($E)ffE*E+ E-$E.c3E/ E0E2)E3h E43E5fE7.fE81    ?  ?33@9@y@GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111222222222222222222222222222222222222222222222222111111                                                                                                                                                                             @33@A   AA!AyAffBB3B\BB  B  B  BBffBCffC CC&C/LC9CC CM3CWCa CkCuffCLC CٚC C3C CٚCfCfC3C3C3C3CٚCų3CʌC CfCfCC㙚CfC CCCDD	 DfDfDDfD" D'D,D1D6 D; D@ DEDJ DODTٚDY D^ DcfDh3DmfDr3DwD|fDDc3DɚDIDɚDP DfDFfDfDFfDDLDDlDɚDFfD DFfDDFfD D@ DɚDS3DDID3DFfD DP DfDLDfDP D DYD3DVfD3DP DɚDYD3DIDfDFfD DlDDC3DfE $E^fEE3E6fEffEEfE
)EtEE
E$Eh EEfE)EaE3EE( Ec3E3EE( EiE E!E#!E$aE%3E&E($E)ffE*E+ E-$E.c3E/ E0E2)E3h E43E5fE7.fE81    ?  ?33@9@y@GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111                                                                                                                                                                             @ )@ /@ 6@ ?}@ D@ j@ !@ @2@x@w@j@G@@ψ@o@Wb@U@H@'@m@@@6@|?@2@j@D@D@@{@Z@@@%@k.@@e@	5@	z2@	w@
@
I@
D@
|@{@Z@@@#@hs@@@
7L@
@$@@7L@@F@|@UU@@k.@@@j@@@@$@9@6@&@H]@C@Yn@@i"@@z2@@@@@%@@4@@ E@ ψ@!X@!@"o@"@#x@$j@$@%6@%@&""@&@'5@@'@(M$@(@)Yn@);@*i@*Y@+x@,@,P@-{@-@.'@.@/7@/@0G@0@1Z@1ތ@2hs@2L@3x@4j@4@5@5H@6#@6@72@7@8I@8[@9X@9T@:i!@:@;X@<@<8@=@=@>$.@>f@?7L@?k@@E@@@AX@A<@Bg@B@Cz@D@D@E@EH@F"@F@G5@@G@HF@H@IX@I@Jg@J@Ky@L@L@Mn@MT@N(G@N@   @ @ @ @ @ !sGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOA
A
33A\A5?AAA7L@C@ȴ@V@@\)@7L@@;d@@E@-@@1'@
=@@@@V@@dZ@@@  @b@z@F@;@j@I@P@@@@X@@@1'@^@G@/@1@@`B@@u@I@@R@@@
@ȴ@y@@%@ @^5@@@@@@@+@@Ĝ@;@~ȴ@}?}@|D@{
@z@xbN@wP@v5?@t9X@r~@q#@qhs@pr@o|@nR@nff@l/@lz@kS@iG@g@eT@e@d1@d@c@b@a@]@^v@^@_\)@^@^v@\@[m@Y@X`@V@U@Tj@S@T@P1'@Mh@Mh@L@L@M@L@LI@Kƨ@K33@JH@J@J^5@J-@I@I@IX@H`@Hr@Gw@Gl@G
=@Fy@F@F@Fff@FE@F$@E-@EO@EV@D@D@D@D@D@EV@EV@D/@Dj@Dj@Dj@D@Dj@C@C@C33@B@B@B=q@A#@Ax@AG@Ahs@A@@@A@@@?l@>+A"A"A"A"AAjGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111222222222222222222222222222222222222222222222222331111                                                                                                                                                                             A
A
33A\A5?AAA7L@C@ȴ@V@@\)@7L@@;d@@E@-@@1'@
=@@@@V@@dZ@@@  @b@z@F@;@j@I@P@@@@X@@@1'@^@G@/@1@@`B@@u@I@@R@@@
@ȴ@y@@%@ @^5@@@@@@@+@@Ĝ@;@~ȴ@}?}@|D@{
@z@xbN@wP@v5?@t9X@r~@q#@qhs@pr@o|@nR@nff@l/@lz@kS@iG@g@eT@e@d1@d@c@b@a@]@^v@^@_\)@^@^v@\@[m@Y@X`@V@U@Tj@S@T@P1'@Mh@Mh@L@L@M@L@LI@Kƨ@K33@JH@J@J^5@J-@I@I@IX@H`@Hr@Gw@Gl@G
=@Fy@F@F@Fff@FE@F$@E-@EO@EV@D@D@D@D@D@EV@EV@D/@Dj@Dj@Dj@D@Dj@C@C@C33@B@B@B=q@A#@Ax@AG@Ahs@A@@@A@@@?l@>+A"A"A"A"AAjGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111331111                                                                                                                                                                             ;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;oGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOB
`B
fB
B
B
BB)B0!B49B(B
B
BEBVBZBABVBffBvBzBBDBBBBBB3BFBFBRBdBXBjBBBBdBRB-BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB'B3B9B?B9BFBRBXBjBjBdBFBjBBĜBÖBÖBBB}B}BjBdBdBqB}BRB?BXBjBBƨBȴBBBBBBBBBBBBBB
B
B
B
B
BB
BBBBBBBBBBBBBBBBBB
B
BBBBBBBBBBBBBBB
B
XB
9B
!B
!B
GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111333333333333333333333333333333333333333333333333333333                                                                                                                                                                             B
\B
bB
B BB*B9B@*BDFB9BBBUBf"Bj@BQBf/BvBBBEBBBBB8BaBÌBơBƦBȵBBBBBBBBB¶BBB~BIB!B?BCBFB=B@BSBVB`BpBBBBBB	BBBBBBBBBB
BBBBB(B3BDBGB\BiBwBBBBBBBBBBBB*B7BEBGBZBpBˀBΘBΟB͠BȌBθBBBBBBBB
B BBBB3BBB&B@BcBٍBۤBݺBBBBBBBB)B8BABUB]BlBsBxBBBBBBBBBBBBBBBBBBBB!B(B-B7B8B?BJBPBSB]BbBkBnBtB}B~BB~B
B
YB
9B
"B
"B
GOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGO111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111333333                                                                                                                                                                             ;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;o;oGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOGOPRES            TEMP            PSAL            PRES            TEMP            PSAL            PRES            TEMP            PSAL            PRES            TEMP            PSAL            PRES_ADJUSTED = PRES                                                                                                                                                                                                                                            TEMP_ADJUSTED = TEMP                                                                                                                                                                                                                                            new conductivity = original conductivity * (1 + delta*TEMP + CPcor_SBE*PRES) / (1 + delta*TEMP_ADJUSTED + CPcor_new*PRES_ADJUSTED)                                                                                                                              none                                                                                                                                                                                                                                                            none                                                                                                                                                                                                                                                            PSAL_ADJUSTED = PSAL  + launch_offset                                                                                                                                                                                                                           PRES_ADJUSTED = PRES                                                                                                                                                                                                                                            TEMP_ADJUSTED = TEMP                                                                                                                                                                                                                                            new conductivity = original conductivity * (1 + delta*TEMP + CPcor_SBE*PRES) / (1 + delta*TEMP_ADJUSTED + CPcor_new*PRES_ADJUSTED)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              none                                                                                                                                                                                                                                                            none                                                                                                                                                                                                                                                            CPcor_new = -1.35e-07, CPcor_SBE = -9.57e-08, delta = 3.25e-06                                                                                                                                                                                                  none                                                                                                                                                                                                                                                            none                                                                                                                                                                                                                                                            launch_offset = 0.0156                                                                                                                                                                                                                                          none                                                                                                                                                                                                                                                            none                                                                                                                                                                                                                                                            CPcor_new = -1.35e-07, CPcor_SBE = -9.57e-08, delta = 3.25e-06                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  This float is autocorrecting pressure. Data is good within the specified error.                                                                                                                                                                                 Data is good within the specified error.                                                                                                                                                                                                                        New conductivity computed by using a different CPcor value from that provided by Sea-Bird.                                                                                                                                                                      none                                                                                                                                                                                                                                                            none                                                                                                                                                                                                                                                            An offset was detected by comparing float data with the reference CTD cast made at float launch. This offset of 0.0156 PSU was added . Error = maximum [statistical uncertainty, 0.004]. OWC Method, 3.00,  -CTD202101 -                                        This float is autocorrecting pressure. Data is good within the specified error.                                                                                                                                                                                 Data is good within the specified error.                                                                                                                                                                                                                        New conductivity computed by using a different CPcor value from that provided by Sea-Bird.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      202104151032572021041510325720210415103257202106040958582021060409585820210604095858202104151032572021041510325720210415103257                                          IF  IF  ARFMARFMCODACODA017c017c                                                                                                                                2018020611511020180206115110                                        GOGOGOGOGOGO                                IF  IF  ARGQARGQCOQCCOQC3.1 3.1                                                                                                                                 2018020611513720180206115137QCP$QCP$                                GOGOGOGOGOGO000000000088FB7E0000000000689B7EIF  IF  ARGQARGQCOQCCOQC3.1 3.1                                                                                                                                 2018020611513720180206115137QCF$QCF$                                GOGOGOGOGOGO00000000008000000000000000600000IF      ARSQ    OW      1.1     CTD2016V1                                                                                                                       20180605165427              IP      PSAL                            @33GOE81GOGOGO                                IF      ARSQ    OW      3.00    CTD202101                                                                                                                       20210604095858              IP      PSAL                            @33GOE81GOGOGO                                