#!/usr/bin/perl

# SET UP A CRON JOB THAT RUNS FREQUENTLY (EG. EVERY 2 MIN)

use warnings;
use strict;
use File::Copy;
use File::Which;
use File::Basename;

## SETTINGS
my $queue_file = '/some/world/accessible/nfs/import_queue.txt';
my $ftp_dir = '/your/galaxy/ftp';
my $admin_email = 'admin@yoursite.gov';

# INPUT
die("No args expected\n") if @ARGV;
die("Queue file does not exist: $queue_file\n") unless -f $queue_file;
die("FTP folder does not exist: $ftp_dir\n") unless -d $ftp_dir;

# EXIT IF EMPTY
exit unless -s $queue_file;

# CHECK IF SENDMAIL AVAILABLE
our $sendmail=which('sendmail'); # undef if not found

# MOVE QUEUE, CREATE NEW EMPTY FILE
my $current_queue_file="$queue_file.$$";
move($queue_file,$current_queue_file);
open(Q, ">$queue_file") or die($!);
close(Q) or die($!);
chmod 0666, $queue_file or die("Unable to chmod queue file: $!\n");

# LOAD QUEUE
my @queue=();
open(Q, "<$current_queue_file") or die($!);
while (<Q>) {
    chomp;
    my @row=split(/\t/);
    push @queue, \@row;
}
close Q;
unlink($current_queue_file);

# COPY FILES
my %notify=();
while (@queue) {
    my $row=shift @queue;
    my ($email,$path)=@$row;
    copypath($path,"$ftp_dir/$email");
    if ($sendmail) {
        $notify{$email}=[] unless exists($notify{$email});
        push @{$notify{$email}}, $path;
    }
}

# SEND NOTIFICATION EMAILS
foreach my $email (keys %notify) {
    my $msg="The following files are available in your FTP folder; use the Upload tool to import them.\n\n"
        . join("\n", @{$notify{$email}})."\n";
    email($sendmail,$admin_email,'Galaxy import complete',$email,$msg);
}

## SUBROUTINES

# COPY FILE/FOLDER TO DEST FOLDER
sub copypath {
    my ($src,$destdir)=@_;
    return unless $src and $destdir;
    $src = $1 if $src =~ /^(.+)\/$/;
    $destdir = $1 if $destdir =~ /^(.+)\/$/;
	# make dest if not exist
	unless (-d $destdir) {
		mkdir($destdir) or warn("Unable to mkdir $destdir: $!\n");
		chmod 0775, $destdir or warn("Unable to chmod dir, $destdir: $!\n");
	}
    if (-d $src) {
        #print "Recursively copy folder $src to $destdir\n";
		my ($subdir,$parentdir)=fileparse($src);
		$destdir .= "/$subdir";
        # make dest if not exist
        unless (-d $destdir) {
            mkdir($destdir) or warn("Unable to mkdir $destdir: $!\n");
            chmod 0775, $destdir or warn("Unable to chmod dir, $destdir: $!\n");
        }
        # process src folder
        unless (opendir(DIR, $src)) {
            warn("Unable to open dir, $src\n");
            return;
        }
        my @files= grep { $_ !~ /^\./ } readdir DIR or warn("Unable to readdir, $src: $!\n");
        closedir(DIR);
        #print "Folder, $src, contains ", scalar(@files), " files\n";
        foreach my $file (@files) {
            copypath("$src/$file",$destdir);
        }
    } elsif (-f $src) {
		my ($file,$dir)=fileparse($src);
		my $destfile="$destdir/$file";
		#print "Copy file, $src to $destfile\n";
        copy($src,$destdir) or warn("Unable to copy $src: $!\n");
        chmod 0664, $destfile or warn("Unable to chmod file, $destfile: $!\n");
    } else {
        warn("Invalid path, $src\n");
    }
}

sub email {
    my ($sendmail, $from, $subj, $to, $msg)=@_;
    return unless defined($sendmail);
	die("From email not defined\n") unless $from;
	die("Subj not defined\n") unless $subj;
	die("Receipient email not defined\n") unless $to;
	die("Message not defined\n") unless $msg;
	my $email=
        "Reply-to: $from\n".
        "Subject: $subj\n".
        "To: $to\n".
        "Content-type: text/plain\n\n".
        $msg;
    open(SENDMAIL, "|$sendmail -t") or die "Cannot open $sendmail: $!";
    print SENDMAIL $email;
    close(SENDMAIL);
}

__END__
Copyright(c) 2011 US DOE Joint Genome Institute.
Use freely under the same license as Galaxy itself.
