
use strict;
use warnings;
use File::Basename; 
use Cwd;
use File::Path qw(make_path remove_tree);
die qq(
Bad numbr of inputs

) if(!@ARGV);

my $bam_normal;
my $bam_tumor;
my $player_options = "";
my $output;
my $action;
my $ref_genome;

foreach my $input (@ARGV) 
{
	my @tmp = split "::", $input;
	if($tmp[0] eq "BAMNORMAL") 
	{
		$bam_normal = $tmp[1];
	} 
	elsif($tmp[0] eq "BAMTUMOR") 
	{
		$bam_tumor = $tmp[1];
	} 
	elsif($tmp[0] eq "OPTION") 
	{
		$player_options = "$player_options ${tmp[1]}";
	}
	elsif($tmp[0] eq "REFGENOME") 
	{
		$ref_genome = $tmp[1];
	}  
	elsif($tmp[0] eq "ACTION") 
	{
		$action = $tmp[1];
	}  
	elsif($tmp[0] eq "OUTPUT") 
	{
		$output = $tmp[1];
	}  

	else 
	{
		die("Unknown Input: $input\n");
	}
}


#Create Symbolic links and indexes

my $working_dir = cwd();

system ("ln -s $bam_normal $working_dir/normal.bam");
system ("samtools index $working_dir/normal.bam");
 
system ("ln -s $bam_tumor $working_dir/tumor.bam");
system ("samtools index $working_dir/tumor.bam");
    	

#run jsm 

if($action eq "classify")
{
	system ("jsm.py $action $player_options $ref_genome $working_dir/normal.bam $working_dir/tumor.bam");
}
else
{
	system ("jsm.py $action $player_options $ref_genome $working_dir/normal.bam $working_dir/tumor.bam $output");
}

