package utilsTest ;

use diagnostics; # this gives you more debugging information
use warnings;    # this warns you of bad practices
use strict;      # this prevents silly errors
use Exporter ;
use Carp ;

use Data::Dumper ;

our $VERSION = "1.0";
our @ISA = qw(Exporter);
our @EXPORT = qw( getHttpFileVersionTest getHttpFileTest unzipFileTest);
our %EXPORT_TAGS = ( ALL => [qw( getHttpFileVersionTest getHttpFileTest unzipFileTest)] );

use lib '/Users/fgiacomoni/Inra/labs/perl/downloader-bank-hmdb/lib' ;
use utils qw( :ALL ) ;


sub getHttpFileVersionTest {
	my ($url) = @_ ;
    my $oObject = utils->new() ;
    my ($version) = $oObject->getHttpFileVersion($url) ;
#    print Dumper $version ;
    return ($version) ;
}

sub getHttpFileTest {
	my ($url, $filename) = @_ ;
    my $oObject = utils->new() ;
    my ($file) = $oObject->getHttpFile($url, $filename) ;
#    print Dumper $version ;
    return ($file) ;
}

sub unzipFileTest {
	my ($archive, $filePath, $fileName) = @_ ;
    my $oObject = utils->new() ;
    $oObject->unzipFile($archive, $filePath, $fileName) ;
#    print Dumper $version ;
    return (1) ;
}


1 ;