/*
 * Decompiled with CFR 0.152.
 */
package blasttools;

import blast.BlastSummary;
import java.io.File;
import java.io.InputStream;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class Processor {
    protected static File src;
    protected JSONObject config;

    protected abstract void readConfig() throws Exception;

    protected abstract void read(File var1) throws Exception;

    protected abstract void write(String var1) throws Exception;

    public static Processor getProcessor(String name) throws Exception {
        if (name.equals("blastn")) {
            return new BlastSummary("N");
        }
        if (name.equals("blastp")) {
            return new BlastSummary("P");
        }
        throw new Exception("Unknown processor " + name);
    }

    protected boolean isInt(String value) {
        try {
            if (value.length() > 0) {
                Integer.parseInt(value);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isDouble(String value) {
        try {
            if (value.length() > 0) {
                Double.parseDouble(value);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String shortFileName(String fileName) {
        if (fileName.lastIndexOf(".") != -1) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    protected JSONObject loadConfig(String key, String path, String[] required) {
        InputStream is = BlastSummary.class.getResourceAsStream(path);
        try {
            int len = is.available();
            byte[] data = new byte[len];
            is.read(data);
            String jStr = new String(data);
            JSONObject jObj = (JSONObject)JSONValue.parse(jStr);
            if (jObj.containsKey(key)) {
                JSONObject config = (JSONObject)jObj.get(key);
                for (int i = 0; i < required.length; ++i) {
                    if (config.containsKey(required[i])) continue;
                    return null;
                }
                return config;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int intVal(String key, JSONObject jObj) throws Exception {
        try {
            return ((Number)jObj.get(key)).intValue();
        }
        catch (Exception e) {
            throw new Exception("Invalid key " + key);
        }
    }
}

