
/******************************************************************************
 *
 *  This file is part of meryl-utility, a collection of miscellaneous code
 *  used by Meryl, Canu and others.
 *
 *  This software is based on:
 *    'Canu' v2.0              (https://github.com/marbl/canu)
 *  which is based on:
 *    'Celera Assembler' r4587 (http://wgs-assembler.sourceforge.net)
 *    the 'kmer package' r1994 (http://kmer.sourceforge.net)
 *
 *  Except as indicated otherwise, this is a 'United States Government Work',
 *  and is released in the public domain.
 *
 *  File 'README.licenses' in the root directory of this distribution
 *  contains full conditions and disclaimers.
 */

//  This is the output of bitsTest -verbose.  It is (supposedly) the correct
//  output of the mask building functions.

char const *maskstr[129][10] = {
  { "00000000000000000000000000000000", "00000000000000000000000000000000",  "0000000000000000", "0000000000000000",  "00000000", "00000000",  "0000", "0000",  "00", "00" },
  { "00000000000000000000000000000001", "80000000000000000000000000000000",  "0000000000000001", "8000000000000000",  "00000001", "80000000",  "0001", "8000",  "01", "80" },
  { "00000000000000000000000000000003", "c0000000000000000000000000000000",  "0000000000000003", "c000000000000000",  "00000003", "c0000000",  "0003", "c000",  "03", "c0" },
  { "00000000000000000000000000000007", "e0000000000000000000000000000000",  "0000000000000007", "e000000000000000",  "00000007", "e0000000",  "0007", "e000",  "07", "e0" },
  { "0000000000000000000000000000000f", "f0000000000000000000000000000000",  "000000000000000f", "f000000000000000",  "0000000f", "f0000000",  "000f", "f000",  "0f", "f0" },
  { "0000000000000000000000000000001f", "f8000000000000000000000000000000",  "000000000000001f", "f800000000000000",  "0000001f", "f8000000",  "001f", "f800",  "1f", "f8" },
  { "0000000000000000000000000000003f", "fc000000000000000000000000000000",  "000000000000003f", "fc00000000000000",  "0000003f", "fc000000",  "003f", "fc00",  "3f", "fc" },
  { "0000000000000000000000000000007f", "fe000000000000000000000000000000",  "000000000000007f", "fe00000000000000",  "0000007f", "fe000000",  "007f", "fe00",  "7f", "fe" },
  { "000000000000000000000000000000ff", "ff000000000000000000000000000000",  "00000000000000ff", "ff00000000000000",  "000000ff", "ff000000",  "00ff", "ff00",  "ff", "ff" },
  { "000000000000000000000000000001ff", "ff800000000000000000000000000000",  "00000000000001ff", "ff80000000000000",  "000001ff", "ff800000",  "01ff", "ff80",  "ff", "ff" },
  { "000000000000000000000000000003ff", "ffc00000000000000000000000000000",  "00000000000003ff", "ffc0000000000000",  "000003ff", "ffc00000",  "03ff", "ffc0",  "ff", "ff" },
  { "000000000000000000000000000007ff", "ffe00000000000000000000000000000",  "00000000000007ff", "ffe0000000000000",  "000007ff", "ffe00000",  "07ff", "ffe0",  "ff", "ff" },
  { "00000000000000000000000000000fff", "fff00000000000000000000000000000",  "0000000000000fff", "fff0000000000000",  "00000fff", "fff00000",  "0fff", "fff0",  "ff", "ff" },
  { "00000000000000000000000000001fff", "fff80000000000000000000000000000",  "0000000000001fff", "fff8000000000000",  "00001fff", "fff80000",  "1fff", "fff8",  "ff", "ff" },
  { "00000000000000000000000000003fff", "fffc0000000000000000000000000000",  "0000000000003fff", "fffc000000000000",  "00003fff", "fffc0000",  "3fff", "fffc",  "ff", "ff" },
  { "00000000000000000000000000007fff", "fffe0000000000000000000000000000",  "0000000000007fff", "fffe000000000000",  "00007fff", "fffe0000",  "7fff", "fffe",  "ff", "ff" },
  { "0000000000000000000000000000ffff", "ffff0000000000000000000000000000",  "000000000000ffff", "ffff000000000000",  "0000ffff", "ffff0000",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000000001ffff", "ffff8000000000000000000000000000",  "000000000001ffff", "ffff800000000000",  "0001ffff", "ffff8000",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000000003ffff", "ffffc000000000000000000000000000",  "000000000003ffff", "ffffc00000000000",  "0003ffff", "ffffc000",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000000007ffff", "ffffe000000000000000000000000000",  "000000000007ffff", "ffffe00000000000",  "0007ffff", "ffffe000",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000000000fffff", "fffff000000000000000000000000000",  "00000000000fffff", "fffff00000000000",  "000fffff", "fffff000",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000000001fffff", "fffff800000000000000000000000000",  "00000000001fffff", "fffff80000000000",  "001fffff", "fffff800",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000000003fffff", "fffffc00000000000000000000000000",  "00000000003fffff", "fffffc0000000000",  "003fffff", "fffffc00",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000000007fffff", "fffffe00000000000000000000000000",  "00000000007fffff", "fffffe0000000000",  "007fffff", "fffffe00",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000000000ffffff", "ffffff00000000000000000000000000",  "0000000000ffffff", "ffffff0000000000",  "00ffffff", "ffffff00",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000000001ffffff", "ffffff80000000000000000000000000",  "0000000001ffffff", "ffffff8000000000",  "01ffffff", "ffffff80",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000000003ffffff", "ffffffc0000000000000000000000000",  "0000000003ffffff", "ffffffc000000000",  "03ffffff", "ffffffc0",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000000007ffffff", "ffffffe0000000000000000000000000",  "0000000007ffffff", "ffffffe000000000",  "07ffffff", "ffffffe0",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000000fffffff", "fffffff0000000000000000000000000",  "000000000fffffff", "fffffff000000000",  "0fffffff", "fffffff0",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000001fffffff", "fffffff8000000000000000000000000",  "000000001fffffff", "fffffff800000000",  "1fffffff", "fffffff8",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000003fffffff", "fffffffc000000000000000000000000",  "000000003fffffff", "fffffffc00000000",  "3fffffff", "fffffffc",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000007fffffff", "fffffffe000000000000000000000000",  "000000007fffffff", "fffffffe00000000",  "7fffffff", "fffffffe",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000000ffffffff", "ffffffff000000000000000000000000",  "00000000ffffffff", "ffffffff00000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000001ffffffff", "ffffffff800000000000000000000000",  "00000001ffffffff", "ffffffff80000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000003ffffffff", "ffffffffc00000000000000000000000",  "00000003ffffffff", "ffffffffc0000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000007ffffffff", "ffffffffe00000000000000000000000",  "00000007ffffffff", "ffffffffe0000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000000fffffffff", "fffffffff00000000000000000000000",  "0000000fffffffff", "fffffffff0000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000001fffffffff", "fffffffff80000000000000000000000",  "0000001fffffffff", "fffffffff8000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000003fffffffff", "fffffffffc0000000000000000000000",  "0000003fffffffff", "fffffffffc000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000007fffffffff", "fffffffffe0000000000000000000000",  "0000007fffffffff", "fffffffffe000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000000ffffffffff", "ffffffffff0000000000000000000000",  "000000ffffffffff", "ffffffffff000000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000001ffffffffff", "ffffffffff8000000000000000000000",  "000001ffffffffff", "ffffffffff800000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000003ffffffffff", "ffffffffffc000000000000000000000",  "000003ffffffffff", "ffffffffffc00000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000007ffffffffff", "ffffffffffe000000000000000000000",  "000007ffffffffff", "ffffffffffe00000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000000fffffffffff", "fffffffffff000000000000000000000",  "00000fffffffffff", "fffffffffff00000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000001fffffffffff", "fffffffffff800000000000000000000",  "00001fffffffffff", "fffffffffff80000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000003fffffffffff", "fffffffffffc00000000000000000000",  "00003fffffffffff", "fffffffffffc0000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000007fffffffffff", "fffffffffffe00000000000000000000",  "00007fffffffffff", "fffffffffffe0000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000000ffffffffffff", "ffffffffffff00000000000000000000",  "0000ffffffffffff", "ffffffffffff0000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000001ffffffffffff", "ffffffffffff80000000000000000000",  "0001ffffffffffff", "ffffffffffff8000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000003ffffffffffff", "ffffffffffffc0000000000000000000",  "0003ffffffffffff", "ffffffffffffc000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000007ffffffffffff", "ffffffffffffe0000000000000000000",  "0007ffffffffffff", "ffffffffffffe000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000000fffffffffffff", "fffffffffffff0000000000000000000",  "000fffffffffffff", "fffffffffffff000",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000001fffffffffffff", "fffffffffffff8000000000000000000",  "001fffffffffffff", "fffffffffffff800",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000003fffffffffffff", "fffffffffffffc000000000000000000",  "003fffffffffffff", "fffffffffffffc00",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000007fffffffffffff", "fffffffffffffe000000000000000000",  "007fffffffffffff", "fffffffffffffe00",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000000ffffffffffffff", "ffffffffffffff000000000000000000",  "00ffffffffffffff", "ffffffffffffff00",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000001ffffffffffffff", "ffffffffffffff800000000000000000",  "01ffffffffffffff", "ffffffffffffff80",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000003ffffffffffffff", "ffffffffffffffc00000000000000000",  "03ffffffffffffff", "ffffffffffffffc0",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000007ffffffffffffff", "ffffffffffffffe00000000000000000",  "07ffffffffffffff", "ffffffffffffffe0",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000000fffffffffffffff", "fffffffffffffff00000000000000000",  "0fffffffffffffff", "fffffffffffffff0",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000001fffffffffffffff", "fffffffffffffff80000000000000000",  "1fffffffffffffff", "fffffffffffffff8",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000003fffffffffffffff", "fffffffffffffffc0000000000000000",  "3fffffffffffffff", "fffffffffffffffc",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000007fffffffffffffff", "fffffffffffffffe0000000000000000",  "7fffffffffffffff", "fffffffffffffffe",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000000ffffffffffffffff", "ffffffffffffffff0000000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000001ffffffffffffffff", "ffffffffffffffff8000000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000003ffffffffffffffff", "ffffffffffffffffc000000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000007ffffffffffffffff", "ffffffffffffffffe000000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000000fffffffffffffffff", "fffffffffffffffff000000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000001fffffffffffffffff", "fffffffffffffffff800000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000003fffffffffffffffff", "fffffffffffffffffc00000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000007fffffffffffffffff", "fffffffffffffffffe00000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000000ffffffffffffffffff", "ffffffffffffffffff00000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000001ffffffffffffffffff", "ffffffffffffffffff80000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000003ffffffffffffffffff", "ffffffffffffffffffc0000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000007ffffffffffffffffff", "ffffffffffffffffffe0000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000000fffffffffffffffffff", "fffffffffffffffffff0000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000001fffffffffffffffffff", "fffffffffffffffffff8000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000003fffffffffffffffffff", "fffffffffffffffffffc000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000007fffffffffffffffffff", "fffffffffffffffffffe000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000000ffffffffffffffffffff", "ffffffffffffffffffff000000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000001ffffffffffffffffffff", "ffffffffffffffffffff800000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000003ffffffffffffffffffff", "ffffffffffffffffffffc00000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000007ffffffffffffffffffff", "ffffffffffffffffffffe00000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000000fffffffffffffffffffff", "fffffffffffffffffffff00000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000001fffffffffffffffffffff", "fffffffffffffffffffff80000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000003fffffffffffffffffffff", "fffffffffffffffffffffc0000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000007fffffffffffffffffffff", "fffffffffffffffffffffe0000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000000ffffffffffffffffffffff", "ffffffffffffffffffffff0000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000001ffffffffffffffffffffff", "ffffffffffffffffffffff8000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000003ffffffffffffffffffffff", "ffffffffffffffffffffffc000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000007ffffffffffffffffffffff", "ffffffffffffffffffffffe000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000000fffffffffffffffffffffff", "fffffffffffffffffffffff000000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000001fffffffffffffffffffffff", "fffffffffffffffffffffff800000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000003fffffffffffffffffffffff", "fffffffffffffffffffffffc00000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000007fffffffffffffffffffffff", "fffffffffffffffffffffffe00000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000000ffffffffffffffffffffffff", "ffffffffffffffffffffffff00000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000001ffffffffffffffffffffffff", "ffffffffffffffffffffffff80000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000003ffffffffffffffffffffffff", "ffffffffffffffffffffffffc0000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000007ffffffffffffffffffffffff", "ffffffffffffffffffffffffe0000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000000fffffffffffffffffffffffff", "fffffffffffffffffffffffff0000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000001fffffffffffffffffffffffff", "fffffffffffffffffffffffff8000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000003fffffffffffffffffffffffff", "fffffffffffffffffffffffffc000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000007fffffffffffffffffffffffff", "fffffffffffffffffffffffffe000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000000ffffffffffffffffffffffffff", "ffffffffffffffffffffffffff000000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000001ffffffffffffffffffffffffff", "ffffffffffffffffffffffffff800000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000003ffffffffffffffffffffffffff", "ffffffffffffffffffffffffffc00000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000007ffffffffffffffffffffffffff", "ffffffffffffffffffffffffffe00000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00000fffffffffffffffffffffffffff", "fffffffffffffffffffffffffff00000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00001fffffffffffffffffffffffffff", "fffffffffffffffffffffffffff80000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00003fffffffffffffffffffffffffff", "fffffffffffffffffffffffffffc0000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00007fffffffffffffffffffffffffff", "fffffffffffffffffffffffffffe0000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0000ffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffff0000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0001ffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffff8000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0003ffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffc000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0007ffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffe000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "000fffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffff000",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "001fffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffff800",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "003fffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffffc00",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "007fffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffffe00",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "00ffffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffff00",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "01ffffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffff80",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "03ffffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffffc0",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "07ffffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffffe0",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "0fffffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffffff0",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "1fffffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffffff8",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "3fffffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffffffc",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "7fffffffffffffffffffffffffffffff", "fffffffffffffffffffffffffffffffe",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
  { "ffffffffffffffffffffffffffffffff", "ffffffffffffffffffffffffffffffff",  "ffffffffffffffff", "ffffffffffffffff",  "ffffffff", "ffffffff",  "ffff", "ffff",  "ff", "ff" },
};
