package javax.wadls;

import java.net.URI;
import java.util.*;
import org.w3c.dom.*;

import javax.wadls.Params;
import javax.wadls.extensions.ExtensionRegistry;
import javax.xml.namespace.*;

/**
 * This interface represents a WADLS Application
 *
 */
public interface Application extends java.io.Serializable
{

 	/**
  	 * Get all the Operations which has a modelReference with the specified namespace and concept.
  	 * @param namespace The namespace of the modelReference
  	 * @param concept The concept of the modelReference
  	 * @return All the Operations which has a modelReference with the specified namespace and concept.
  	 */
	
	
	List getMethodsByModelReference(URI namespace, String concept);

  	/**
  	 * Get all the XSD Elements which has a modelReference with the specified namespace and concept.
  	 * @param namespace The namespace of the modelReference
  	 * @param concept The concept of the modelReference
  	 * @return All the XSD Elements which has a modelReference with the specified namespace and concept.
  	 */
	List getXSDElementsByModelReference(URI namespace, String concept);
	
  	/**
  	 * Get all the XSD ComplexTypes which has a modelReference with the specified namespace and concept.
  	 * @param namespace The namespace of the modelReference
  	 * @param concept The concept of the modelReference
  	 * @return All the XSD ComplexTypes which has a modelReference with the specified namespace and concept.
  	 */
	List getXSDComplexTypeByModelReference(URI namespace, String concept);

  /**
   * Set the document base URI of this definition. Can be used to
   * represent the origin of the Definition, and can be exploited
   * when resolving relative URIs (e.g. in &lt;import&gt;s).
   *
   * @param documentBaseURI the document base URI of this definition
   */
  public void setDocumentBaseURI(String documentBaseURI);

  /**
   * Get the document base URI of this definition.
   *
   * @return the document base URI
   */
  public String getDocumentBaseURI();

  public String getResourcesPath();
  public void setResourcesPath(String path);
  /**
   * Set the name of this definition.
   *
   * @param name the desired name
   */
  public void setQName(QName name);

  /**
   * Get the name of this definition.
   *
   * @return the definition name
   */
  public QName getQName();

  /**
   * Set the target namespace in which WADL elements are defined.
   *
   * @param targetNamespace the target namespace
   */
  public void setTargetNamespace(String targetNamespace);

  /**
   * Get the target namespace in which the WADL elements
   * are defined.
   *
   * @return the target namespace
   */
  public String getTargetNamespace();

  /**
   * This is a way to add a namespace association to a definition.
   * It is similar to adding a namespace prefix declaration to the
   * top of a &lt;wsdl:definition&gt; element. This has nothing to do
   * with the &lt;wsdl:import&gt; element; there are separate methods for
   * dealing with information described by &lt;wsdl:import&gt; elements.
   *
   * @param prefix the prefix to use for this namespace (when
   * rendering this information as XML). Use null or an empty string
   * to describe the default namespace (i.e. xmlns="...").
   * @param namespaceURI the namespace URI to associate the prefix
   * with. If you use null, the namespace association will be removed.
   */
   public void addNamespace(String prefix, String namespaceURI);

   /**
    * Get the namespace URI associated with this prefix. Or null if
    * there is no namespace URI associated with this prefix. This is
    * unrelated to the &lt;wsdl:import&gt; element.
    *
    * @see #addNamespace(String, String)
    * @see #getPrefix(String)
    */
   public String getNamespace(String prefix);
   
   public void setGrammars(Grammars grammars);
   public Grammars getGrammars();

   /**
    * Get the types section.
    *
    * @return the types section
    */
   public Params getParams();
   public void setParams(Params params);
   /**
    * Get a prefix associated with this namespace URI. Or null if
    * there are no prefixes associated with this namespace URI. This is
    * unrelated to the &lt;wsdl:import&gt; element.
    *
    * @see #addNamespace(String, String)
    * @see #getNamespace(String)
    */
   public String getPrefix(String namespaceURI);

   /**
    * Get all namespace associations in this application. The keys are
    * the prefixes, and the namespace URIs are the values. This is
    * unrelated to the &lt;wsdl:import&gt; element.
    *
    * @see #addNamespace(String, String)
    */
   public Map getNamespaces();


  /**
   * Add an import to this WADL description.
   *
   * @param importDef the import to be added
   */
  public void addInclude(Include includeApp);

  /**
   * Get the list of imports for the specified namespaceURI.
   *
   * @param namespaceURI the namespaceURI associated with the
   * desired imports.
   * @return a list of the corresponding imports, or null if
   * there weren't any matching imports
   */
  public List getIncludes(String namespaceURI);

  /**
   * Get a map of lists containing all the imports defined here.
   * The map's keys are the namespaceURIs, and the map's values
   * are lists. There is one list for each namespaceURI for which
   * imports have been defined.
   */
  public Map getIncludes();

  
  /**
   * Add a portType to this WADL description.
   *
   * @param resource the resource to be added
   */
  public void addResource(Resource resource);

  /**
   * Get the specified resource. Also checks imported documents.
   *
   * @param name the name of the desired resource.
   * @return the corresponding resource, or null if there wasn't
   * any matching resource
   */
  public Resource getResource(QName name);

  /**
   * Remove the specified resource from this app.
   *
   * @param name the name of the resource to remove
   * @return the resource previously associated with this qname, if there
   * was one; may return null
   */
  public Resource removeResource(QName name);

  /**
   * Get all the resources defined here.
   */
  public Map getResources();

  /**
   * Set the documentation element for this document. This dependency
   * on org.w3c.dom.Element should eventually be removed when a more
   * appropriate way of representing this information is employed.
   *
   * @param docEl the documentation element
   */
  public void setDocumentationElement(Element docEl);

  /**
   * Get the documentation element. This dependency on org.w3c.dom.Element
   * should eventually be removed when a more appropriate way of
   * representing this information is employed.
   *
   * @return the documentation element
   */
  public Element getDocumentationElement();

 
  public ModelReference createModelReference();

  /**
   * Create a new precondition.
   *
   * @return the newly created precondition
   */
  public PreCondition createPreCondition();

  /**
   * Create a new effect.
   *
   * @return the newly created effect
   */
  public Effect createEffect();

  public Include createInclude();

  /**
   * Create a new input.
   *
   * @return the newly created input
   */
  public Request createRequest();

  
  /**
   * Create a new operation.
   *
   * @return the newly created operation
   */
  public Method createMethod();

  /**
   * Create a new output.
   *
   * @return the newly created output
   */
  public Response createResponse();



  public Resource createResource();

 
  public Params createParams();
  public Grammars createGrammars();
 }