/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package javax.wadls;

import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;


/**
 * This interface represents a WSDL operation.
 * It includes information on input, output and fault
 * messages associated with usage of the operation.
 *
 * @author Zixin Wu (wuzixin@uga.edu)
 * @author Paul Fremantle (pzf@us.ibm.com)
 * @author Nirmal Mukhi (nmukhi@us.ibm.com)
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public interface Method extends java.io.Serializable, ModelReferenceExtensible
{
	
	/**
	 * Set the precondition of this operation.
	 *
	 * @param preCondition the desired precondition
	 */
	public void setPreCondition(PreCondition preCondition);
	
	/**
	 * Get the precondition of this operation.
	 *
	 * @return the precondition
	 */
	public PreCondition getPreCondition();
	
	/**
	 * Set the effect of this operation.
	 *
	 * @param effect the desired effect
	 */
	public void setEffect(Effect effect);
	
	/**
	 * Get the effect of this operation.
	 *
	 * @return The effect
	 */
	public Effect getEffect();
	
	/**
	 * Set the name of this operation.
	 *
	 * @param name the desired name
	 */
	public void setName(String name);
	
	/**
	 * Get the name of this operation.
	 *
	 * @return the operation name
	 */
	public String getName();
	
	/**
	 * Set the input message specification for this operation.
	 *
	 * @param input the new input message
	 */
	public void setRequest(Request request);
	
	/**
	 * Get the input message specification for this operation.
	 *
	 * @return the input message
	 */
	public Request getRequest();
	
	/**
	 * Set the output message specification for this operation.
	 *
	 * @param output the new output message
	 */
	public void setResponse(Response response);
	
	/**
	 * Get the output message specification for this operation.
	 *
	 * @return the output message specification for the operation
	 */
	public Response getResponse();
	
	
	/**
	 * Set the style for this operation (request-response,
	 * one way, solicit-response or notification).
	 *
	 * @param style the new operation style

	/**
	 * Set the parameter ordering for a request-response,
	 * or solicit-response operation.
	 *
	 * @param parameterOrder a list of named parameters
	 * containing the part names to reflect the desired
	 * order of parameters for RPC-style operations
	 */
	public void setParameterOrdering(List parameterOrder);
	
	/**
	 * Get the parameter ordering for this operation.
	 *
	 * @return the parameter ordering, a list consisting
	 * of message part names
	 */
	public List getParameterOrdering();
	
	/**
	 * Set the documentation element for this document. This dependency
	 * on org.w3c.dom.Element should eventually be removed when a more
	 * appropriate way of representing this information is employed.
	 *
	 * @param docEl the documentation element
	 */
	public void setDocumentationElement(Element docEl);
	
	/**
	 * Get the documentation element. This dependency on org.w3c.dom.Element
	 * should eventually be removed when a more appropriate way of
	 * representing this information is employed.
	 *
	 * @return the documentation element
	 */
	public Element getDocumentationElement();
	
	public void setUndefined(boolean isUndefined);
	
	public boolean isUndefined();

}