/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorer;

public abstract class AbstractOWLOntologyStorer
implements OWLOntologyStorer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeOntology(OWLOntologyManager manager, OWLOntology ontology, IRI documentIRI, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException {
        try {
            if (!documentIRI.isAbsolute()) {
                throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
            }
            File tempFile = File.createTempFile("owlapi", ".owl");
            try {
                String line;
                OutputStream os;
                BufferedWriter tempWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
                this.storeOntology(manager, ontology, tempWriter, ontologyFormat);
                tempWriter.flush();
                tempWriter.close();
                if (documentIRI.getScheme().equals("file")) {
                    File file = new File(documentIRI.toURI());
                    file.getParentFile().mkdirs();
                    os = new FileOutputStream(file);
                } else {
                    URL url = documentIRI.toURI().toURL();
                    URLConnection conn = url.openConnection();
                    os = conn.getOutputStream();
                }
                BufferedReader br = new BufferedReader(new FileReader(tempFile));
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                while ((line = br.readLine()) != null) {
                    w.write(line);
                    w.write("\n");
                }
                br.close();
                w.close();
            }
            finally {
                tempFile.delete();
            }
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    public void storeOntology(OWLOntologyManager manager, OWLOntology ontology, OWLOntologyDocumentTarget target, OWLOntologyFormat format) throws OWLOntologyStorageException {
        if (target.isWriterAvailable()) {
            try {
                Writer writer = target.getWriter();
                this.storeOntology(manager, ontology, writer, format);
                writer.close();
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        } else if (target.isOutputStreamAvailable()) {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(target.getOutputStream()));
                this.storeOntology(manager, ontology, writer, format);
                writer.close();
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        } else if (target.isDocumentIRIAvailable()) {
            this.storeOntology(manager, ontology, target.getDocumentIRI(), format);
        } else {
            throw new OWLOntologyStorageException("Neither a Writer, OutputStream or Document IRI could be obtained to store the ontology");
        }
    }

    protected abstract void storeOntology(OWLOntologyManager var1, OWLOntology var2, Writer var3, OWLOntologyFormat var4) throws OWLOntologyStorageException;
}

