/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyDisjointWithHandler
extends TriplePredicateHandler {
    public TPPropertyDisjointWithHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isDataPropertyOnly(subject) || this.getConsumer().isDataPropertyOnly(object)) {
            this.addAxiom(this.getDataFactory().getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(this.translateDataProperty(subject), this.translateDataProperty(object)), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isObjectPropertyOnly(subject) || this.getConsumer().isObjectPropertyOnly(object)) {
            this.addAxiom(this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(this.translateObjectProperty(subject), this.translateObjectProperty(object)), this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return this.getConsumer().isObjectPropertyOnly(subject) && this.getConsumer().isObjectPropertyOnly(object) || this.getConsumer().isDataPropertyOnly(subject) && this.getConsumer().isDataPropertyOnly(object);
    }
}

