/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package javax.wadls.extensions;

import java.io.*;

import javax.wadls.*;
import javax.xml.namespace.*;

import edu.uga.cs.lsdis.meteors.wadls.util.xml.*;

/**
 * This class is used to serialize UnknownExtensibilityElement instances
 * into the PrintWriter.
 *
 * @see UnknownExtensibilityElement
 * @see UnknownExtensionDeserializer
 *
 * @author Matthew J. Duftler (duftler@us.ibm.com)
 */
public class UnknownExtensionSerializer implements ExtensionSerializer,
                                                   Serializable
{
  public static final long serialVersionUID = 1;

  public void marshall(Class parentType,
                       QName elementType,
                       ExtensibilityElement extension,
                       PrintWriter pw,
                       Application app,
                       ExtensionRegistry extReg)
                         throws WADLSException
  {
    UnknownExtensibilityElement unknownExt =
      (UnknownExtensibilityElement)extension;

    pw.print("    ");

    DOM2Writer.serializeAsXML(unknownExt.getElement(), pw);

    pw.println();
  }
}