/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPSubClassOfHandler
extends TriplePredicateHandler {
    public static int potentiallyConsumedTiples = 0;

    public TPSubClassOfHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        OWLClassExpression superClass;
        if (!this.getConsumer().isAnonymousNode(subject) && this.getConsumer().isAnonymousNode(object) && (superClass = this.getConsumer().getClassExpressionIfTranslated(object)) != null) {
            ++potentiallyConsumedTiples;
            return true;
        }
        this.getConsumer().addOWLClass(subject);
        this.getConsumer().addOWLClass(object);
        return !this.isSubjectOrObjectAnonymous(subject, object);
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        OWLClassExpression subClass = this.translateClassExpression(subject);
        OWLClassExpression supClass = this.translateClassExpression(object);
        Set<OWLAnnotation> pendingAnnotations = this.getConsumer().getPendingAnnotations();
        OWLSubClassOfAxiom ax = this.getDataFactory().getOWLSubClassOfAxiom(subClass, supClass, pendingAnnotations);
        this.addAxiom(ax);
        this.consumeTriple(subject, predicate, object);
    }
}

