/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import uk.ac.manchester.cs.owl.owlapi.FakeSet;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyImpl
extends OWLObjectImpl
implements OWLMutableOntology {
    private OWLOntologyManager manager;
    private OWLOntologyID ontologyID;
    private Set<OWLImportsDeclaration> importsDeclarations = CollectionFactory.createSet();
    private Set<OWLAnnotation> ontologyAnnotations = CollectionFactory.createSet();
    private Map<AxiomType, Set<OWLAxiom>> axiomsByType = CollectionFactory.createMap();
    private Map<OWLAxiom, Set<OWLAxiom>> logicalAxiom2AnnotatedAxiomMap = CollectionFactory.createMap();
    private Set<OWLClassAxiom> generalClassAxioms = CollectionFactory.createSet();
    private Set<OWLSubPropertyChainOfAxiom> propertyChainSubPropertyAxioms = CollectionFactory.createSet();
    private Map<OWLClass, Set<OWLAxiom>> owlClassReferences = CollectionFactory.createMap();
    private Map<OWLObjectProperty, Set<OWLAxiom>> owlObjectPropertyReferences = CollectionFactory.createMap();
    private Map<OWLDataProperty, Set<OWLAxiom>> owlDataPropertyReferences = CollectionFactory.createMap();
    private Map<OWLNamedIndividual, Set<OWLAxiom>> owlIndividualReferences = CollectionFactory.createMap();
    private Map<OWLAnonymousIndividual, Set<OWLAxiom>> owlAnonymousIndividualReferences = CollectionFactory.createMap();
    private Map<OWLDatatype, Set<OWLAxiom>> owlDatatypeReferences = CollectionFactory.createMap();
    private Map<OWLAnnotationProperty, Set<OWLAxiom>> owlAnnotationPropertyReferences = CollectionFactory.createMap();
    private Map<OWLClass, Set<OWLClassAxiom>> classAxiomsByClass = null;
    private Map<OWLClass, Set<OWLSubClassOfAxiom>> subClassAxiomsByLHS = null;
    private Map<OWLClass, Set<OWLSubClassOfAxiom>> subClassAxiomsByRHS = null;
    private Map<OWLClass, Set<OWLEquivalentClassesAxiom>> equivalentClassesAxiomsByClass = null;
    private Map<OWLClass, Set<OWLDisjointClassesAxiom>> disjointClassesAxiomsByClass = null;
    private Map<OWLClass, Set<OWLDisjointUnionAxiom>> disjointUnionAxiomsByClass = null;
    private Map<OWLClass, Set<OWLHasKeyAxiom>> hasKeyAxiomsByClass = null;
    private Map<OWLObjectPropertyExpression, Set<OWLSubObjectPropertyOfAxiom>> objectSubPropertyAxiomsByLHS = null;
    private Map<OWLObjectPropertyExpression, Set<OWLSubObjectPropertyOfAxiom>> objectSubPropertyAxiomsByRHS = null;
    private Map<OWLObjectPropertyExpression, Set<OWLEquivalentObjectPropertiesAxiom>> equivalentObjectPropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLDisjointObjectPropertiesAxiom>> disjointObjectPropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyDomainAxiom>> objectPropertyDomainAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyRangeAxiom>> objectPropertyRangeAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLFunctionalObjectPropertyAxiom>> functionalObjectPropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLInverseFunctionalObjectPropertyAxiom>> inverseFunctionalPropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLSymmetricObjectPropertyAxiom>> symmetricPropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLAsymmetricObjectPropertyAxiom>> asymmetricPropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLReflexiveObjectPropertyAxiom>> reflexivePropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLIrreflexiveObjectPropertyAxiom>> irreflexivePropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLTransitiveObjectPropertyAxiom>> transitivePropertyAxiomsByProperty = null;
    private Map<OWLObjectPropertyExpression, Set<OWLInverseObjectPropertiesAxiom>> inversePropertyAxiomsByProperty = null;
    private Map<OWLDataPropertyExpression, Set<OWLSubDataPropertyOfAxiom>> dataSubPropertyAxiomsByLHS = null;
    private Map<OWLDataPropertyExpression, Set<OWLSubDataPropertyOfAxiom>> dataSubPropertyAxiomsByRHS = null;
    private Map<OWLDataPropertyExpression, Set<OWLEquivalentDataPropertiesAxiom>> equivalentDataPropertyAxiomsByProperty = null;
    private Map<OWLDataPropertyExpression, Set<OWLDisjointDataPropertiesAxiom>> disjointDataPropertyAxiomsByProperty = null;
    private Map<OWLDataPropertyExpression, Set<OWLDataPropertyDomainAxiom>> dataPropertyDomainAxiomsByProperty = null;
    private Map<OWLDataPropertyExpression, Set<OWLDataPropertyRangeAxiom>> dataPropertyRangeAxiomsByProperty = null;
    private Map<OWLDataPropertyExpression, Set<OWLFunctionalDataPropertyAxiom>> functionalDataPropertyAxiomsByProperty = null;
    private Map<OWLIndividual, Set<OWLClassAssertionAxiom>> classAssertionAxiomsByIndividual = null;
    private Map<OWLClass, Set<OWLClassAssertionAxiom>> classAssertionAxiomsByClass = null;
    private Map<OWLIndividual, Set<OWLObjectPropertyAssertionAxiom>> objectPropertyAssertionsByIndividual = null;
    private Map<OWLIndividual, Set<OWLDataPropertyAssertionAxiom>> dataPropertyAssertionsByIndividual = null;
    private Map<OWLIndividual, Set<OWLNegativeObjectPropertyAssertionAxiom>> negativeObjectPropertyAssertionAxiomsByIndividual = null;
    private Map<OWLIndividual, Set<OWLNegativeDataPropertyAssertionAxiom>> negativeDataPropertyAssertionAxiomsByIndividual = null;
    private Map<OWLIndividual, Set<OWLDifferentIndividualsAxiom>> differentIndividualsAxiomsByIndividual = null;
    private Map<OWLIndividual, Set<OWLSameIndividualAxiom>> sameIndividualsAxiomsByIndividual = null;
    private Map<OWLAnnotationSubject, Set<OWLAnnotationAssertionAxiom>> annotationAssertionAxiomsBySubject = null;
    private OWLEntityReferenceChecker entityReferenceChecker = new OWLEntityReferenceChecker();
    private ChangeAxiomVisitor changeVisitor = new ChangeAxiomVisitor();
    private OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
    private OWLEntityCollector entityCollector = new OWLEntityCollector();
    private OWLNamedObjectReferenceAdder referenceAdder = new OWLNamedObjectReferenceAdder();
    private OWLNamedObjectReferenceRemover referenceRemover = new OWLNamedObjectReferenceRemover();

    public OWLOntologyImpl(OWLOntologyManager manager, OWLOntologyID ontologyID) {
        super(manager.getOWLDataFactory());
        this.manager = manager;
        this.ontologyID = ontologyID;
        if (this.owlClassReferences == null) {
            throw new OWLRuntimeException("Internal Error: Class reference index is null after init");
        }
        if (this.owlObjectPropertyReferences == null) {
            throw new OWLRuntimeException("Internal Error: Object property reference index is null after init");
        }
        if (this.owlDataPropertyReferences == null) {
            throw new OWLRuntimeException("Internal Error: Data property reference index is null after init");
        }
        if (this.owlIndividualReferences == null) {
            throw new OWLRuntimeException("Internal Error: Individual reference index is null after init");
        }
        if (this.owlAnnotationPropertyReferences == null) {
            throw new OWLRuntimeException("Internal Error: Annotation property reference index is null after init");
        }
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    @Override
    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    @Override
    public boolean isAnonymous() {
        return this.getOntologyID().isAnonymous();
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        if (object == this) {
            return 0;
        }
        OWLOntology other = (OWLOntology)object;
        return this.getOntologyID().compareTo(other.getOntologyID());
    }

    @Override
    public boolean isEmpty() {
        for (AxiomType type : this.axiomsByType.keySet()) {
            Set<OWLAxiom> axiomSet = this.axiomsByType.get(type);
            if (axiomSet == null || axiomSet.isEmpty()) continue;
            return false;
        }
        return this.ontologyAnnotations.isEmpty();
    }

    @Override
    public int getAxiomCount() {
        int count = 0;
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet = this.axiomsByType.get(type);
            if (axiomSet == null) continue;
            count += axiomSet.size();
        }
        return count;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> owlAxiomSet = this.axiomsByType.get(type);
            if (owlAxiomSet == null) continue;
            axioms.addAll(owlAxiomSet);
        }
        return axioms;
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return OWLOntologyImpl.getAxioms(axiomType, this.axiomsByType, false);
    }

    @Override
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxioms(axiomType);
        }
        HashSet<T> result = new HashSet<T>();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxioms(axiomType));
        }
        return result;
    }

    private <T extends OWLAxiom> Set<T> getAxiomsInternal(AxiomType<T> axiomType) {
        return OWLOntologyImpl.getAxioms(axiomType, this.axiomsByType, false);
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        Set<OWLAxiom> axioms = this.axiomsByType.get(axiomType);
        if (axioms == null) {
            return 0;
        }
        return axioms.size();
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxiomCount(axiomType);
        }
        int result = 0;
        for (OWLOntology ont : this.getImportsClosure()) {
            result += ont.getAxiomCount(axiomType);
        }
        return result;
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        HashSet<OWLLogicalAxiom> axioms = new HashSet<OWLLogicalAxiom>();
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.axiomsByType.get(type)) == null) continue;
            for (OWLAxiom ax : axiomSet) {
                axioms.add((OWLLogicalAxiom)ax);
            }
        }
        return axioms;
    }

    @Override
    public int getLogicalAxiomCount() {
        int count = 0;
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.axiomsByType.get(type)) == null) continue;
            count += axiomSet.size();
        }
        return count;
    }

    @Override
    public Set<OWLAnnotation> getAnnotations() {
        return OWLOntologyImpl.getReturnSet(this.ontologyAnnotations);
    }

    @Override
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        HashSet<OWLSubAnnotationPropertyOfAxiom> result = new HashSet<OWLSubAnnotationPropertyOfAxiom>();
        for (OWLSubAnnotationPropertyOfAxiom ax : this.getAxiomsInternal(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            if (!ax.getSubProperty().equals(subProperty)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        HashSet<OWLAnnotationPropertyDomainAxiom> result = new HashSet<OWLAnnotationPropertyDomainAxiom>();
        for (OWLAnnotationPropertyDomainAxiom ax : this.getAxiomsInternal(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            if (!ax.getProperty().equals(property)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        HashSet<OWLAnnotationPropertyRangeAxiom> result = new HashSet<OWLAnnotationPropertyRangeAxiom>();
        for (OWLAnnotationPropertyRangeAxiom ax : this.getAxiomsInternal(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            if (!ax.getProperty().equals(property)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        OWLDeclarationAxiom ax = this.getOWLDataFactory().getOWLDeclarationAxiom(entity);
        if (this.getAxiomsInternal(AxiomType.DECLARATION).contains(ax)) {
            return Collections.singleton(ax);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        axioms.addAll(this.getAnnotationAssertionAxiomsBySubject(subject));
        return axioms;
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(IRI subject) {
        return this.getAnnotationAssertionAxiomsBySubject(subject);
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return OWLOntologyImpl.getReturnSet(this.generalClassAxioms);
    }

    public Set<OWLSubPropertyChainOfAxiom> getPropertyChainSubPropertyAxioms() {
        return OWLOntologyImpl.getReturnSet(this.propertyChainSubPropertyAxioms);
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        Set<OWLAxiom> axioms = this.axiomsByType.get(axiom.getAxiomType());
        return axioms != null && axioms.contains(axiom);
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAxiom(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiom(axiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        if (axiom.isAnnotated()) {
            return this.logicalAxiom2AnnotatedAxiomMap.containsKey(axiom.getAxiomWithoutAnnotations());
        }
        return this.containsAxiom(axiom) || this.logicalAxiom2AnnotatedAxiomMap.containsKey(axiom);
    }

    @Override
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsAxiomIgnoreAnnotations(axiom);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsAxiomIgnoreAnnotations(axiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        Set<OWLAxiom> annotated;
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        if (this.containsAxiom(axiom)) {
            result.add(axiom);
        }
        if ((annotated = this.logicalAxiom2AnnotatedAxiomMap.get(axiom.getAxiomWithoutAnnotations())) != null) {
            result.addAll(annotated);
        }
        return result;
    }

    @Override
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAxiomsIgnoreAnnotations(axiom);
        }
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getAxiomsIgnoreAnnotations(axiom));
        }
        return result;
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI) {
        return this.owlClassReferences.containsKey(this.getOWLDataFactory().getOWLClass(owlClassIRI));
    }

    @Override
    public boolean containsClassInSignature(IRI owlClassIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsClassInSignature(owlClassIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI propIRI) {
        return this.owlObjectPropertyReferences.containsKey(this.getOWLDataFactory().getOWLObjectProperty(propIRI));
    }

    @Override
    public boolean containsObjectPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsObjectPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI propIRI) {
        return this.owlDataPropertyReferences.containsKey(this.getOWLDataFactory().getOWLDataProperty(propIRI));
    }

    @Override
    public boolean containsDataPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsDataPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI propIRI) {
        boolean b = this.owlAnnotationPropertyReferences.containsKey(this.getOWLDataFactory().getOWLAnnotationProperty(propIRI));
        if (b) {
            return true;
        }
        for (OWLAnnotation anno : this.ontologyAnnotations) {
            if (!anno.getProperty().getIRI().equals(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnnotationPropertyInSignature(IRI propIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsAnnotationPropertyInSignature(propIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsIndividualInSignature(IRI individualIRI) {
        return this.owlIndividualReferences.containsKey(this.getOWLDataFactory().getOWLNamedIndividual(individualIRI));
    }

    @Override
    public boolean containsIndividualInSignature(IRI individualIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsIndividualInSignature(individualIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsDatatypeInSignature(IRI datatypeIRI) {
        return this.owlDatatypeReferences.containsKey(this.getOWLDataFactory().getOWLDatatype(datatypeIRI));
    }

    @Override
    public boolean containsDatatypeInSignature(IRI datatypeIRI, boolean includeImportsClosure) {
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (!ont.containsDatatypeInSignature(datatypeIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>(6);
        if (this.containsClassInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLClass(iri));
        }
        if (this.containsObjectPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLObjectProperty(iri));
        }
        if (this.containsDataPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLDataProperty(iri));
        }
        if (this.containsIndividualInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLNamedIndividual(iri));
        }
        if (this.containsDatatypeInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLDatatype(iri));
        }
        if (this.containsAnnotationPropertyInSignature(iri)) {
            result.add(this.manager.getOWLDataFactory().getOWLAnnotationProperty(iri));
        }
        return result;
    }

    @Override
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getEntitiesInSignature(iri);
        }
        HashSet<OWLEntity> result = new HashSet<OWLEntity>(6);
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getEntitiesInSignature(iri));
        }
        return result;
    }

    public boolean containsReference(OWLClass owlClass) {
        return this.owlClassReferences.containsKey(owlClass);
    }

    public boolean containsReference(OWLObjectProperty prop) {
        return this.owlObjectPropertyReferences.containsKey(prop);
    }

    public boolean containsReference(OWLDataProperty prop) {
        return this.owlDataPropertyReferences.containsKey(prop);
    }

    public boolean containsReference(OWLNamedIndividual ind) {
        return this.owlIndividualReferences.containsKey(ind);
    }

    public boolean containsReference(OWLDatatype dt) {
        return this.owlDatatypeReferences.containsKey(dt);
    }

    public boolean containsReference(OWLAnnotationProperty property) {
        return this.owlAnnotationPropertyReferences.containsKey(property);
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity) {
        OWLDeclarationAxiom ax = this.getOWLDataFactory().getOWLDeclarationAxiom(owlEntity);
        return this.getAxiomsInternal(AxiomType.DECLARATION).contains(ax);
    }

    @Override
    public boolean isDeclared(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (this.isDeclared(owlEntity)) {
            return true;
        }
        for (OWLOntology ont : this.manager.getImportsClosure(this)) {
            if (ont.equals(this) || !ont.isDeclared(owlEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.entityReferenceChecker.containsReference(owlEntity);
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsEntityInSignature(owlEntity);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(owlEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI) {
        if (this.containsClassInSignature(entityIRI)) {
            return true;
        }
        if (this.containsObjectPropertyInSignature(entityIRI)) {
            return true;
        }
        if (this.containsDataPropertyInSignature(entityIRI)) {
            return true;
        }
        if (this.containsIndividualInSignature(entityIRI)) {
            return true;
        }
        if (this.containsDatatypeInSignature(entityIRI)) {
            return true;
        }
        return this.containsAnnotationPropertyInSignature(entityIRI);
    }

    @Override
    public boolean containsEntityInSignature(IRI entityIRI, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.containsEntityInSignature(entityIRI);
        }
        for (OWLOntology ont : this.getImportsClosure()) {
            if (!ont.containsEntityInSignature(entityIRI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity) {
        if (owlEntity instanceof OWLClass) {
            return OWLOntologyImpl.getAxioms(owlEntity.asOWLClass(), this.owlClassReferences, false);
        }
        if (owlEntity instanceof OWLObjectProperty) {
            return OWLOntologyImpl.getAxioms(owlEntity.asOWLObjectProperty(), this.owlObjectPropertyReferences, false);
        }
        if (owlEntity instanceof OWLDataProperty) {
            return OWLOntologyImpl.getAxioms(owlEntity.asOWLDataProperty(), this.owlDataPropertyReferences, false);
        }
        if (owlEntity instanceof OWLNamedIndividual) {
            return OWLOntologyImpl.getAxioms(owlEntity.asOWLNamedIndividual(), this.owlIndividualReferences, false);
        }
        if (owlEntity instanceof OWLDatatype) {
            return OWLOntologyImpl.getAxioms(owlEntity.asOWLDatatype(), this.owlDatatypeReferences, false);
        }
        if (owlEntity instanceof OWLAnnotationProperty) {
            return OWLOntologyImpl.getAxioms(owlEntity.asOWLAnnotationProperty(), this.owlAnnotationPropertyReferences, false);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLEntity owlEntity, boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getReferencingAxioms(owlEntity);
        }
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLOntology ont : this.getImportsClosure()) {
            result.addAll(ont.getReferencingAxioms(owlEntity));
        }
        return result;
    }

    @Override
    public Set<OWLAxiom> getReferencingAxioms(OWLAnonymousIndividual individual) {
        return OWLOntologyImpl.getAxioms(individual, this.owlAnonymousIndividualReferences, false);
    }

    @Override
    public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        if (this.classAxiomsByClass == null) {
            this.buildClassAxiomsByClassIndex();
        }
        return OWLOntologyImpl.getAxioms(cls, this.classAxiomsByClass);
    }

    @Override
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression prop) {
        HashSet<OWLObjectPropertyAxiom> result = new HashSet<OWLObjectPropertyAxiom>(50);
        result.addAll(this.getAsymmetricObjectPropertyAxioms(prop));
        result.addAll(this.getReflexiveObjectPropertyAxioms(prop));
        result.addAll(this.getSymmetricObjectPropertyAxioms(prop));
        result.addAll(this.getIrreflexiveObjectPropertyAxioms(prop));
        result.addAll(this.getTransitiveObjectPropertyAxioms(prop));
        result.addAll(this.getInverseFunctionalObjectPropertyAxioms(prop));
        result.addAll(this.getFunctionalObjectPropertyAxioms(prop));
        result.addAll(this.getInverseObjectPropertyAxioms(prop));
        result.addAll(this.getObjectPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentObjectPropertiesAxioms(prop));
        result.addAll(this.getDisjointObjectPropertiesAxioms(prop));
        result.addAll(this.getObjectPropertyRangeAxioms(prop));
        result.addAll(this.getObjectSubPropertyAxiomsForSubProperty(prop));
        return result;
    }

    @Override
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty prop) {
        HashSet<OWLAnnotationAxiom> result = new HashSet<OWLAnnotationAxiom>();
        for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : this.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            if (!oWLAnnotationAssertionAxiom.getProperty().equals(prop)) continue;
            result.add(oWLAnnotationAssertionAxiom);
        }
        for (OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom : this.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            if (!oWLSubAnnotationPropertyOfAxiom.getSubProperty().equals(prop)) continue;
            result.add(oWLSubAnnotationPropertyOfAxiom);
        }
        for (OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            if (!oWLAnnotationPropertyRangeAxiom.getProperty().equals(prop)) continue;
            result.add(oWLAnnotationPropertyRangeAxiom);
        }
        for (OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom : this.getAxioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            if (!oWLAnnotationPropertyDomainAxiom.getProperty().equals(prop)) continue;
            result.add(oWLAnnotationPropertyDomainAxiom);
        }
        return result;
    }

    @Override
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty prop) {
        Set<OWLDataPropertyAxiom> result = CollectionFactory.createSet();
        result.addAll(this.getDataPropertyDomainAxioms(prop));
        result.addAll(this.getEquivalentDataPropertiesAxioms(prop));
        result.addAll(this.getDisjointDataPropertiesAxioms(prop));
        result.addAll(this.getDataPropertyRangeAxioms(prop));
        result.addAll(this.getFunctionalDataPropertyAxioms(prop));
        result.addAll(this.getDataSubPropertyAxiomsForSubProperty(prop));
        return result;
    }

    @Override
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        HashSet<OWLIndividualAxiom> result = new HashSet<OWLIndividualAxiom>();
        result.addAll(this.getClassAssertionAxioms(individual));
        result.addAll(this.getObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getDataPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeObjectPropertyAssertionAxioms(individual));
        result.addAll(this.getNegativeDataPropertyAssertionAxioms(individual));
        result.addAll(this.getSameIndividualAxioms(individual));
        result.addAll(this.getDifferentIndividualAxioms(individual));
        return result;
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return this.getDatatypeDefinitions(datatype);
    }

    public Set<OWLNamedObject> getReferencedObjects() {
        HashSet<OWLNamedObject> result = new HashSet<OWLNamedObject>();
        result.addAll(this.owlClassReferences.keySet());
        for (OWLObjectProperty prop : this.owlObjectPropertyReferences.keySet()) {
            if (prop.isAnonymous()) continue;
            result.add(prop);
        }
        result.addAll(this.owlDataPropertyReferences.keySet());
        result.addAll(this.owlIndividualReferences.keySet());
        return result;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        entities.addAll(this.getClassesInSignature());
        entities.addAll(this.getObjectPropertiesInSignature());
        entities.addAll(this.getDataPropertiesInSignature());
        entities.addAll(this.getIndividualsInSignature());
        entities.addAll(this.getDatatypesInSignature());
        entities.addAll(this.getAnnotationPropertiesInSignature());
        return entities;
    }

    @Override
    public Set<OWLEntity> getSignature(boolean includeImportsClosure) {
        Set<OWLEntity> entities = this.getSignature();
        if (includeImportsClosure) {
            for (OWLOntology ont : this.getImportsClosure()) {
                if (ont.equals(this)) continue;
                entities.addAll(ont.getSignature());
            }
        }
        return entities;
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return OWLOntologyImpl.getReturnSet(this.owlClassReferences.keySet());
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return OWLOntologyImpl.getReturnSet(this.owlDataPropertyReferences.keySet());
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return OWLOntologyImpl.getReturnSet(this.owlObjectPropertyReferences.keySet());
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return OWLOntologyImpl.getReturnSet(this.owlIndividualReferences.keySet());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return OWLOntologyImpl.getReturnSet(this.owlDatatypeReferences.keySet());
    }

    @Override
    public Set<OWLClass> getClassesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getClassesInSignature();
        }
        HashSet<OWLClass> results = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getClassesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getObjectPropertiesInSignature();
        }
        HashSet<OWLObjectProperty> results = new HashSet<OWLObjectProperty>();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getObjectPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getDataPropertiesInSignature();
        }
        HashSet<OWLDataProperty> results = new HashSet<OWLDataProperty>();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDataPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getIndividualsInSignature();
        }
        HashSet<OWLNamedIndividual> results = new HashSet<OWLNamedIndividual>();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getIndividualsInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return OWLOntologyImpl.getReturnSet(this.owlAnonymousIndividualReferences.keySet());
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getDatatypesInSignature();
        }
        HashSet<OWLDatatype> results = new HashSet<OWLDatatype>();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getDatatypesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        HashSet<OWLAnnotationProperty> props = new HashSet<OWLAnnotationProperty>(this.owlAnnotationPropertyReferences.keySet());
        for (OWLAnnotation anno : this.ontologyAnnotations) {
            props.add(anno.getProperty());
        }
        return OWLOntologyImpl.getReturnSet(props);
    }

    public Set<OWLAnnotationProperty> getReferencedAnnotationProperties(boolean includeImportsClosure) {
        if (!includeImportsClosure) {
            return this.getAnnotationPropertiesInSignature();
        }
        HashSet<OWLAnnotationProperty> results = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ont : this.getImportsClosure()) {
            results.addAll(ont.getAnnotationPropertiesInSignature());
        }
        return results;
    }

    @Override
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return OWLOntologyImpl.getReturnSet(this.importsDeclarations);
    }

    @Override
    public Set<IRI> getDirectImportsDocuments() throws UnknownOWLOntologyException {
        HashSet<IRI> result = new HashSet<IRI>();
        for (OWLImportsDeclaration importsDeclaration : this.importsDeclarations) {
            result.add(importsDeclaration.getIRI());
        }
        return result;
    }

    @Override
    public Set<OWLOntology> getImports() throws UnknownOWLOntologyException {
        return this.manager.getImports(this);
    }

    @Override
    public Set<OWLOntology> getDirectImports() throws UnknownOWLOntologyException {
        return this.manager.getDirectImports(this);
    }

    @Override
    public Set<OWLOntology> getImportsClosure() throws UnknownOWLOntologyException {
        return this.getOWLOntologyManager().getImportsClosure(this);
    }

    @Override
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        HashSet<OWLDatatypeDefinitionAxiom> result = new HashSet<OWLDatatypeDefinitionAxiom>();
        Set<OWLDatatypeDefinitionAxiom> axioms = this.getAxiomsInternal(AxiomType.DATATYPE_DEFINITION);
        for (OWLDatatypeDefinitionAxiom ax : axioms) {
            if (!ax.getDatatype().equals(datatype)) continue;
            result.add(ax);
        }
        return result;
    }

    @Override
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass cls) {
        if (this.subClassAxiomsByLHS == null) {
            Map subClassAxiomsByLHS = CollectionFactory.createMap();
            for (OWLSubClassOfAxiom axiom : this.getAxiomsInternal(AxiomType.SUBCLASS_OF)) {
                if (axiom.getSubClass().isAnonymous()) continue;
                OWLOntologyImpl.addToIndexedSet(axiom.getSubClass().asOWLClass(), subClassAxiomsByLHS, axiom);
            }
            this.subClassAxiomsByLHS = subClassAxiomsByLHS;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.subClassAxiomsByLHS));
    }

    @Override
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass cls) {
        if (this.subClassAxiomsByRHS == null) {
            Map subClassAxiomsByRHS = CollectionFactory.createMap();
            for (OWLSubClassOfAxiom axiom : this.getAxiomsInternal(AxiomType.SUBCLASS_OF)) {
                if (axiom.getSuperClass().isAnonymous()) continue;
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperClass().asOWLClass(), subClassAxiomsByRHS, axiom);
            }
            this.subClassAxiomsByRHS = subClassAxiomsByRHS;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.subClassAxiomsByRHS));
    }

    @Override
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass cls) {
        if (this.equivalentClassesAxiomsByClass == null) {
            Map equivalentClassesAxiomsByClass = CollectionFactory.createMap();
            for (OWLEquivalentClassesAxiom axiom : this.getAxiomsInternal(AxiomType.EQUIVALENT_CLASSES)) {
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet(desc.asOWLClass(), equivalentClassesAxiomsByClass, axiom);
                }
            }
            this.equivalentClassesAxiomsByClass = equivalentClassesAxiomsByClass;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.equivalentClassesAxiomsByClass));
    }

    @Override
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass cls) {
        if (this.disjointClassesAxiomsByClass == null) {
            Map disjointClassesAxiomsByClass = CollectionFactory.createMap();
            for (OWLDisjointClassesAxiom axiom : this.getAxiomsInternal(AxiomType.DISJOINT_CLASSES)) {
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet(desc.asOWLClass(), disjointClassesAxiomsByClass, axiom);
                }
            }
            this.disjointClassesAxiomsByClass = disjointClassesAxiomsByClass;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.disjointClassesAxiomsByClass));
    }

    @Override
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        if (this.disjointUnionAxiomsByClass == null) {
            Map disjointUnionAxiomsByClass = CollectionFactory.createMap();
            for (OWLDisjointUnionAxiom axiom : this.getAxiomsInternal(AxiomType.DISJOINT_UNION)) {
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet(desc.asOWLClass(), disjointUnionAxiomsByClass, axiom);
                }
            }
            this.disjointUnionAxiomsByClass = disjointUnionAxiomsByClass;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(owlClass, this.disjointUnionAxiomsByClass));
    }

    @Override
    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass cls) {
        if (this.hasKeyAxiomsByClass == null) {
            Map hasKeyAxiomsByClass = CollectionFactory.createMap();
            for (OWLHasKeyAxiom axiom : this.getAxiomsInternal(AxiomType.HAS_KEY)) {
                if (axiom.getClassExpression().isAnonymous()) continue;
                OWLOntologyImpl.addToIndexedSet(axiom.getClassExpression().asOWLClass(), hasKeyAxiomsByClass, axiom);
            }
            this.hasKeyAxiomsByClass = hasKeyAxiomsByClass;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(cls, this.hasKeyAxiomsByClass));
    }

    @Override
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        if (this.objectSubPropertyAxiomsByLHS == null) {
            Map objectSubPropertyAxiomsByLHS = CollectionFactory.createMap();
            for (OWLSubObjectPropertyOfAxiom axiom : this.getAxiomsInternal(AxiomType.SUB_OBJECT_PROPERTY)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), objectSubPropertyAxiomsByLHS, axiom);
            }
            this.objectSubPropertyAxiomsByLHS = objectSubPropertyAxiomsByLHS;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectSubPropertyAxiomsByLHS));
    }

    @Override
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        if (this.objectSubPropertyAxiomsByRHS == null) {
            Map objectSubPropertyAxiomsByRHS = CollectionFactory.createMap();
            for (OWLSubObjectPropertyOfAxiom axiom : this.getAxiomsInternal(AxiomType.SUB_OBJECT_PROPERTY)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), objectSubPropertyAxiomsByRHS, axiom);
            }
            this.objectSubPropertyAxiomsByRHS = objectSubPropertyAxiomsByRHS;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectSubPropertyAxiomsByRHS));
    }

    @Override
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        if (this.objectPropertyDomainAxiomsByProperty == null) {
            Map objectPropertyDomainAxiomsByProperty = CollectionFactory.createMap();
            for (OWLObjectPropertyDomainAxiom axiom : this.getAxiomsInternal(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), objectPropertyDomainAxiomsByProperty, axiom);
            }
            this.objectPropertyDomainAxiomsByProperty = objectPropertyDomainAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectPropertyDomainAxiomsByProperty));
    }

    @Override
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        if (this.objectPropertyRangeAxiomsByProperty == null) {
            Map objectPropertyRangeAxiomsByProperty = CollectionFactory.createMap();
            for (OWLObjectPropertyRangeAxiom axiom : this.getAxiomsInternal(AxiomType.OBJECT_PROPERTY_RANGE)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), objectPropertyRangeAxiomsByProperty, axiom);
            }
            this.objectPropertyRangeAxiomsByProperty = objectPropertyRangeAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.objectPropertyRangeAxiomsByProperty));
    }

    @Override
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.inversePropertyAxiomsByProperty == null) {
            Map inversePropertyAxiomsByProperty = CollectionFactory.createMap();
            for (OWLInverseObjectPropertiesAxiom axiom : this.getAxiomsInternal(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, inversePropertyAxiomsByProperty, axiom);
                }
            }
            this.inversePropertyAxiomsByProperty = inversePropertyAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.inversePropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        if (this.equivalentObjectPropertyAxiomsByProperty == null) {
            Map equivalentObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
            for (OWLEquivalentObjectPropertiesAxiom axiom : this.getAxiomsInternal(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, equivalentObjectPropertyAxiomsByProperty, axiom);
                }
            }
            this.equivalentObjectPropertyAxiomsByProperty = equivalentObjectPropertyAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.equivalentObjectPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        if (this.disjointObjectPropertyAxiomsByProperty == null) {
            Map disjointObjectPropertyAxiomsByProperty = CollectionFactory.createMap();
            for (OWLDisjointObjectPropertiesAxiom axiom : this.getAxiomsInternal(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, disjointObjectPropertyAxiomsByProperty, axiom);
                }
            }
            this.disjointObjectPropertyAxiomsByProperty = disjointObjectPropertyAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.disjointObjectPropertyAxiomsByProperty));
    }

    private <T extends OWLObjectPropertyCharacteristicAxiom> Map<OWLObjectPropertyExpression, Set<T>> buildObjectPropertyCharacteristicsIndex(AxiomType<T> type) {
        Map<OWLObjectPropertyExpression, Set<T>> map = CollectionFactory.createMap();
        for (OWLObjectPropertyCharacteristicAxiom ax : this.getAxiomsInternal(type)) {
            OWLOntologyImpl.addToIndexedSet(ax.getProperty(), map, ax);
        }
        return map;
    }

    @Override
    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.functionalObjectPropertyAxiomsByProperty == null) {
            this.functionalObjectPropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.FUNCTIONAL_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.functionalObjectPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.inverseFunctionalPropertyAxiomsByProperty == null) {
            this.inverseFunctionalPropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getAxioms(property, this.inverseFunctionalPropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.symmetricPropertyAxiomsByProperty == null) {
            this.symmetricPropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.SYMMETRIC_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getAxioms(property, this.symmetricPropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.asymmetricPropertyAxiomsByProperty == null) {
            this.asymmetricPropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.ASYMMETRIC_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getAxioms(property, this.asymmetricPropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.reflexivePropertyAxiomsByProperty == null) {
            this.reflexivePropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.REFLEXIVE_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getAxioms(property, this.reflexivePropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.irreflexivePropertyAxiomsByProperty == null) {
            this.irreflexivePropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getAxioms(property, this.irreflexivePropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        if (this.transitivePropertyAxiomsByProperty == null) {
            this.transitivePropertyAxiomsByProperty = this.buildObjectPropertyCharacteristicsIndex(AxiomType.TRANSITIVE_OBJECT_PROPERTY);
        }
        return OWLOntologyImpl.getAxioms(property, this.transitivePropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        if (this.functionalDataPropertyAxiomsByProperty == null) {
            Map functionalDataPropertyAxiomsByProperty = CollectionFactory.createMap();
            for (OWLFunctionalDataPropertyAxiom ax : this.getAxiomsInternal(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
                OWLOntologyImpl.addToIndexedSet(ax.getProperty(), functionalDataPropertyAxiomsByProperty, ax);
            }
            this.functionalDataPropertyAxiomsByProperty = functionalDataPropertyAxiomsByProperty;
        }
        return OWLOntologyImpl.getAxioms(property, this.functionalDataPropertyAxiomsByProperty);
    }

    @Override
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty lhsProperty) {
        if (this.dataSubPropertyAxiomsByLHS == null) {
            Map dataSubPropertyAxiomsByLHS = CollectionFactory.createMap();
            for (OWLSubDataPropertyOfAxiom axiom : this.getAxiomsInternal(AxiomType.SUB_DATA_PROPERTY)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), dataSubPropertyAxiomsByLHS, axiom);
            }
            this.dataSubPropertyAxiomsByLHS = dataSubPropertyAxiomsByLHS;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(lhsProperty, this.dataSubPropertyAxiomsByLHS));
    }

    @Override
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        if (this.dataSubPropertyAxiomsByRHS == null) {
            Map dataSubPropertyAxiomsByRHS = CollectionFactory.createMap();
            for (OWLSubDataPropertyOfAxiom axiom : this.getAxiomsInternal(AxiomType.SUB_DATA_PROPERTY)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), dataSubPropertyAxiomsByRHS, axiom);
            }
            this.dataSubPropertyAxiomsByRHS = dataSubPropertyAxiomsByRHS;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.dataSubPropertyAxiomsByRHS));
    }

    @Override
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        if (this.dataPropertyDomainAxiomsByProperty == null) {
            Map dataPropertyDomainAxiomsByProperty = CollectionFactory.createMap();
            for (OWLDataPropertyDomainAxiom axiom : this.getAxiomsInternal(AxiomType.DATA_PROPERTY_DOMAIN)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), dataPropertyDomainAxiomsByProperty, axiom);
            }
            this.dataPropertyDomainAxiomsByProperty = dataPropertyDomainAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.dataPropertyDomainAxiomsByProperty));
    }

    @Override
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty property) {
        if (this.dataPropertyRangeAxiomsByProperty == null) {
            Map dataPropertyRangeAxiomsByProperty = CollectionFactory.createMap();
            for (OWLDataPropertyRangeAxiom axiom : this.getAxiomsInternal(AxiomType.DATA_PROPERTY_RANGE)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), dataPropertyRangeAxiomsByProperty, axiom);
            }
            this.dataPropertyRangeAxiomsByProperty = dataPropertyRangeAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.dataPropertyRangeAxiomsByProperty));
    }

    @Override
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty property) {
        if (this.equivalentDataPropertyAxiomsByProperty == null) {
            Map equivalentDataPropertyAxiomsByProperty = CollectionFactory.createMap();
            for (OWLEquivalentDataPropertiesAxiom axiom : this.getAxiomsInternal(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, equivalentDataPropertyAxiomsByProperty, axiom);
                }
            }
            this.equivalentDataPropertyAxiomsByProperty = equivalentDataPropertyAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.equivalentDataPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty property) {
        if (this.disjointDataPropertyAxiomsByProperty == null) {
            Map disjointDataPropertyAxiomsByProperty = CollectionFactory.createMap();
            for (OWLDisjointDataPropertiesAxiom axiom : this.getAxiomsInternal(AxiomType.DISJOINT_DATA_PROPERTIES)) {
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, disjointDataPropertyAxiomsByProperty, axiom);
                }
            }
            this.disjointDataPropertyAxiomsByProperty = disjointDataPropertyAxiomsByProperty;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(property, this.disjointDataPropertyAxiomsByProperty));
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        if (this.classAssertionAxiomsByIndividual == null) {
            Map classAssertionAxiomsByIndividual = CollectionFactory.createMap();
            for (OWLClassAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.CLASS_ASSERTION)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getIndividual(), classAssertionAxiomsByIndividual, axiom);
            }
            this.classAssertionAxiomsByIndividual = classAssertionAxiomsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.classAssertionAxiomsByIndividual));
    }

    @Override
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClass type) {
        if (this.classAssertionAxiomsByClass == null) {
            Map classAssertionAxiomsByClass = CollectionFactory.createMap();
            for (OWLClassAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.CLASS_ASSERTION)) {
                if (axiom.getClassExpression().isAnonymous()) continue;
                OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getClassExpression(), classAssertionAxiomsByClass, axiom);
            }
            this.classAssertionAxiomsByClass = classAssertionAxiomsByClass;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(type, this.classAssertionAxiomsByClass));
    }

    @Override
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.dataPropertyAssertionsByIndividual == null) {
            Map dataPropertyAssertionsByIndividual = CollectionFactory.createMap();
            for (OWLDataPropertyAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.DATA_PROPERTY_ASSERTION)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), dataPropertyAssertionsByIndividual, axiom);
            }
            this.dataPropertyAssertionsByIndividual = dataPropertyAssertionsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.dataPropertyAssertionsByIndividual));
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.objectPropertyAssertionsByIndividual == null) {
            Map objectPropertyAssertionsByIndividual = CollectionFactory.createMap();
            for (OWLObjectPropertyAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), objectPropertyAssertionsByIndividual, axiom);
            }
            this.objectPropertyAssertionsByIndividual = objectPropertyAssertionsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.objectPropertyAssertionsByIndividual));
    }

    @Override
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.negativeObjectPropertyAssertionAxiomsByIndividual == null) {
            Map negativeObjectPropertyAssertionAxiomsByIndividual = CollectionFactory.createMap();
            for (OWLNegativeObjectPropertyAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), negativeObjectPropertyAssertionAxiomsByIndividual, axiom);
            }
            this.negativeObjectPropertyAssertionAxiomsByIndividual = negativeObjectPropertyAssertionAxiomsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.negativeObjectPropertyAssertionAxiomsByIndividual));
    }

    @Override
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        if (this.negativeDataPropertyAssertionAxiomsByIndividual == null) {
            Map negativeDataPropertyAssertionAxiomsByIndividual = CollectionFactory.createMap();
            for (OWLNegativeDataPropertyAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), negativeDataPropertyAssertionAxiomsByIndividual, axiom);
            }
            this.negativeDataPropertyAssertionAxiomsByIndividual = negativeDataPropertyAssertionAxiomsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.negativeDataPropertyAssertionAxiomsByIndividual));
    }

    @Override
    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        if (this.sameIndividualsAxiomsByIndividual == null) {
            Map sameIndividualsAxiomsByIndividual = CollectionFactory.createMap();
            for (OWLSameIndividualAxiom axiom : this.getAxiomsInternal(AxiomType.SAME_INDIVIDUAL)) {
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.addToIndexedSet(ind, sameIndividualsAxiomsByIndividual, axiom);
                }
            }
            this.sameIndividualsAxiomsByIndividual = sameIndividualsAxiomsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.sameIndividualsAxiomsByIndividual));
    }

    @Override
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        if (this.differentIndividualsAxiomsByIndividual == null) {
            Map differentIndividualsAxiomsByIndividual = CollectionFactory.createMap();
            for (OWLDifferentIndividualsAxiom axiom : this.getAxiomsInternal(AxiomType.DIFFERENT_INDIVIDUALS)) {
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.addToIndexedSet(ind, differentIndividualsAxiomsByIndividual, axiom);
                }
            }
            this.differentIndividualsAxiomsByIndividual = differentIndividualsAxiomsByIndividual;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(individual, this.differentIndividualsAxiomsByIndividual));
    }

    @Override
    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>(2);
        this.changeFilter.reset();
        change.accept(this.changeFilter);
        List<OWLOntologyChange> applied = this.changeFilter.getAppliedChanges();
        if (applied.size() == 1) {
            appliedChanges.add(change);
        } else {
            appliedChanges.addAll(applied);
        }
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> applyChanges(List<OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange change : changes) {
            change.accept(this.changeFilter);
            appliedChanges.addAll(this.changeFilter.getAppliedChanges());
            this.changeFilter.reset();
        }
        return appliedChanges;
    }

    private void handleAxiomAdded(OWLAxiom axiom) {
        this.entityCollector.reset();
        axiom.accept(this.entityCollector);
        for (OWLEntity object : this.entityCollector.getObjects()) {
            this.referenceAdder.setAxiom(axiom);
            object.accept(this.referenceAdder);
        }
        for (OWLAnonymousIndividual ind : this.entityCollector.getAnonymousIndividuals()) {
            OWLOntologyImpl.addToIndexedSet(ind, this.owlAnonymousIndividualReferences, axiom);
        }
        if (axiom.isAnnotated()) {
            OWLOntologyImpl.addToIndexedSet(axiom.getAxiomWithoutAnnotations(), this.logicalAxiom2AnnotatedAxiomMap, axiom);
        }
    }

    private void handleAxiomRemoved(OWLAxiom axiom) {
        this.entityCollector.reset();
        axiom.accept(this.entityCollector);
        for (OWLEntity object : this.entityCollector.getObjects()) {
            this.referenceRemover.setAxiom(axiom);
            object.accept(this.referenceRemover);
        }
        for (OWLAnonymousIndividual ind : this.entityCollector.getAnonymousIndividuals()) {
            OWLOntologyImpl.removeAxiomFromSet(ind, this.owlAnonymousIndividualReferences, axiom, true);
        }
        if (axiom.isAnnotated()) {
            OWLOntologyImpl.removeAxiomFromSet(axiom.getAxiomWithoutAnnotations(), this.logicalAxiom2AnnotatedAxiomMap, axiom, true);
        }
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    private static <E> Set<E> getReturnSet(Set<E> set) {
        return new HashSet<E>(set);
    }

    private static <K extends OWLObject, V extends OWLAxiom> Set<V> getAxioms(K key, Map<K, Set<V>> map) {
        Set<V> axioms = map.get(key);
        if (axioms != null) {
            return Collections.unmodifiableSet(axioms);
        }
        return Collections.emptySet();
    }

    private static <K, V extends OWLAxiom> Set<V> getAxioms(K key, Map<K, Set<V>> map, boolean create) {
        Set<V> axioms = map.get(key);
        if (axioms == null) {
            axioms = new FakeSet<V>();
            if (create) {
                map.put(key, axioms);
            }
        }
        return axioms;
    }

    private static <K, V extends OWLAxiom> void addToIndexedSet(K key, Map<K, Set<V>> map, V axiom) {
        if (map == null) {
            return;
        }
        Set<V> axioms = map.get(key);
        if (axioms == null) {
            axioms = new FakeSet<V>();
            map.put(key, axioms);
        }
        axioms.add(axiom);
    }

    private static <K extends OWLObject, V extends OWLAxiom> void addAxiomToMap(K key, Map<K, V> map, V axiom) {
        if (map == null) {
            return;
        }
        map.put(key, axiom);
    }

    private static <K, V extends OWLAxiom> void removeAxiomFromSet(K key, Map<K, Set<V>> map, V axiom, boolean removeSetIfEmpty) {
        if (map == null) {
            return;
        }
        Set<V> axioms = map.get(key);
        if (axioms != null) {
            axioms.remove(axiom);
            if (removeSetIfEmpty && axioms.isEmpty()) {
                map.remove(key);
            }
        }
    }

    private static <K extends OWLAxiom> void addAxiomToSet(K axiom, Set<K> axioms) {
        if (axioms != null && axiom != null) {
            axioms.add(axiom);
        }
    }

    private static <K extends OWLAxiom> void removeAxiomFromSet(K axiom, Set<K> axioms) {
        if (axioms != null) {
            axioms.remove(axiom);
        }
    }

    private static <K extends OWLObject, V extends OWLAxiom> void removeAxiomFromMap(K key, Map<K, V> map) {
        if (map != null) {
            map.remove(key);
        }
    }

    private void buildClassAxiomsByClassIndex() {
        Map classAxiomsByClass = CollectionFactory.createMap();
        for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : this.getAxiomsInternal(AxiomType.EQUIVALENT_CLASSES)) {
            for (OWLClassExpression desc : oWLEquivalentClassesAxiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLOntologyImpl.addToIndexedSet((OWLClass)desc, classAxiomsByClass, oWLEquivalentClassesAxiom);
            }
        }
        for (OWLSubClassOfAxiom oWLSubClassOfAxiom : this.getAxiomsInternal(AxiomType.SUBCLASS_OF)) {
            if (oWLSubClassOfAxiom.getSubClass().isAnonymous()) continue;
            OWLOntologyImpl.addToIndexedSet((OWLClass)oWLSubClassOfAxiom.getSubClass(), classAxiomsByClass, oWLSubClassOfAxiom);
        }
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : this.getAxiomsInternal(AxiomType.DISJOINT_CLASSES)) {
            for (OWLClassExpression desc : oWLDisjointClassesAxiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLOntologyImpl.addToIndexedSet((OWLClass)desc, classAxiomsByClass, oWLDisjointClassesAxiom);
            }
        }
        for (OWLDisjointUnionAxiom oWLDisjointUnionAxiom : this.getAxiomsInternal(AxiomType.DISJOINT_UNION)) {
            OWLOntologyImpl.addToIndexedSet(oWLDisjointUnionAxiom.getOWLClass(), classAxiomsByClass, oWLDisjointUnionAxiom);
        }
        this.classAxiomsByClass = classAxiomsByClass;
    }

    private Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxiomsBySubject(OWLAnnotationSubject subject) {
        if (this.annotationAssertionAxiomsBySubject == null) {
            Map annotationAssertionAxiomsBySubject = CollectionFactory.createMap();
            for (OWLAnnotationAssertionAxiom axiom : this.getAxiomsInternal(AxiomType.ANNOTATION_ASSERTION)) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), annotationAssertionAxiomsBySubject, axiom);
            }
            this.annotationAssertionAxiomsBySubject = annotationAssertionAxiomsBySubject;
        }
        return OWLOntologyImpl.getReturnSet(OWLOntologyImpl.getAxioms(subject, this.annotationAssertionAxiomsBySubject, false));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLOntology)) {
            return false;
        }
        OWLOntology other = (OWLOntology)obj;
        return this.getOntologyID().equals(other.getOntologyID());
    }

    private class OWLEntityReferenceChecker
    implements OWLEntityVisitor {
        private boolean ref;

        private OWLEntityReferenceChecker() {
        }

        public boolean containsReference(OWLEntity entity) {
            this.ref = false;
            entity.accept(this);
            return this.ref;
        }

        public void visit(OWLClass cls) {
            this.ref = OWLOntologyImpl.this.containsReference(cls);
        }

        public void visit(OWLDatatype datatype) {
            this.ref = OWLOntologyImpl.this.containsReference(datatype);
        }

        public void visit(OWLNamedIndividual individual) {
            this.ref = OWLOntologyImpl.this.containsReference(individual);
        }

        public void visit(OWLDataProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLObjectProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }

        public void visit(OWLAnnotationProperty property) {
            this.ref = OWLOntologyImpl.this.containsReference(property);
        }
    }

    private class ChangeAxiomVisitor
    implements OWLAxiomVisitor {
        private boolean addAxiom = false;

        private ChangeAxiomVisitor() {
        }

        public void setAddAxiom(boolean addAxiom) {
            this.addAxiom = addAxiom;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUBCLASS_OF, OWLOntologyImpl.this.axiomsByType, axiom);
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLClass subClass = (OWLClass)axiom.getSubClass();
                    OWLOntologyImpl.addToIndexedSet(subClass, OWLOntologyImpl.this.subClassAxiomsByLHS, axiom);
                    OWLOntologyImpl.addToIndexedSet(subClass, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                } else {
                    OWLOntologyImpl.this.generalClassAxioms.add(axiom);
                }
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getSuperClass(), OWLOntologyImpl.this.subClassAxiomsByRHS, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUBCLASS_OF, OWLOntologyImpl.this.axiomsByType, axiom, true);
                if (!axiom.getSubClass().isAnonymous()) {
                    OWLClass subClass = (OWLClass)axiom.getSubClass();
                    OWLOntologyImpl.removeAxiomFromSet(subClass, OWLOntologyImpl.this.subClassAxiomsByLHS, axiom, true);
                    OWLOntologyImpl.removeAxiomFromSet(subClass, OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
                } else {
                    OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.generalClassAxioms);
                }
                if (!axiom.getSuperClass().isAnonymous()) {
                    OWLOntologyImpl.removeAxiomFromSet(axiom.getSuperClass().asOWLClass(), OWLOntologyImpl.this.subClassAxiomsByRHS, axiom, true);
                }
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.negativeObjectPropertyAssertionAxiomsByIndividual, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.negativeObjectPropertyAssertionAxiomsByIndividual, axiom, true);
            }
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.asymmetricPropertyAxiomsByProperty, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.asymmetricPropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.reflexivePropertyAxiomsByProperty, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.reflexivePropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLClass cls = (OWLClass)desc;
                    OWLOntologyImpl.addToIndexedSet(cls, OWLOntologyImpl.this.disjointClassesAxiomsByClass, axiom);
                    OWLOntologyImpl.addToIndexedSet(cls, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.add(axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLClass cls = (OWLClass)desc;
                    OWLOntologyImpl.removeAxiomFromSet(cls, OWLOntologyImpl.this.disjointClassesAxiomsByClass, axiom, true);
                    OWLOntologyImpl.removeAxiomFromSet(cls, OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.remove(axiom);
                }
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATA_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyDomainAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATA_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyDomainAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.OBJECT_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom);
                if (axiom.getProperty() instanceof OWLObjectProperty) {
                    OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyDomainAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom, true);
                if (axiom.getProperty() instanceof OWLObjectProperty) {
                    OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyDomainAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.equivalentObjectPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.equivalentObjectPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.INVERSE_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getFirstProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSecondProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.INVERSE_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getFirstProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom, false);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSecondProperty(), OWLOntologyImpl.this.inversePropertyAxiomsByProperty, axiom, false);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.negativeDataPropertyAssertionAxiomsByIndividual, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.negativeDataPropertyAssertionAxiomsByIndividual, axiom, true);
            }
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            if (this.addAxiom) {
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.addToIndexedSet(ind, OWLOntologyImpl.this.differentIndividualsAxiomsByIndividual, axiom);
                    OWLOntologyImpl.addToIndexedSet(AxiomType.DIFFERENT_INDIVIDUALS, OWLOntologyImpl.this.axiomsByType, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DIFFERENT_INDIVIDUALS, OWLOntologyImpl.this.axiomsByType, axiom, true);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.removeAxiomFromSet(ind, OWLOntologyImpl.this.differentIndividualsAxiomsByIndividual, axiom, true);
                }
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.disjointDataPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.disjointDataPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.disjointObjectPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.disjointObjectPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.OBJECT_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyRangeAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.objectPropertyRangeAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.objectPropertyAssertionsByIndividual, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.OBJECT_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.objectPropertyAssertionsByIndividual, axiom, true);
            }
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.functionalObjectPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.functionalObjectPropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUB_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByLHS, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByRHS, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUB_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByLHS, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSuperProperty(), OWLOntologyImpl.this.objectSubPropertyAxiomsByRHS, axiom, true);
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DISJOINT_UNION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.disjointUnionAxiomsByClass, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getOWLClass(), OWLOntologyImpl.this.classAxiomsByClass, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DISJOINT_UNION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getOWLClass(), OWLOntologyImpl.this.disjointUnionAxiomsByClass, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getOWLClass(), OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
            }
        }

        public void visit(OWLDeclarationAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DECLARATION, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DECLARATION, OWLOntologyImpl.this.axiomsByType, axiom, true);
            }
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.ANNOTATION_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.annotationAssertionAxiomsBySubject, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ANNOTATION_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.annotationAssertionAxiomsBySubject, axiom, true);
            }
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.ANNOTATION_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ANNOTATION_PROPERTY_DOMAIN, OWLOntologyImpl.this.axiomsByType, axiom, true);
            }
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.ANNOTATION_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.ANNOTATION_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom, true);
            }
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUB_ANNOTATION_PROPERTY_OF, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUB_ANNOTATION_PROPERTY_OF, OWLOntologyImpl.this.axiomsByType, axiom, true);
            }
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.HAS_KEY, OWLOntologyImpl.this.axiomsByType, axiom);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet(axiom.getClassExpression().asOWLClass(), OWLOntologyImpl.this.hasKeyAxiomsByClass, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.HAS_KEY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.removeAxiomFromSet(axiom.getClassExpression().asOWLClass(), OWLOntologyImpl.this.hasKeyAxiomsByClass, axiom, true);
                }
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.symmetricPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.symmetricPropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATA_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyRangeAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATA_PROPERTY_RANGE, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.dataPropertyRangeAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.FUNCTIONAL_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.functionalDataPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.FUNCTIONAL_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.functionalDataPropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.addToIndexedSet(prop, OWLOntologyImpl.this.equivalentDataPropertyAxiomsByProperty, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                    OWLOntologyImpl.removeAxiomFromSet(prop, OWLOntologyImpl.this.equivalentDataPropertyAxiomsByProperty, axiom, true);
                }
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(axiom.getIndividual(), OWLOntologyImpl.this.classAssertionAxiomsByIndividual, axiom);
                OWLOntologyImpl.addToIndexedSet(AxiomType.CLASS_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.addToIndexedSet((OWLClass)axiom.getClassExpression(), OWLOntologyImpl.this.classAssertionAxiomsByClass, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.CLASS_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getIndividual(), OWLOntologyImpl.this.classAssertionAxiomsByIndividual, axiom, true);
                if (!axiom.getClassExpression().isAnonymous()) {
                    OWLOntologyImpl.removeAxiomFromSet((OWLClass)axiom.getClassExpression(), OWLOntologyImpl.this.classAssertionAxiomsByClass, axiom, true);
                }
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.EQUIVALENT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.equivalentClassesAxiomsByClass, axiom);
                    OWLOntologyImpl.addToIndexedSet((OWLClass)desc, OWLOntologyImpl.this.classAxiomsByClass, axiom);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.add(axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.EQUIVALENT_CLASSES, OWLOntologyImpl.this.axiomsByType, axiom, true);
                boolean allAnon = true;
                for (OWLClassExpression desc : axiom.getClassExpressions()) {
                    if (desc.isAnonymous()) continue;
                    OWLOntologyImpl.removeAxiomFromSet((OWLClass)desc, OWLOntologyImpl.this.equivalentClassesAxiomsByClass, axiom, true);
                    OWLOntologyImpl.removeAxiomFromSet((OWLClass)desc, OWLOntologyImpl.this.classAxiomsByClass, axiom, true);
                    allAnon = false;
                }
                if (allAnon) {
                    OWLOntologyImpl.this.generalClassAxioms.remove(axiom);
                }
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubject(), OWLOntologyImpl.this.dataPropertyAssertionsByIndividual, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATA_PROPERTY_ASSERTION, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubject(), OWLOntologyImpl.this.dataPropertyAssertionsByIndividual, axiom, true);
            }
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.transitivePropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.transitivePropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.irreflexivePropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.irreflexivePropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUB_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSubProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByLHS, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getSuperProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByRHS, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUB_DATA_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSubProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByLHS, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getSuperProperty(), OWLOntologyImpl.this.dataSubPropertyAxiomsByRHS, axiom, true);
            }
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addToIndexedSet(axiom.getProperty(), OWLOntologyImpl.this.inverseFunctionalPropertyAxiomsByProperty, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom.getProperty(), OWLOntologyImpl.this.inverseFunctionalPropertyAxiomsByProperty, axiom, true);
            }
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SAME_INDIVIDUAL, OWLOntologyImpl.this.axiomsByType, axiom);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.addToIndexedSet(ind, OWLOntologyImpl.this.sameIndividualsAxiomsByIndividual, axiom);
                }
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SAME_INDIVIDUAL, OWLOntologyImpl.this.axiomsByType, axiom, true);
                for (OWLIndividual ind : axiom.getIndividuals()) {
                    OWLOntologyImpl.removeAxiomFromSet(ind, OWLOntologyImpl.this.sameIndividualsAxiomsByIndividual, axiom, true);
                }
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SUB_PROPERTY_CHAIN_OF, OWLOntologyImpl.this.axiomsByType, axiom);
                OWLOntologyImpl.addAxiomToSet(axiom, OWLOntologyImpl.this.propertyChainSubPropertyAxioms);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SUB_PROPERTY_CHAIN_OF, OWLOntologyImpl.this.axiomsByType, axiom, true);
                OWLOntologyImpl.removeAxiomFromSet(axiom, OWLOntologyImpl.this.propertyChainSubPropertyAxioms);
            }
        }

        public void visit(SWRLRule rule) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.SWRL_RULE, OWLOntologyImpl.this.axiomsByType, rule);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.SWRL_RULE, OWLOntologyImpl.this.axiomsByType, rule, true);
            }
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            if (this.addAxiom) {
                OWLOntologyImpl.addToIndexedSet(AxiomType.DATATYPE_DEFINITION, OWLOntologyImpl.this.axiomsByType, axiom);
            } else {
                OWLOntologyImpl.removeAxiomFromSet(AxiomType.DATATYPE_DEFINITION, OWLOntologyImpl.this.axiomsByType, axiom, true);
            }
        }
    }

    private class OWLNamedObjectReferenceRemover
    implements OWLEntityVisitor {
        private OWLAxiom axiom;

        private OWLNamedObjectReferenceRemover() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass owlClass) {
            OWLOntologyImpl.removeAxiomFromSet(owlClass, OWLOntologyImpl.this.owlClassReferences, this.axiom, true);
        }

        public void visit(OWLObjectProperty property) {
            OWLOntologyImpl.removeAxiomFromSet(property, OWLOntologyImpl.this.owlObjectPropertyReferences, this.axiom, true);
        }

        public void visit(OWLDataProperty property) {
            OWLOntologyImpl.removeAxiomFromSet(property, OWLOntologyImpl.this.owlDataPropertyReferences, this.axiom, true);
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            OWLOntologyImpl.removeAxiomFromSet(owlIndividual, OWLOntologyImpl.this.owlIndividualReferences, this.axiom, true);
        }

        public void visit(OWLAnnotationProperty property) {
            OWLOntologyImpl.removeAxiomFromSet(property, OWLOntologyImpl.this.owlAnnotationPropertyReferences, this.axiom, true);
        }

        public void visit(OWLDatatype datatype) {
            OWLOntologyImpl.removeAxiomFromSet(datatype, OWLOntologyImpl.this.owlDatatypeReferences, this.axiom, true);
        }
    }

    private class OWLNamedObjectReferenceAdder
    implements OWLEntityVisitor {
        private OWLAxiom axiom;

        private OWLNamedObjectReferenceAdder() {
        }

        public void setAxiom(OWLAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass owlClass) {
            OWLOntologyImpl.addToIndexedSet(owlClass, OWLOntologyImpl.this.owlClassReferences, this.axiom);
        }

        public void visit(OWLObjectProperty property) {
            OWLOntologyImpl.addToIndexedSet(property, OWLOntologyImpl.this.owlObjectPropertyReferences, this.axiom);
        }

        public void visit(OWLDataProperty property) {
            OWLOntologyImpl.addToIndexedSet(property, OWLOntologyImpl.this.owlDataPropertyReferences, this.axiom);
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            OWLOntologyImpl.addToIndexedSet(owlIndividual, OWLOntologyImpl.this.owlIndividualReferences, this.axiom);
        }

        public void visit(OWLAnnotationProperty property) {
            OWLOntologyImpl.addToIndexedSet(property, OWLOntologyImpl.this.owlAnnotationPropertyReferences, this.axiom);
        }

        public void visit(OWLDatatype datatype) {
            OWLOntologyImpl.addToIndexedSet(datatype, OWLOntologyImpl.this.owlDatatypeReferences, this.axiom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitor {
        private List<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();

        public List<OWLOntologyChange> getAppliedChanges() {
            return this.appliedChanges;
        }

        public void reset() {
            this.appliedChanges.clear();
        }

        @Override
        public void visit(RemoveAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (OWLOntologyImpl.this.containsAxiom(axiom)) {
                OWLOntologyImpl.this.changeVisitor.setAddAxiom(false);
                axiom.accept(OWLOntologyImpl.this.changeVisitor);
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.handleAxiomRemoved(axiom);
            }
        }

        @Override
        public void visit(SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals(OWLOntologyImpl.this.ontologyID)) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.ontologyID = id;
            }
        }

        @Override
        public void visit(AddAxiom change) {
            OWLAxiom axiom = change.getAxiom();
            if (!OWLOntologyImpl.this.containsAxiom(axiom)) {
                OWLOntologyImpl.this.changeVisitor.setAddAxiom(true);
                axiom.accept(OWLOntologyImpl.this.changeVisitor);
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.handleAxiomAdded(axiom);
            }
        }

        @Override
        public void visit(AddImport change) {
            if (!OWLOntologyImpl.this.importsDeclarations.contains(change.getImportDeclaration())) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.importsDeclarations.add(change.getImportDeclaration());
            }
        }

        @Override
        public void visit(RemoveImport change) {
            if (OWLOntologyImpl.this.importsDeclarations.contains(change.getImportDeclaration())) {
                this.appliedChanges.add(change);
                OWLOntologyImpl.this.importsDeclarations.remove(change.getImportDeclaration());
            }
        }

        @Override
        public void visit(AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ontologyAnnotations.add(change.getAnnotation())) {
                this.appliedChanges.add(change);
            }
        }

        @Override
        public void visit(RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ontologyAnnotations.remove(change.getAnnotation())) {
                this.appliedChanges.add(change);
            }
        }
    }
}

