/*
 * (c) Copyright IBM Corp 2001, 2005 
 */

package javax.wadls;

import java.io.*;

/**
 * This class represents a WADLS Exception
 * @author Zixin Wu
 *
 */
public class WADLSException extends Exception
{
  public static final long serialVersionUID = 1;

  public static final String INVALID_WADL = "INVALID_WADL";
  public static final String XSDPARSER_ERROR = "XSDPARSER_ERROR";
  public static final String OTHER_ERROR = "OTHER_ERROR";
  public static final String CONFIGURATION_ERROR = "CONFIGURATION_ERROR";
  public static final String UNBOUND_PREFIX = "UNBOUND_PREFIX";
  public static final String NO_PREFIX_SPECIFIED = "NO_PREFIX_SPECIFIED";
  public static final String PATH_ERROR = "PATH_ERROR";
  public static final String NOT_FOUND_ELE_BY_PATH = "NOT_FOUND_ELE_BY_PATH";
  public static final String NOT_FOUND_SCHEMA = "NOT_FOUND_SCHEMA";
  public static final String NOT_FOUND_ELE_IN_PART = "NOT_FOUND_ELE_IN_PART";

  private String faultCode = null;
  private Throwable targetThrowable = null;
  private String location = null;

  public WADLSException(String faultCode, String msg, Throwable t)
  {
    super(msg);
    setFaultCode(faultCode);
    setTargetException(t);
  }

  public WADLSException(String faultCode, String msg)
  {
    this(faultCode, msg, null);
  }

  public void setFaultCode(String faultCode)
  {
    this.faultCode = faultCode;
  }

  public String getFaultCode()
  {
    return faultCode;
  }

  public void setTargetException(Throwable targetThrowable)
  {
    this.targetThrowable = targetThrowable;
  }

  public Throwable getTargetException()
  {
    return targetThrowable;
  }

  /**
   * Set the location using an XPath expression. Used for error messages.
   *
   * @param location an XPath expression describing the location where
   * the exception occurred.
   */
  public void setLocation(String location)
  {
    this.location = location;
  }

  /**
   * Get the location, if one was set. Should be an XPath expression which
   * is used for error messages.
   */
  public String getLocation()
  {
    return location;
  }

  public String getMessage()
  {
    StringBuffer strBuf = new StringBuffer();

    strBuf.append("WADLSException");

    if (location != null)
    {
      try
      {
        strBuf.append(" (at " + location + ")");
      }
      catch (IllegalArgumentException e)
      {
      }
    }

    if (faultCode != null)
    {
      strBuf.append(": faultCode=" + faultCode);
    }

    String thisMsg = super.getMessage();
    String targetMsg = (targetThrowable != null)
                       ? targetThrowable.getMessage()
                       : null;

    if (thisMsg != null
        && (targetMsg == null || !thisMsg.equals(targetMsg)))
    {
      strBuf.append(": " + thisMsg);
    }

    if (targetMsg != null)
    {
      strBuf.append(": " + targetMsg);
    }

    return strBuf.toString();
  }

  public String toString()
  {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);

    pw.print(getMessage() + ": ");

    if (targetThrowable != null)
    {
      targetThrowable.printStackTrace(pw);
    }

    return sw.toString();
  }
}