/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLReasonerBase;
import org.semanticweb.owlapi.util.Version;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralReasoner
extends OWLReasonerBase {
    private ClassHierarchyInfo classHierarchyInfo = new ClassHierarchyInfo();
    private ObjectPropertyHierarchyInfo objectPropertyHierarchyInfo = new ObjectPropertyHierarchyInfo();
    private DataPropertyHierarchyInfo dataPropertyHierarchyInfo = new DataPropertyHierarchyInfo();
    private static final Version version = new Version(1, 0, 0, 0);
    private boolean interrupted = false;
    private ReasonerProgressMonitor pm;

    public StructuralReasoner(OWLOntology rootOntology, OWLReasonerConfiguration configuration, BufferingMode bufferingMode) {
        super(rootOntology, configuration, bufferingMode);
        this.pm = configuration.getProgressMonitor();
        if (this.pm == null) {
            this.pm = new NullReasonerProgressMonitor();
        }
    }

    @Override
    public String getReasonerName() {
        return "Structural Reasoner";
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        return FreshEntityPolicy.ALLOW;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return IndividualNodeSetPolicy.BY_NAME;
    }

    @Override
    public Version getReasonerVersion() {
        return version;
    }

    @Override
    protected void handleChanges(Set<OWLAxiom> addAxioms, Set<OWLAxiom> removeAxioms) {
        this.handleChanges(addAxioms, removeAxioms, this.classHierarchyInfo);
        this.handleChanges(addAxioms, removeAxioms, this.objectPropertyHierarchyInfo);
        this.handleChanges(addAxioms, removeAxioms, this.dataPropertyHierarchyInfo);
    }

    private <T extends OWLLogicalEntity> void handleChanges(Set<OWLAxiom> added, Set<OWLAxiom> removed, HierarchyInfo<T> hierarchyInfo) {
        Set<T> sig = hierarchyInfo.getEntitiesInSignature(added);
        sig.addAll(hierarchyInfo.getEntitiesInSignature(removed));
        hierarchyInfo.processChanges(sig);
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.classHierarchyInfo.prepare();
        this.objectPropertyHierarchyInfo.prepare();
        this.dataPropertyHierarchyInfo.prepare();
    }

    private void checkForInterrupt() {
        if (this.interrupted) {
            this.interrupted = false;
            throw new ReasonerInterruptedException();
        }
    }

    @Override
    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        return true;
    }

    @Override
    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return true;
    }

    @Override
    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        return OWLClassNode.getBottomNode();
    }

    @Override
    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.getRootOntology().containsAxiomIgnoreAnnotations(axiom, true);
    }

    @Override
    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.getRootOntology().containsAxiomIgnoreAnnotations(oWLAxiom, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return false;
    }

    @Override
    public Node<OWLClass> getTopClassNode() {
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLThing());
    }

    @Override
    public Node<OWLClass> getBottomClassNode() {
        return this.classHierarchyInfo.getEquivalents(this.getDataFactory().getOWLNothing());
    }

    @Override
    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            return this.classHierarchyInfo.getNodeHierarchyChildren(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    @Override
    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet ns = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            return this.classHierarchyInfo.getNodeHierarchyParents(ce.asOWLClass(), direct, ns);
        }
        return ns;
    }

    @Override
    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.classHierarchyInfo.getEquivalents(ce.asOWLClass());
    }

    @Override
    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce, boolean direct) {
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        if (!ce.isAnonymous()) {
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(ce.asOWLClass())) {
                    for (OWLClassExpression op : ax.getClassExpressions()) {
                        if (op.isAnonymous()) continue;
                        nodeSet.addNode(this.getEquivalentClasses(op));
                    }
                }
            }
        }
        return nodeSet;
    }

    @Override
    public Node<OWLObjectProperty> getTopObjectPropertyNode() {
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopObjectProperty());
    }

    @Override
    public Node<OWLObjectProperty> getBottomObjectPropertyNode() {
        return this.objectPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomObjectProperty());
    }

    @Override
    public NodeSet<OWLObjectProperty> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        if (!pe.isAnonymous()) {
            return this.objectPropertyHierarchyInfo.getNodeHierarchyChildren(pe.asOWLObjectProperty(), direct, ns);
        }
        return ns;
    }

    @Override
    public NodeSet<OWLObjectProperty> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNodeSet ns = new OWLObjectPropertyNodeSet();
        if (!pe.isAnonymous()) {
            return this.objectPropertyHierarchyInfo.getNodeHierarchyParents(pe.asOWLObjectProperty(), direct, ns);
        }
        return ns;
    }

    @Override
    public Node<OWLObjectProperty> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLObjectPropertyNode nd = new OWLObjectPropertyNode();
        if (!pe.isAnonymous()) {
            return this.objectPropertyHierarchyInfo.getEquivalents(pe.asOWLObjectProperty());
        }
        return nd;
    }

    @Override
    public NodeSet<OWLObjectProperty> getDisjointObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLObjectPropertyNodeSet();
    }

    @Override
    public Node<OWLObjectProperty> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<OWLObjectProperty> props = new HashSet<OWLObjectProperty>();
        Set<OWLObjectProperty> equivalentObjectProperties = this.getEquivalentObjectProperties(pe).getEntities();
        for (OWLObjectProperty property : equivalentObjectProperties) {
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLInverseObjectPropertiesAxiom axiom : ontology.getInverseObjectPropertyAxioms(property)) {
                    for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axiom.getPropertiesMinus(property)) {
                        OWLObjectPropertyExpression invPropSimp = oWLObjectPropertyExpression.getSimplified();
                        if (oWLObjectPropertyExpression.isAnonymous()) continue;
                        props.add(invPropSimp.asOWLObjectProperty());
                        props.addAll(this.getEquivalentObjectProperties(invPropSimp).getEntities());
                    }
                }
            }
        }
        return new OWLObjectPropertyNode((Set<OWLObjectProperty>)props);
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyDomainAxiom axiom : ontology.getObjectPropertyDomainAxioms(pe)) {
                result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
            }
            for (OWLObjectProperty invPe : this.getInverseObjectProperties(pe).getEntities()) {
                for (OWLObjectPropertyRangeAxiom axiom : ontology.getObjectPropertyRangeAxioms(invPe)) {
                    result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                    if (direct) continue;
                    result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyRangeAxiom axiom : ontology.getObjectPropertyRangeAxioms(pe)) {
                result.addNode(this.getEquivalentClasses((OWLClassExpression)axiom.getRange()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses((OWLClassExpression)axiom.getRange(), false).getNodes());
            }
            for (OWLObjectProperty invPe : this.getInverseObjectProperties(pe).getEntities()) {
                for (OWLObjectPropertyDomainAxiom axiom : ontology.getObjectPropertyDomainAxioms(invPe)) {
                    result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                    if (direct) continue;
                    result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLTopDataProperty());
    }

    @Override
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.dataPropertyHierarchyInfo.getEquivalents(this.getDataFactory().getOWLBottomDataProperty());
    }

    @Override
    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyChildren(pe, direct, ns);
    }

    @Override
    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet ns = new OWLDataPropertyNodeSet();
        return this.dataPropertyHierarchyInfo.getNodeHierarchyParents(pe, direct, ns);
    }

    @Override
    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return this.dataPropertyHierarchyInfo.getEquivalents(pe);
    }

    @Override
    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLDataPropertyNodeSet result = new OWLDataPropertyNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDisjointDataPropertiesAxiom axiom : ontology.getDisjointDataPropertiesAxioms(pe.asOWLDataProperty())) {
                for (OWLDataPropertyExpression dpe : axiom.getPropertiesMinus(pe)) {
                    if (dpe.isAnonymous()) continue;
                    result.addNode(this.dataPropertyHierarchyInfo.getEquivalents(dpe.asOWLDataProperty()));
                    if (direct) continue;
                    result.addAllNodes(this.getSubDataProperties(dpe.asOWLDataProperty(), false).getNodes());
                }
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDataPropertyDomainAxiom axiom : ontology.getDataPropertyDomainAxioms(pe)) {
                result.addNode(this.getEquivalentClasses(axiom.getDomain()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(axiom.getDomain(), false).getNodes());
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(ind)) {
                OWLClassExpression ce = axiom.getClassExpression();
                if (ce.isAnonymous()) continue;
                result.addNode(this.classHierarchyInfo.getEquivalents(ce.asOWLClass()));
                if (direct) continue;
                result.addAllNodes(this.getSuperClasses(ce, false).getNodes());
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        if (!ce.isAnonymous()) {
            OWLClass cls = ce.asOWLClass();
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLClassAssertionAxiom axiom : ontology.getClassAssertionAxioms(cls)) {
                    OWLIndividual individual = axiom.getIndividual();
                    if (individual.isAnonymous()) continue;
                    if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                        result.addNode(this.getSameIndividuals(individual.asOWLNamedIndividual()));
                    } else {
                        result.addNode(new OWLNamedIndividualNode(individual.asOWLNamedIndividual()));
                    }
                    if (direct) continue;
                    for (Node node : this.getSubClasses(ce, false)) {
                        for (OWLClass c : node.getEntities()) {
                            result.addAllNodes(this.getInstances(c, true).getNodes());
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        OWLNamedIndividualNodeSet result = new OWLNamedIndividualNodeSet();
        Node<OWLObjectProperty> inverses = this.getInverseObjectProperties(pe);
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLObjectPropertyAssertionAxiom axiom : ontology.getObjectPropertyAssertionAxioms(ind)) {
                OWLObjectPropertyExpression invPe;
                if (!((OWLIndividual)axiom.getObject()).isAnonymous() && ((OWLObjectPropertyExpression)axiom.getProperty()).getSimplified().equals(pe.getSimplified())) {
                    if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                        result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    } else {
                        result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    }
                }
                if (!((OWLIndividual)axiom.getObject()).equals(ind) || axiom.getSubject().isAnonymous() || (invPe = ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty().getSimplified()).isAnonymous() || !inverses.contains(invPe.asOWLObjectProperty())) continue;
                if (this.getIndividualNodeSetPolicy().equals((Object)IndividualNodeSetPolicy.BY_SAME_AS)) {
                    result.addNode(this.getSameIndividuals(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
                    continue;
                }
                result.addNode(new OWLNamedIndividualNode(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
            }
        }
        return result;
    }

    @Override
    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<OWLLiteral> literals = new HashSet<OWLLiteral>();
        Set<OWLDataProperty> superProperties = this.getSuperDataProperties(pe, false).getFlattened();
        superProperties.addAll(this.getEquivalentDataProperties(pe).getEntities());
        for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
            for (OWLDataPropertyAssertionAxiom axiom : ontology.getDataPropertyAssertionAxioms(ind)) {
                if (!superProperties.contains(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty())) continue;
                literals.add((OWLLiteral)axiom.getObject());
            }
        }
        return literals;
    }

    @Override
    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        HashSet<OWLNamedIndividual> inds = new HashSet<OWLNamedIndividual>();
        HashSet<OWLSameIndividualAxiom> processed = new HashSet<OWLSameIndividualAxiom>();
        ArrayList<OWLNamedIndividual> stack = new ArrayList<OWLNamedIndividual>();
        stack.add(ind);
        while (!stack.isEmpty()) {
            OWLNamedIndividual currentInd = (OWLNamedIndividual)stack.remove(0);
            for (OWLOntology ontology : this.getRootOntology().getImportsClosure()) {
                for (OWLSameIndividualAxiom axiom : ontology.getSameIndividualAxioms(currentInd)) {
                    if (processed.contains(axiom)) continue;
                    processed.add(axiom);
                    for (OWLIndividual i : axiom.getIndividuals()) {
                        OWLNamedIndividual namedInd;
                        if (i.isAnonymous() || inds.contains(namedInd = ind.asOWLNamedIndividual())) continue;
                        inds.add(namedInd);
                        stack.add(ind);
                    }
                }
            }
        }
        return new OWLNamedIndividualNode((Set<OWLNamedIndividual>)inds);
    }

    @Override
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        return new OWLNamedIndividualNodeSet();
    }

    protected OWLDataFactory getDataFactory() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
    }

    public void dumpClassHierarchy(boolean showBottomNode) {
        this.dumpClassHierarchy(OWLClassNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpClassHierarchy(Node<OWLClass> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        this.printIndent(level);
        OWLClass representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentClasses(representative));
        for (Node node : this.getSubClasses(representative, true)) {
            this.dumpClassHierarchy(node, level + 1, showBottomNode);
        }
    }

    public void dumpObjectPropertyHierarchy(boolean showBottomNode) {
        this.dumpObjectPropertyHierarchy(OWLObjectPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpObjectPropertyHierarchy(Node<OWLObjectProperty> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        this.printIndent(level);
        OWLObjectProperty representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentObjectProperties(representative));
        for (Node node : this.getSubObjectProperties(representative, true)) {
            this.dumpObjectPropertyHierarchy(node, level + 1, showBottomNode);
        }
    }

    public void dumpDataPropertyHierarchy(boolean showBottomNode) {
        this.dumpDataPropertyHierarchy(OWLDataPropertyNode.getTopNode(), 0, showBottomNode);
    }

    private void dumpDataPropertyHierarchy(Node<OWLDataProperty> cls, int level, boolean showBottomNode) {
        if (!showBottomNode && cls.isBottomNode()) {
            return;
        }
        this.printIndent(level);
        OWLDataProperty representative = cls.getRepresentativeElement();
        System.out.println(this.getEquivalentDataProperties(representative));
        for (Node node : this.getSubDataProperties(representative, true)) {
            this.dumpDataPropertyHierarchy(node, level + 1, showBottomNode);
        }
    }

    private void printIndent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawDataPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLDataProperty> {
        private RawDataPropertyHierarchyProvider() {
        }

        @Override
        public Collection<OWLDataProperty> getParents(OWLDataProperty child) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            for (OWLDataPropertyExpression prop : child.getSuperProperties(StructuralReasoner.this.getRootOntology().getImportsClosure())) {
                properties.add(prop.asOWLDataProperty());
            }
            return properties;
        }

        @Override
        public Collection<OWLDataProperty> getChildren(OWLDataProperty parent) {
            HashSet<OWLDataProperty> properties = new HashSet<OWLDataProperty>();
            for (OWLDataPropertyExpression prop : parent.getSubProperties(StructuralReasoner.this.getRootOntology().getImportsClosure())) {
                properties.add(prop.asOWLDataProperty());
            }
            return properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawObjectPropertyHierarchyProvider
    implements RawHierarchyProvider<OWLObjectProperty> {
        private RawObjectPropertyHierarchyProvider() {
        }

        @Override
        public Collection<OWLObjectProperty> getParents(OWLObjectProperty child) {
            HashSet<OWLObjectProperty> properties = new HashSet<OWLObjectProperty>();
            for (OWLObjectPropertyExpression prop : child.getSuperProperties(StructuralReasoner.this.getRootOntology().getImportsClosure())) {
                OWLObjectPropertyExpression simplifiedProp = prop.getSimplified();
                if (simplifiedProp.isAnonymous()) continue;
                properties.add(simplifiedProp.asOWLObjectProperty());
            }
            return properties;
        }

        @Override
        public Collection<OWLObjectProperty> getChildren(OWLObjectProperty parent) {
            HashSet<OWLObjectProperty> properties = new HashSet<OWLObjectProperty>();
            for (OWLObjectPropertyExpression prop : parent.getSubProperties(StructuralReasoner.this.getRootOntology().getImportsClosure())) {
                OWLObjectPropertyExpression simplifiedProp = prop.getSimplified();
                if (simplifiedProp.isAnonymous()) continue;
                properties.add(simplifiedProp.asOWLObjectProperty());
            }
            return properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RawClassHierarchyProvider
    implements RawHierarchyProvider<OWLClass> {
        private RawClassHierarchyProvider() {
        }

        @Override
        public Collection<OWLClass> getParents(OWLClass child) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : StructuralReasoner.this.getRootOntology().getImportsClosure()) {
                for (OWLSubClassOfAxiom oWLSubClassOfAxiom : ont.getSubClassAxiomsForSubClass(child)) {
                    OWLClassExpression superCls = oWLSubClassOfAxiom.getSuperClass();
                    if (!superCls.isAnonymous()) {
                        result.add(superCls.asOWLClass());
                        continue;
                    }
                    if (!(superCls instanceof OWLObjectIntersectionOf)) continue;
                    OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)superCls;
                    for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                        if (conjunct.isAnonymous()) continue;
                        result.add(conjunct.asOWLClass());
                    }
                }
                for (OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom : ont.getEquivalentClassesAxioms(child)) {
                    for (OWLClassExpression ce : oWLEquivalentClassesAxiom.getClassExpressionsMinus(child)) {
                        if (!ce.isAnonymous()) {
                            result.add(ce.asOWLClass());
                            continue;
                        }
                        if (!(ce instanceof OWLObjectIntersectionOf)) continue;
                        OWLObjectIntersectionOf intersectionOf = (OWLObjectIntersectionOf)ce;
                        for (OWLClassExpression conjunct : intersectionOf.asConjunctSet()) {
                            if (conjunct.isAnonymous()) continue;
                            result.add(conjunct.asOWLClass());
                        }
                    }
                }
            }
            return result;
        }

        @Override
        public Collection<OWLClass> getChildren(OWLClass parent) {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : StructuralReasoner.this.getRootOntology().getImportsClosure()) {
                for (OWLAxiom ax : ont.getReferencingAxioms(parent)) {
                    if (ax instanceof OWLSubClassOfAxiom) {
                        Set<OWLClassExpression> conjuncts;
                        OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                        if (sca.getSubClass().isAnonymous() || !(conjuncts = sca.getSuperClass().asConjunctSet()).contains(parent)) continue;
                        result.add(sca.getSubClass().asOWLClass());
                        continue;
                    }
                    if (!(ax instanceof OWLEquivalentClassesAxiom)) continue;
                    OWLEquivalentClassesAxiom eca = (OWLEquivalentClassesAxiom)ax;
                    for (OWLClassExpression ce : eca.getClassExpressions()) {
                        if (!ce.containsConjunct(parent)) continue;
                        for (OWLClassExpression sub : eca.getClassExpressions()) {
                            if (sub.isAnonymous() || sub.equals(ce)) continue;
                            result.add(sub.asOWLClass());
                        }
                    }
                }
            }
            if (result.isEmpty() && !parent.isOWLNothing()) {
                result.add(OWLDataFactoryImpl.getInstance().getOWLNothing());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface RawHierarchyProvider<T> {
        public Collection<T> getParents(T var1);

        public Collection<T> getChildren(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyHierarchyInfo
    extends HierarchyInfo<OWLDataProperty> {
        private DataPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "data property", (OWLLogicalEntity)StructuralReasoner.this.getDataFactory().getOWLTopDataProperty(), (OWLLogicalEntity)StructuralReasoner.this.getDataFactory().getOWLBottomDataProperty(), (RawHierarchyProvider)new RawDataPropertyHierarchyProvider());
        }

        @Override
        protected Set<OWLDataProperty> getEntitiesInSignature(OWLAxiom ax) {
            return ax.getDataPropertiesInSignature();
        }

        @Override
        protected Set<OWLDataProperty> getEntities(OWLOntology ont) {
            return ont.getDataPropertiesInSignature();
        }

        @Override
        protected DefaultNode<OWLDataProperty> createNode(Set<OWLDataProperty> cycle) {
            return new OWLDataPropertyNode(cycle);
        }

        @Override
        protected DefaultNode<OWLDataProperty> createNode() {
            return new OWLDataPropertyNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyHierarchyInfo
    extends HierarchyInfo<OWLObjectProperty> {
        private ObjectPropertyHierarchyInfo() {
            super(StructuralReasoner.this, "object property", (OWLLogicalEntity)StructuralReasoner.this.getDataFactory().getOWLTopObjectProperty(), (OWLLogicalEntity)StructuralReasoner.this.getDataFactory().getOWLBottomObjectProperty(), (RawHierarchyProvider)new RawObjectPropertyHierarchyProvider());
        }

        @Override
        protected Set<OWLObjectProperty> getEntitiesInSignature(OWLAxiom ax) {
            return ax.getObjectPropertiesInSignature();
        }

        @Override
        protected Set<OWLObjectProperty> getEntities(OWLOntology ont) {
            return ont.getObjectPropertiesInSignature();
        }

        @Override
        protected DefaultNode<OWLObjectProperty> createNode(Set<OWLObjectProperty> cycle) {
            return new OWLObjectPropertyNode(cycle);
        }

        @Override
        protected DefaultNode<OWLObjectProperty> createNode() {
            return new OWLObjectPropertyNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassHierarchyInfo
    extends HierarchyInfo<OWLClass> {
        private ClassHierarchyInfo() {
            super(StructuralReasoner.this, "class", (OWLLogicalEntity)StructuralReasoner.this.getDataFactory().getOWLThing(), (OWLLogicalEntity)StructuralReasoner.this.getDataFactory().getOWLNothing(), (RawHierarchyProvider)new RawClassHierarchyProvider());
        }

        @Override
        protected Set<OWLClass> getEntitiesInSignature(OWLAxiom ax) {
            return ax.getClassesInSignature();
        }

        @Override
        protected DefaultNode<OWLClass> createNode(Set<OWLClass> cycle) {
            return new OWLClassNode(cycle);
        }

        @Override
        protected Set<OWLClass> getEntities(OWLOntology ont) {
            return ont.getClassesInSignature();
        }

        @Override
        protected DefaultNode<OWLClass> createNode() {
            return new OWLClassNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HierarchyInfo<T extends OWLLogicalEntity> {
        private T topEntity;
        private T bottomEntity;
        private Set<T> roots = new HashSet<T>();
        private Map<T, Node<T>> cycles = new HashMap<T, Node<T>>();
        private RawHierarchyProvider<T> rawHierarchyProvider;
        private String name;
        private int classificationSize;
        final /* synthetic */ StructuralReasoner this$0;

        public HierarchyInfo(String name, T topEntity, T bottomEntity, RawHierarchyProvider<T> rawHierarchyProvider) {
            this.this$0 = var1_1;
            this.topEntity = topEntity;
            this.bottomEntity = bottomEntity;
            this.rawHierarchyProvider = rawHierarchyProvider;
            this.name = name;
        }

        protected abstract Set<T> getEntities(OWLOntology var1);

        protected abstract DefaultNode<T> createNode(Set<T> var1);

        protected abstract DefaultNode<T> createNode();

        protected abstract Set<T> getEntitiesInSignature(OWLAxiom var1);

        public Set<T> getEntitiesInSignature(Set<OWLAxiom> axioms) {
            HashSet<T> result = new HashSet<T>();
            for (OWLAxiom ax : axioms) {
                result.addAll(this.getEntitiesInSignature(ax));
            }
            return result;
        }

        private Collection<T> getChildrenInternal(T parent) {
            Collection<T> result = parent.isTopEntity() ? this.roots : this.rawHierarchyProvider.getChildren(parent);
            return result;
        }

        private Collection<T> getParentsInternal(T child, Map<T, Collection<T>> cache) {
            Collection<T> result = null;
            if (cache != null) {
                result = cache.get(child);
            }
            if (result == null) {
                result = this.rawHierarchyProvider.getParents(child);
                if (result.isEmpty()) {
                    this.roots.add(child);
                    result.add(this.topEntity);
                }
                if (cache != null) {
                    cache.put(child, result);
                }
            }
            return result;
        }

        public void prepare() {
            this.this$0.pm.reasonerTaskStarted("Computing " + this.name + " hierarchy");
            this.this$0.pm.reasonerTaskBusy();
            this.cycles.clear();
            HashMap cache = new HashMap();
            HashSet processed = new HashSet();
            HashSet<Set<T>> result = new HashSet<Set<T>>();
            HashSet<T> entities = new HashSet<T>();
            for (OWLOntology ont : this.this$0.getRootOntology().getImportsClosure()) {
                entities.addAll(this.getEntities(ont));
            }
            this.classificationSize = entities.size();
            this.this$0.pm.reasonerTaskProgressChanged(0, this.classificationSize);
            this.computeCyclesForSignature(entities, cache, processed, result);
            this.addCycles(result);
            this.this$0.pm.reasonerTaskStopped();
        }

        private void computeCyclesForSignature(Set<T> signature, Map<T, Collection<T>> cache, Set<T> processed, HashSet<Set<T>> result) {
            for (OWLLogicalEntity entity : signature) {
                if (processed.contains(entity)) continue;
                this.this$0.pm.reasonerTaskProgressChanged(processed.size(), signature.size());
                this.tarjan(entity, 0, new Stack(), new HashMap(), new HashMap(), result, processed, new HashSet(), cache);
                this.this$0.checkForInterrupt();
            }
        }

        private void addCycles(HashSet<Set<T>> forCycles) {
            for (Set<T> entity : forCycles) {
                DefaultNode<T> node = this.createNode(entity);
                for (OWLLogicalEntity cls : entity) {
                    this.cycles.put(cls, node);
                    HashSet<OWLLogicalEntity> rawSupers = new HashSet<OWLLogicalEntity>(this.rawHierarchyProvider.getParents(cls));
                    rawSupers.removeAll(node.getEntities());
                    if (!rawSupers.isEmpty()) continue;
                    this.roots.add(cls);
                }
            }
            this.roots.remove(this.topEntity);
        }

        public void processChanges(Set<T> signature) {
            this.removeCyclesForSignature(signature);
            HashSet<Set<T>> result = new HashSet<Set<T>>();
            this.computeCyclesForSignature(signature, new HashMap(), new HashSet(), result);
            this.addCycles(result);
        }

        private void removeCyclesForSignature(Set<T> signature) {
            for (OWLLogicalEntity entity : this.cycles.keySet()) {
                if (!signature.contains(entity)) continue;
                this.cycles.remove(entity);
            }
            for (OWLLogicalEntity entity : signature) {
                this.roots.remove(entity);
            }
        }

        public Set<Set<T>> computeCycleForEntites(Set<T> entities) {
            HashMap cache = new HashMap();
            HashSet processed = new HashSet();
            HashSet<Set<T>> result = new HashSet<Set<T>>();
            for (OWLLogicalEntity entity : entities) {
                this.tarjan(entity, 0, new Stack(), new HashMap(), new HashMap(), result, processed, new HashSet(), cache);
            }
            return result;
        }

        public void tarjan(T entity, int index, Stack<T> stack, Map<T, Integer> indexMap, Map<T, Integer> lowlinkMap, Set<Set<T>> result, Set<T> processed, Set<T> stackEntities, Map<T, Collection<T>> cache) {
            this.this$0.checkForInterrupt();
            processed.add(entity);
            this.this$0.pm.reasonerTaskProgressChanged(processed.size(), this.classificationSize);
            indexMap.put(entity, index);
            lowlinkMap.put(entity, index);
            ++index;
            stack.push(entity);
            stackEntities.add(entity);
            Collection<T> parents = this.getParentsInternal(entity, cache);
            if (parents.isEmpty()) {
                this.roots.add(entity);
            }
            for (OWLLogicalEntity superEntity : parents) {
                if (!indexMap.containsKey(superEntity)) {
                    this.tarjan(superEntity, index, stack, indexMap, lowlinkMap, result, processed, stackEntities, cache);
                    lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), lowlinkMap.get(superEntity)));
                    continue;
                }
                if (!stackEntities.contains(superEntity)) continue;
                lowlinkMap.put(entity, Math.min(lowlinkMap.get(entity), indexMap.get(superEntity)));
            }
            if (lowlinkMap.get(entity).equals(indexMap.get(entity))) {
                OWLLogicalEntity clsPrime;
                HashSet<OWLLogicalEntity> scc = new HashSet<OWLLogicalEntity>();
                do {
                    clsPrime = (OWLLogicalEntity)stack.pop();
                    stackEntities.remove(clsPrime);
                    scc.add(clsPrime);
                } while (!clsPrime.equals(entity));
                if (scc.size() > 1) {
                    result.add(scc);
                }
            }
        }

        public NodeSet<T> getNodeHierarchyChildren(T parent, boolean direct, DefaultNodeSet<T> ns) {
            if (parent.equals(this.bottomEntity)) {
                return ns;
            }
            Collection<T> children = this.getChildrenInternal(parent);
            Iterator<T> childIt = children.iterator();
            while (childIt.hasNext()) {
                OWLLogicalEntity child = (OWLLogicalEntity)childIt.next();
                Node<T> cycleNode = this.cycles.get(child);
                if (cycleNode != null) {
                    if (!cycleNode.contains(parent)) {
                        ns.addNode(cycleNode);
                    }
                    childIt.remove();
                } else {
                    ns.addEntity(child);
                }
                if (direct) continue;
                this.getNodeHierarchyChildren(child, direct, ns);
            }
            return ns;
        }

        public NodeSet<T> getNodeHierarchyParents(T child, boolean direct, DefaultNodeSet<T> ns) {
            if (child.equals(this.topEntity)) {
                return ns;
            }
            Collection<T> parents = this.getParentsInternal(child, null);
            Iterator<T> parIt = parents.iterator();
            while (parIt.hasNext()) {
                OWLLogicalEntity par = (OWLLogicalEntity)parIt.next();
                Node<T> cycleNode = this.cycles.get(par);
                if (cycleNode != null) {
                    ns.addNode(cycleNode);
                    parIt.remove();
                } else {
                    ns.addEntity(par);
                }
                if (direct) continue;
                this.getNodeHierarchyParents(par, direct, ns);
            }
            return ns;
        }

        public Node<T> getEquivalents(T element) {
            Node<T> node = this.cycles.get(element);
            if (node == null) {
                DefaultNode<T> newNode = this.createNode();
                newNode.add(element);
                node = newNode;
            }
            return node;
        }
    }
}

