/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SKOSVocabulary {
    BROADER("broader"),
    NARROWER("narrower"),
    RELATED("related"),
    HASTOPCONCEPT("hasTopConcept"),
    SEMANTICRELATION("semanticRelation"),
    CONCPET("Concept"),
    CONCEPTSCHEME("ConceptScheme"),
    TOPCONCEPT("TopConcept"),
    DOCUMENT("Document"),
    IMAGE("Image"),
    ORDEREDCOLLECTION("OrderedCollection"),
    COLLECTABLEPROPERTY("CollectableProperty"),
    RESOURCE("Resource"),
    PREFLABEL("prefLabel"),
    ALTLABEL("altLabel"),
    COMMENT("comment"),
    SCOPENOTE("scopeNote"),
    HIDDENLABEL("hiddenLabel"),
    EDITORIALNOTE("editorialNote"),
    DEFINITION("definition"),
    CHANGENOTE("changeNote");

    public static final Set<URI> ALL_URIS;
    private String localName;
    private IRI iri;

    private SKOSVocabulary(String localname) {
        this.localName = localname;
        this.iri = IRI.create(Namespaces.SKOS.toString() + localname);
    }

    public String getLocalName() {
        return this.localName;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public URI getURI() {
        return this.iri.toURI();
    }

    static {
        ALL_URIS = new HashSet<URI>();
        for (SKOSVocabulary v : SKOSVocabulary.values()) {
            ALL_URIS.add(v.getURI());
        }
    }
}

