import warnings

with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import platform

    from jpype._jpackage import JPackage
    from jpype import *
    import os.path
    import sys

class Document1(object):  

    def getWADLMethods(self, wadlUrl, outputFileUrl ):
        #javahome = os.environ.get('JAVA_HOME')
	#galaxyhome=os.environ.get('GALAXY_HOME')
        #classpath= galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/bin'
        #jarpath = galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/lib/'
        #machine = platform.machine()
        #if machine == 'x86_64' :
        #    startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'i686' :
        #    startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'sun4u' :
        #    startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #else :
        #    System.exit("Could not identify machine, please specify path to libjvm.so")
        pkg=JPackage('lsdis')
        urlToPass=java.net.URL(wadlUrl)
   
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
         
        urls = []
        methods = []

        WADLParserDriver=pkg.WADLParserDriver
        wPD=WADLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
    
        i=0
        for url in urls:
            outputfile.write(wadlUrl+"\t")
            outputfile.write(str(methods[i].getId())+"\t")
            outputfile.write(str(url)+"\n")
            i=i+1
     	    


    def getWSDLMethods(self, wsdlUrl, outputFileUrl ):
        javahome = os.environ.get('JAVA_HOME')
	galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceToolWorkflow/WodenWSDLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceToolWorkflow/WodenWSDLParser/lib/'
        machine = platform.machine()
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
    
        pkg=JPackage('lsdis')
       
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
        length=(len(sys.argv))
    
        urls = []
        methods = []

        WSDLParserDriver=pkg.WSDLParserDriver
        wPD=WSDLParserDriver()
        wPD.parse(wsdlUrl)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()
        
        i=0
        for url in urls:
           outputfile.write(wsdlUrl+"\t")
           outputfile.write(str(methods[i].getName().getLocalPart())+"\t")
           outputfile.write(str(url)+"\n")
           i=i+1
         
       
   
    
    def getSAWADLMethods(self, sawadlUrl, outputFileUrl ):
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/restclientSAWADL/lib/SAWADLParser/bin'

        machine = platform.machine()
        if machine == 'x86_64' :
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)
        elif machine == 'i686' :
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath)            
        else :
            System.exit("Could not identify machine, please specify path to libjvm.so")
    
        pkg=JPackage('edu.uga.cs.lsdis.meteors.wadls')
        

   
        outputfile=open(outputFileUrl,'w')
        outputfile.seek(0,0)
   
     
        urls = []
        methods = []

        SAWADLParserDriver=pkg.SAWADLParserDriver
        sawPD=SAWADLParserDriver()
        sawPD.parse(sawadlUrl)
        urls = sawPD.getUrl()
        methods = sawPD.getCompleteMethodList()
        
        i=0
        for url in urls:
           outputfile.write(sawadlUrl+"\t")
           outputfile.write(str(methods[i].getName())+"\t")    
           outputfile.write(str(url)+"\n")
           i=i+1
     
       
   
