import warnings

with warnings.catch_warnings():
    warnings.simplefilter("ignore")
    import platform

    from jpype._jpackage import JPackage
    from jpype import *
    import os.path
    import sys
    import string
    from edit_tool_conf1 import *
    
class ClientGenerator1(object):

    #instantiate a client for one time invocation of the selected method of a Web service
    def __init__(self,url,methodName,resourceName,fileName):
        self.methodName = methodName
        self.resourceName=resourceName
        self.Ofile = fileName
        #replace '__tilda__' with '~'        
        if(url.find('__tilda__')>-1):
            ulist = url.split('__tilda__')
	    url = '~'.join(ulist)
        self.url = url  

    #replace '**' with ' '        
    def formatString(self,string):
        l = string.split(' ')
        return '**'.join(l)

    #generates a xml describing a client capable of invoking a Web service described 
    #using a WADL document. Places this xml tool under ./clients/        
    def wadlClient(self):
        ##parse wadl 
        #javahome = os.environ.get('JAVA_HOME')
        #galaxyhome=os.environ.get('GALAXY_HOME')
        #classpath= galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/bin'
        #jarpath = galaxyhome + '/tools/WebServiceToolWorkflow/ParserForWADL/lib/'
        #machine = platform.machine()
    
        #if machine == 'x86_64' :
        #    print 'a'
        #    startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'i686' :
        #    print 'b'
        #    startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'sun4u' :
        #    startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #else :
        #    print 'c'
        #    System.exit("Could not identify machine, please specify path to libjvm.so")

        
        pkg=JPackage('lsdis')
        urlToPass=java.net.URL(self.url)
        wadlUrl = self.url
    
        webserviceId = self.methodName
        resUrl = self.resourceName
    
        urls = []
        methods = []
        params = []
        docs = []

        WADLParserDriver=pkg.WADLParserDriver
        wPD=WADLParserDriver()
        wPD.parse(urlToPass)
        urls = wPD.getUrl()
        methods = wPD.getCompleteMethodList()

        #write into the output file information about the method and Web service to be invoked.        
        f=open(self.Ofile,'w')
        f.write(wadlUrl)
        f.write('\n'+ resUrl)
        f.write('\n'+webserviceId)
        

        #get parameters for the selected method of the Web service
        i=0
        for method in methods:
            f.write('in for loop')
            x = str(method.getId())
            y = str(urls.get(i))
            if x == webserviceId :
                f.write('method matched')
                if y == resUrl : 
                    f.write('res matched')
                    params = method.getRequest().getParams()
                    break
            i=i+1    
     
        galaxyhome=os.environ.get('GALAXY_HOME')
       
        #./clients/ClientCount.xml keeps the count of the clients/tools currently registered in Galaxy for Web service invocation.
        #read the count and increment it. 
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow/clients/ClientCount.xml','r')
	clientCountFile.readline()
        clientCountStr = clientCountFile.read(1)
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow/clients/ClientCount.xml','w')

	clientCountFile.write('<count> \n')
	clientCountFile.write(str(clientCount))
	clientCountFile.write('</count> \n')
	
        #include the count in the tool's name and id to uniquely identify it.         
        clientName = 'client_'+ str(clientCount)

        #create a new xml file under ./clients/        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)

        #write the tool id, name and description        
        clientXml.write('<tool id="' + clientName+'1" name="' + self.methodName +'      ">\n')
        clientXml.write('  <description> Client for method: '+self.methodName+' , Web service: '+self.url+' </description>\n')

        #the one-time invocation tool/client for a REST Web service invokes ./clients/client_1.py to invoke the Web service
        #write the command tag to specify the arguments passed to this client_1.py
        clientXml.write('  <command interpreter="python">\n #if $cond_source.optional_param_source=="no" #client_1.py'+' $output ' +resUrl)
               
        j=0
        
        for param in params:
            if param.isRequired():
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $param' + str(j))            
                j=j+1
        clientXml.write(' #else #client_1.py'+' $output ' +resUrl)
        j=0
        for param in params:
            if param.isRequired():
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $param' + str(j))            
                j=j+1
                
        for param in params:
            if not param.isRequired():
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $cond_source.param' + str(j))            
                j=j+1
        clientXml.write(' #end if \n</command>\n')
        
	#start writing inputs
        clientXml.write('  <inputs>\n') 
        
        #create a param for each required parameter described in the WADL. Check if defaults and options are specified in the WADL
        j=0
        for param in params:
            if param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()
                if param.getOptions().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+pName+'" help="see tip below">\n' )    
                    for option in param.getOptions():
                        clientXml.write(' <option value="'+self.formatString(option.getName())+'" ')
                        if option.getName() == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option.getName()+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1

        #create a conditional param for each optional parameter described in the WADL.                     
        clientXml.write('\n <conditional name="cond_source"> \n <param name="optional_param_source" type="select" label="Show Additional Parameters">\n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param>\n')
        clientXml.write('<when value="no"> \n </when>')
        clientXml.write('<when value="yes"> \n')
        for param in params:
            if not param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()              
                if param.getOptions().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+pName+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+pName+'" help="see tip below">\n' )    
                    for option in param.getOptions():
                        clientXml.write(' <option value="'+self.formatString(option.getName())+'" ')
                        if option.getName() == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option.getName()+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1
        
                
        clientXml.write('</when>\n</conditional>')
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')

        #write information about each parameter in the help section        
        clientXml.write('  <help>\n')
        
        clientXml.write('Replace white space with ** in all parameter values\n')
                
        for param in params:
            if param.isRequired():
                pName = param.getName()
                for doc in param.getDocs():
                    if doc.getTitle()=="prompt" or doc.getTitle()=="Prompt" or doc.getTitle()=="PROMPT":
		        pName = doc.getInnerText()            
                clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ pName +' type is ' + param.getType()+'\n')       
        
        clientXml.write('  </help>\n</tool>')
        
        #adds the newly created tool to tool_conf.xml in Galaxy under the 'Web Service Tools' section.        
        editor = editToolConfig1()
        editor.addTool(clientName)
        
        ##later add help feature
        
    def sawadlClient(self):
        ##parse sawadl 
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceTool/lib/SAWADLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceTool/lib/'
        machine = platform.machine()
    
        #if machine == 'x86_64' :
        #    print 'a'
        #    startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'i686' :
        #    print 'b'
        #    startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #elif machine == 'sun4u' :
        #    startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        #else :
        #    print 'c'
        #    System.exit("Could not identify machine, please specify path to libjvm.so")

        
        pkg=JPackage('edu.uga.cs.lsdis.meteors.wadls')
        pkgModel =JPackage('org.semanticweb.owlapi.model')
        pkgApiBinding =JPackage('org.semanticweb.owlapi.apibinding')
        pkgVocab = JPackage('org.semanticweb.owlapi.vocab')
    
        DOCUMENT_IRI = "http://cs.uga.edu/~ganjoo/galaxy/EDAM.owl"
    
        sawadlUrl = self.url
    
        webserviceId = self.methodName
        resUrl = self.resourceName
    
        urls = []
        methods = []
        params = []
        annotationSet = []

        SAWADLParserDriver=pkg.SAWADLParserDriver
        sawPD=SAWADLParserDriver()
        sawPD.parse(sawadlUrl)
        urls = sawPD.getUrl()
        methods = sawPD.getCompleteMethodList()

        IRI = pkgModel.IRI
        OWLRDFVocabulary = pkgVocab.OWLRDFVocabulary
        OWLManager = pkgApiBinding.OWLManager
        OWLLiteral = pkgModel.OWLLiteral
        owlOntManager = OWLManager.createOWLOntologyManager()
        ontology = owlOntManager.loadOntologyFromOntologyDocument(IRI.create(DOCUMENT_IRI))
        dataFactory = owlOntManager.getOWLDataFactory()
        propertyComment = dataFactory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_COMMENT.getIRI())
        
        f=open(self.Ofile,'w')
        f.write(sawadlUrl)
        f.write('\n'+ resUrl)
        f.write('\n'+webserviceId)
        

        i=0
        for method in methods:
            x = str(method.getName())
            y = str(urls.get(i))
            if x == webserviceId :
                f.write('method matched')
                if y == resUrl : 
                    f.write('res matched')
                    params = method.getRequest().getParamList()
                    break
            i=i+1    
        

        
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow/clients/ClientCount.xml','r')
	clientCountFile.readline()
        clientCountStr = clientCountFile.read(1)
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceToolWorkflow/clients/ClientCount.xml','w')
	clientCountFile.write('<count> \n')
	clientCountFile.write(str(clientCount))
	clientCountFile.write('</count> \n')
	
        clientName = 'client_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceToolWorkflow/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'1" name="' + self.methodName +'">\n')
        clientXml.write('  <description> Client for method: '+self.methodName+' , Web service: '+self.url+' </description>\n')

  
        clientXml.write('  <command interpreter="python">\n  #if $cond_source.optional_param_source=="no" #client_1.py'+' $output ' +resUrl)
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
               
        
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('  '+self.formatString(param.getName())+'\n')
                clientXml.write('  $param' + str(j)+'\n')            
                j=j+1
        
        clientXml.write(' #else #client_1.py'+' $output ' +resUrl)
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $param' + str(j))            
                j=j+1
                
        for param in params:
            if not param.getRequired()=='true' and not param.getRequired()=='True' and not param.getRequired()=='TRUE':
                clientXml.write(' '+self.formatString(param.getName()))
                clientXml.write(' $cond_source.param' + str(j))            
                j=j+1               
                 
        clientXml.write('#end if \n </command>\n')
        
        ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        clientXml.write('  <inputs>\n') 
        
        j=0
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                f.write('\n '+ param.getName() + ' options: '+str(param.getOptionvalue().size()))
                if param.getOptionvalue().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+param.getName()+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+param.getName()+'" help="see tip below">\n' )    
                    for option in param.getOptionvalue():
                        clientXml.write(' <option value="'+self.formatString(option)+'" ')
                        if option == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1

                    
        clientXml.write('\n <conditional name="cond_source"> \n <param name="optional_param_source" type="select" label="Display Additional Parameters">\n <option value="no" selected="true">no</option> \n <option value="yes">yes</option> \n </param>\n')
        clientXml.write('<when value="no"> \n </when>')
        clientXml.write('<when value="yes"> \n')
        
        for param in params:
            if not param.getRequired()=='true' and not param.getRequired()=='True' and not param.getRequired()=='TRUE':
                f.write('\n '+ param.getName() + ' options: '+str(param.getOptionvalue().size()))
                if param.getOptionvalue().size()==0:
                    clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
                    if not param.getDefault1() == None:
                        clientXml.write('value="'+param.getDefault1()+'"  ')
                    clientXml.write('type="text" label="Enter '+param.getName()+'" help="see tip below" />\n')
                    j=j+1
                else:
                    clientXml.write('<param name="param'+str(j)+'" type="select" label="Select '+param.getName()+'" help="see tip below">\n' )    
                    for option in param.getOptionvalue():
                        clientXml.write(' <option value="'+self.formatString(option)+'" ')
                        if option == param.getDefault1():
                            clientXml.write('selected="true"')
                        clientXml.write('>'+option+'</option>\n ')    
                    clientXml.write('    </param> \n')
                    j=j+1
        
        clientXml.write('</when>\n</conditional>\n')        

        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        for param in params:
            if param.getRequired()=='true' or param.getRequired()=='True' or param.getRequired()=='TRUE':
                clientXml.write('\n.. class:: infomark\n\n**TIP:** About '+ param.getName() +': type is ' + param.getType())       
                
                modelRef = sawPD.getCompleteModelReference(param)
                if not modelRef is None:
                    paramClass = dataFactory.getOWLClass(IRI.create(modelRef));
                    annotationSet = paramClass.getAnnotations(ontology,propertyComment)
                    for annotation in annotationSet:
     		        if isinstance(annotation.getValue(),OWLLiteral):
     		            val = annotation.getValue()
     		            if val.isOWLStringLiteral() and not val.isOWLTypedLiteral():
     		                print 'val.getLiteral()=' + val.getLiteral()
                                clientXml.write(', description from ontology is "' + val.getLiteral()+'"')  
                                break
                    clientXml.write('\n')            
        clientXml.write('  </help>\n</tool>')
        editor = editToolConfig1()
        editor.addTool(clientName)
        
        ##later add help feature 
        
    def wsdlClient(self):
        ##parse wadl 
        javahome = os.environ.get('JAVA_HOME')
        galaxyhome=os.environ.get('GALAXY_HOME')
        classpath= galaxyhome + '/tools/WebServiceTool/WodenWSDLParser/bin'
        jarpath = galaxyhome + '/tools/WebServiceTool/WodenWSDLParser/lib/'
        machine = platform.machine()
    
        if machine == 'x86_64' :
            print 'a'
            startJVM("%s/jre/lib/amd64/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'i686' :
            print 'b'
            startJVM("%s/jre/lib/i386/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        elif machine == 'sun4u' :
            startJVM("%s/jre/lib/sparc/server/libjvm.so" % javahome,"-ea", "-Djava.class.path=%s" % classpath,"-Djava.ext.dirs=%s" % jarpath)
        else :
            print 'c'
            System.exit("Could not identify machine, please specify path to libjvm.so")

        
        pkg=JPackage('lsdis')
        wsdlUrl = self.url
    
        webserviceId = self.methodName
        resUrl = self.resourceName
    
        urls = []
        methods = []
        params = []
        paramTypes = []
        
        WSDLParserDriver =pkg.WSDLParserDriver
        wPD=WSDLParserDriver()
        wPD.parse(wsdlUrl)
        methods = wPD.getCompleteMethodList()
        urls = wPD.getUrl()
                
        f=open(self.Ofile,'w')
        f.write(wsdlUrl)
        f.write('\n'+ resUrl)
        f.write('\n'+webserviceId)
        

        i=0
        for method in methods:
            x = str(method.getName().getLocalPart())
            if x == webserviceId :
                wPD.getParameters(x)
                f.write('method matched')
                paramTypes = wPD.getParamTypeList()
                params = wPD.getParamList()
                break
            i=i+1    
        

        
        
        ##generate client's xml
        galaxyhome=os.environ.get('GALAXY_HOME')
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceTool/clients/ClientCount.xml','r')
	clientCountFile.readline()
        clientCountStr = clientCountFile.read(1)
        clientCount=string.atoi(clientCountStr)
        clientCount=clientCount+1
        clientCountFile.close()
        
        clientCountFile=open(galaxyhome+'/tools/WebServiceTool/clients/ClientCount.xml','w')
	clientCountFile.write('<count> \n')
	clientCountFile.write(str(clientCount))
	clientCountFile.write('</count> \n')
	
        
        
        
        clientName = 'client_'+ str(clientCount)
        
        clientXml=open(galaxyhome+'/tools/WebServiceTool/clients/'+clientName+'.xml','w')
        clientXml.seek(0,0)
        
        clientXml.write('<tool id="' + clientName+'" name="' + self.methodName +'">\n')
        clientXml.write('  <description> Client for method: '+self.methodName+' , Web service: '+self.url+' </description>\n')

  
        clientXml.write('  <command interpreter="python">\n  client_1.py \n'+'  $output \n  ' +resUrl+'\n')
        ##write such that the parameters passed to client1.py(change name to clientName.py) are dependent on a for loop
        
        j=0
        for param in params:
            clientXml.write('  '+self.formatString(param)+'\n')
            clientXml.write('  $param' + str(j)+'\n')            
            j=j+1
        clientXml.write('</command>\n')
        
        ##write inputs depending on required or not. if not required den dont display 
        ##if required- den check default value, and if options exist.Depending on that
        ##decide the type of parameter and options
        clientXml.write('  <inputs>\n') 
        
        j=0
        for param in params:
            clientXml.write('<param format="text" size = "150" name = "param'+str(j)+'"  ')
            clientXml.write('type="text" label="'+param+'" help="see tip below" />\n')
            j=j+1
            
                    
                    
        clientXml.write('</inputs>\n  <outputs>\n    <data format="tabular" name="output" />\n  </outputs>\n')
        
        clientXml.write('  <help>\n')
        
        clientXml.write('** Replace white with ** in all parameter values **\n')
        
        j=0
        for param in params:
            clientXml.write('\n.. class:: infomark\n\n**TIP:** '+ param +' type is ' + paramTypes[j] +'\n')       
        
        clientXml.write('  </help>\n</tool>')
        editor = editToolConfig()
        editor.addTool(clientName)
        
        ##later add help feature
