/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.ListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisedListTranslator<O extends OWLObject> {
    private static final Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());
    private OWLRDFConsumer consumer;
    private ListItemTranslator<O> translator;

    protected OptimisedListTranslator(OWLRDFConsumer consumer, ListItemTranslator<O> translator) {
        this.consumer = consumer;
        this.translator = translator;
    }

    protected OWLRDFConsumer getConsumer() {
        return this.consumer;
    }

    private void translateList(IRI mainNode, List<O> list) {
        IRI firstResource;
        if (!this.consumer.isList(mainNode, true) && logger.isLoggable(Level.FINE)) {
            logger.fine("Untyped list found: " + mainNode);
        }
        if ((firstResource = this.getConsumer().getFirstResource(mainNode, true)) != null) {
            list.add(this.translator.translate(firstResource));
        } else {
            OWLLiteral literal = this.getConsumer().getFirstLiteral(mainNode);
            if (literal != null) {
                list.add(this.translator.translate(literal));
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Possible malformed list: rdf:first triple missing");
            }
        }
        IRI rest = this.getConsumer().getRest(mainNode, true);
        if (rest != null) {
            this.translateList(rest, list);
        }
    }

    public List<O> translateList(IRI mainNode) {
        ArrayList list = new ArrayList();
        this.translateList(mainNode, list);
        return list;
    }

    public Set<O> translateToSet(IRI mainNode) {
        return new HashSet<O>(this.translateList(mainNode));
    }
}

