/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyDomainHandler
extends TriplePredicateHandler {
    public TPPropertyDomainHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isObjectPropertyOnly(subject)) {
            this.translateObjectPropertyDomain(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject)) {
            this.translateDataPropertyDomain(subject, predicate, object);
        } else if (this.getConsumer().isAnnotationProperty(subject)) {
            OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(subject);
            this.addAxiom(this.getDataFactory().getOWLAnnotationPropertyDomainAxiom(prop, object, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else {
            IRI rangeIRI = this.getConsumer().getResourceObject(subject, predicate, false);
            if (this.getConsumer().isDataRange(rangeIRI)) {
                this.translateDataPropertyDomain(subject, predicate, object);
            } else {
                this.translateObjectPropertyDomain(subject, predicate, object);
            }
        }
    }

    private void translateDataPropertyDomain(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLDataPropertyDomainAxiom(this.translateDataProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateObjectPropertyDomain(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom(this.getDataFactory().getOWLObjectPropertyDomainAxiom(this.translateObjectProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

